/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ParameterMetadataProvider {
    private final CriteriaBuilder builder;
    private final Iterator<? extends Parameter> parameters;
    private final List<ParameterMetadata<?>> expressions;
    private final Iterator<Object> bindableParameterValues;
    private final PersistenceProvider persistenceProvider;

    public ParameterMetadataProvider(CriteriaBuilder builder, ParametersParameterAccessor accessor, PersistenceProvider provider) {
        this(builder, (Iterator<Object>)accessor.iterator(), accessor.getParameters(), provider);
    }

    public ParameterMetadataProvider(CriteriaBuilder builder, Parameters<?, ?> parameters, PersistenceProvider provider) {
        this(builder, null, parameters, provider);
    }

    private ParameterMetadataProvider(CriteriaBuilder builder, Iterator<Object> bindableParameterValues, Parameters<?, ?> parameters, PersistenceProvider provider) {
        Assert.notNull((Object)builder);
        Assert.notNull(parameters);
        Assert.notNull((Object)provider);
        this.builder = builder;
        this.parameters = parameters.getBindableParameters().iterator();
        this.expressions = new ArrayList();
        this.bindableParameterValues = bindableParameterValues;
        this.persistenceProvider = provider;
    }

    public List<ParameterMetadata<?>> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public <T> ParameterMetadata<T> next(Part part) {
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    public <T> ParameterMetadata<? extends T> next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterMetadata<T> next(Part part, Class<T> type, Parameter parameter) {
        Assert.notNull(type);
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        ParameterExpression expression = parameter.isExplicitlyNamed() ? this.builder.parameter(reifiedType, parameter.getName()) : this.builder.parameter(reifiedType);
        ParameterMetadata value = new ParameterMetadata(expression, part.getType(), this.bindableParameterValues == null ? ParameterMetadata.PLACEHOLDER : this.bindableParameterValues.next(), this.persistenceProvider);
        this.expressions.add(value);
        return value;
    }

    static class ParameterMetadata<T> {
        static final Object PLACEHOLDER = new Object();
        private final Part.Type type;
        private final ParameterExpression<T> expression;
        private final PersistenceProvider persistenceProvider;

        public ParameterMetadata(ParameterExpression<T> expression, Part.Type type, Object value, PersistenceProvider provider) {
            this.expression = expression;
            this.persistenceProvider = provider;
            this.type = value == null && Part.Type.SIMPLE_PROPERTY.equals((Object)type) ? Part.Type.IS_NULL : type;
        }

        public ParameterExpression<T> getExpression() {
            return this.expression;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        public Object prepare(Object value) {
            Assert.notNull((Object)value);
            switch (this.type) {
                case STARTING_WITH: {
                    return String.format("%s%%", value.toString());
                }
                case ENDING_WITH: {
                    return String.format("%%%s", value.toString());
                }
                case CONTAINING: {
                    return String.format("%%%s%%", value.toString());
                }
            }
            return Collection.class.isAssignableFrom(this.expression.getJavaType()) ? this.persistenceProvider.potentiallyConvertEmptyCollection(ParameterMetadata.toCollection(value)) : value;
        }

        private static Collection<?> toCollection(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (ObjectUtils.isArray((Object)value)) {
                return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            }
            return Collections.singleton(value);
        }
    }
}

