/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.IdClass;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JpaMetamodelEntityInformation<T, ID>
extends JpaEntityInformationSupport<T, ID> {
    private final IdMetadata<T> idMetadata;
    private final SingularAttribute<? super T, ?> versionAttribute;
    private final Metamodel metamodel;
    private final String entityName;

    public JpaMetamodelEntityInformation(Class<T> domainClass, Metamodel metamodel) {
        super(domainClass);
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        this.metamodel = metamodel;
        ManagedType type = metamodel.managedType(domainClass);
        if (type == null) {
            throw new IllegalArgumentException("The given domain class can not be found in the given Metamodel!");
        }
        String string = this.entityName = type instanceof EntityType ? ((EntityType)type).getName() : null;
        if (!(type instanceof IdentifiableType)) {
            throw new IllegalArgumentException("The given domain class does not contain an id attribute!");
        }
        IdentifiableType identifiableType = (IdentifiableType)type;
        this.idMetadata = new IdMetadata(identifiableType);
        this.versionAttribute = JpaMetamodelEntityInformation.findVersionAttribute(identifiableType, metamodel);
    }

    @Override
    public String getEntityName() {
        return this.entityName != null ? this.entityName : super.getEntityName();
    }

    private static <T> SingularAttribute<? super T, ?> findVersionAttribute(IdentifiableType<T> type, Metamodel metamodel) {
        try {
            return type.getVersion(Object.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Set attributes = type.getSingularAttributes();
            for (SingularAttribute attribute : attributes) {
                if (!attribute.isVersion()) continue;
                return attribute;
            }
            Class superType = type.getJavaType().getSuperclass();
            try {
                ManagedType managedSuperType = metamodel.managedType(superType);
                if (!(managedSuperType instanceof IdentifiableType)) {
                    return null;
                }
                return JpaMetamodelEntityInformation.findVersionAttribute((IdentifiableType)managedSuperType, metamodel);
            }
            catch (IllegalArgumentException o_O) {
                return null;
            }
        }
    }

    public ID getId(T entity) {
        DirectFieldAccessFallbackBeanWrapper entityWrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        if (this.idMetadata.hasSimpleId()) {
            return (ID)entityWrapper.getPropertyValue(this.idMetadata.getSimpleIdAttribute().getName());
        }
        IdentifierDerivingDirectFieldAccessFallbackBeanWrapper idWrapper = new IdentifierDerivingDirectFieldAccessFallbackBeanWrapper(this.idMetadata.getType(), this.metamodel);
        boolean partialIdValueFound = false;
        for (SingularAttribute<T, ?> attribute : this.idMetadata) {
            Object propertyValue = entityWrapper.getPropertyValue(attribute.getName());
            if (propertyValue != null) {
                partialIdValueFound = true;
            }
            idWrapper.setPropertyValue(attribute.getName(), propertyValue);
        }
        return (ID)(partialIdValueFound ? idWrapper.getWrappedInstance() : null);
    }

    public Class<ID> getIdType() {
        return this.idMetadata.getType();
    }

    @Override
    public SingularAttribute<? super T, ?> getIdAttribute() {
        return this.idMetadata.getSimpleIdAttribute();
    }

    @Override
    public boolean hasCompositeId() {
        return !this.idMetadata.hasSimpleId();
    }

    @Override
    public Iterable<String> getIdAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>(((IdMetadata)this.idMetadata).attributes.size());
        for (SingularAttribute attribute : ((IdMetadata)this.idMetadata).attributes) {
            attributeNames.add(attribute.getName());
        }
        return attributeNames;
    }

    @Override
    public Object getCompositeIdAttributeValue(Object id, String idAttribute) {
        Assert.isTrue((boolean)this.hasCompositeId(), (String)"Model must have a composite Id!");
        return new DirectFieldAccessFallbackBeanWrapper(id).getPropertyValue(idAttribute);
    }

    public boolean isNew(T entity) {
        if (this.versionAttribute == null || this.versionAttribute.getJavaType().isPrimitive()) {
            return super.isNew(entity);
        }
        DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        Object versionValue = wrapper.getPropertyValue(this.versionAttribute.getName());
        return versionValue == null;
    }

    private static class IdentifierDerivingDirectFieldAccessFallbackBeanWrapper
    extends DirectFieldAccessFallbackBeanWrapper {
        private final Metamodel metamodel;

        public IdentifierDerivingDirectFieldAccessFallbackBeanWrapper(Class<?> type, Metamodel metamodel) {
            super(type);
            this.metamodel = metamodel;
        }

        public void setPropertyValue(String propertyName, Object value) {
            if (!this.isIdentifierDerivationNecessary(value)) {
                super.setPropertyValue(propertyName, value);
                return;
            }
            JpaMetamodelEntityInformation nestedEntityInformation = new JpaMetamodelEntityInformation(value.getClass(), this.metamodel);
            if (!nestedEntityInformation.getJavaType().isAnnotationPresent(IdClass.class)) {
                Object nestedIdPropertyValue = new DirectFieldAccessFallbackBeanWrapper(value).getPropertyValue(nestedEntityInformation.getIdAttribute().getName());
                super.setPropertyValue(propertyName, nestedIdPropertyValue);
                return;
            }
            DirectFieldAccessFallbackBeanWrapper sourceIdValueWrapper = new DirectFieldAccessFallbackBeanWrapper(value);
            BeanWrapperImpl targetIdClassTypeWrapper = new BeanWrapperImpl(nestedEntityInformation.getIdType());
            for (String idAttributeName : nestedEntityInformation.getIdAttributeNames()) {
                targetIdClassTypeWrapper.setPropertyValue(idAttributeName, this.extractActualIdPropertyValue((BeanWrapper)sourceIdValueWrapper, idAttributeName));
            }
            super.setPropertyValue(propertyName, targetIdClassTypeWrapper.getWrappedInstance());
        }

        private Object extractActualIdPropertyValue(BeanWrapper sourceIdValueWrapper, String idAttributeName) {
            Object idPropertyValue = sourceIdValueWrapper.getPropertyValue(idAttributeName);
            if (idPropertyValue != null) {
                Class<?> idPropertyValueType = idPropertyValue.getClass();
                if (ClassUtils.isPrimitiveOrWrapper(idPropertyValueType)) {
                    return idPropertyValue;
                }
                return new DirectFieldAccessFallbackBeanWrapper(idPropertyValue).getPropertyValue(this.tryFindSingularIdAttributeNameOrUseFallback(idPropertyValueType, idAttributeName));
            }
            return null;
        }

        private String tryFindSingularIdAttributeNameOrUseFallback(Class<? extends Object> idPropertyValueType, String fallbackIdTypePropertyName) {
            ManagedType idPropertyType = this.metamodel.managedType(idPropertyValueType);
            for (SingularAttribute sa : idPropertyType.getSingularAttributes()) {
                if (!sa.isId()) continue;
                return sa.getName();
            }
            return fallbackIdTypePropertyName;
        }

        private boolean isIdentifierDerivationNecessary(Object value) {
            if (value == null) {
                return false;
            }
            try {
                ManagedType managedType = this.metamodel.managedType(value.getClass());
                return managedType != null && managedType.getPersistenceType() == Type.PersistenceType.ENTITY;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }

    private static class IdMetadata<T>
    implements Iterable<SingularAttribute<? super T, ?>> {
        private final IdentifiableType<T> type;
        private final Set<SingularAttribute<? super T, ?>> attributes;
        private Class<?> idType;

        public IdMetadata(IdentifiableType<T> source) {
            this.type = source;
            this.attributes = source.hasSingleIdAttribute() ? Collections.singleton(source.getId(source.getIdType().getJavaType())) : source.getIdClassAttributes();
        }

        public boolean hasSimpleId() {
            return this.attributes.size() == 1;
        }

        public Class<?> getType() {
            if (this.idType != null) {
                return this.idType;
            }
            this.idType = this.tryExtractIdTypeWithFallbackToIdTypeLookup();
            return this.idType;
        }

        private Class<?> tryExtractIdTypeWithFallbackToIdTypeLookup() {
            try {
                Type idType2 = this.type.getIdType();
                return idType2 == null ? IdMetadata.fallbackIdTypeLookup(this.type) : idType2.getJavaType();
            }
            catch (IllegalStateException e) {
                return IdMetadata.fallbackIdTypeLookup(this.type);
            }
        }

        private static Class<?> fallbackIdTypeLookup(IdentifiableType<?> type) {
            IdClass annotation = (IdClass)AnnotationUtils.findAnnotation((Class)type.getJavaType(), IdClass.class);
            return annotation == null ? null : annotation.value();
        }

        public SingularAttribute<? super T, ?> getSimpleIdAttribute() {
            return this.attributes.iterator().next();
        }

        @Override
        public Iterator<SingularAttribute<? super T, ?>> iterator() {
            return this.attributes.iterator();
        }
    }
}

