/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarErrorListener;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarException;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.EqlLexer;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.EqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.HqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.HqlLexer;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.HqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.JpqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.JpqlLexer;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.JpqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpaQueryEnhancer
implements QueryEnhancer {
    private final ParserRuleContext context;
    private final ParsedQueryIntrospector introspector;
    private final String projection;
    private final BiFunction<Sort, String, ParseTreeVisitor<? extends Object>> sortFunction;
    private final BiFunction<String, String, ParseTreeVisitor<? extends Object>> countQueryFunction;

    JpaQueryEnhancer(ParserRuleContext context, ParsedQueryIntrospector introspector, @Nullable BiFunction<Sort, String, ParseTreeVisitor<? extends Object>> sortFunction, @Nullable BiFunction<String, String, ParseTreeVisitor<? extends Object>> countQueryFunction) {
        this.context = context;
        this.introspector = introspector;
        this.sortFunction = sortFunction;
        this.countQueryFunction = countQueryFunction;
        this.introspector.visit((ParseTree)context);
        List<QueryToken> tokens = introspector.getProjection();
        this.projection = tokens.isEmpty() ? "" : new QueryRenderer.TokenRenderer(tokens).render();
    }

    static <P extends Parser> ParserRuleContext parse(String query, Function<CharStream, Lexer> lexerFactoryFunction, Function<TokenStream, P> parserFactoryFunction, Function<P, ParserRuleContext> parseFunction) {
        Lexer lexer = lexerFactoryFunction.apply((CharStream)CharStreams.fromString((String)query));
        Parser parser = (Parser)parserFactoryFunction.apply((TokenStream)new CommonTokenStream((TokenSource)lexer));
        JpaQueryEnhancer.configureParser(query, lexer, parser);
        return parseFunction.apply(parser);
    }

    static void configureParser(String query, Lexer lexer, Parser parser) {
        BadJpqlGrammarErrorListener errorListener = new BadJpqlGrammarErrorListener(query);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
    }

    public static JpaQueryEnhancer forJpql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return JpqlQueryParser.parseQuery(query.getQueryString());
    }

    public static JpaQueryEnhancer forHql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return HqlQueryParser.parseQuery(query.getQueryString());
    }

    public static JpaQueryEnhancer forEql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return EqlQueryParser.parseQuery(query.getQueryString());
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.introspector.hasConstructorExpression();
    }

    @Override
    public String detectAlias() {
        return this.introspector.getAlias();
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public Set<String> getJoinAliases() {
        return Set.of();
    }

    @Override
    public DeclaredQuery getQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String applySorting(Sort sort) {
        return QueryRenderer.TokenRenderer.render(this.sortFunction.apply(sort, this.detectAlias()).visit((ParseTree)this.context));
    }

    @Override
    public String applySorting(Sort sort, String alias) {
        return this.applySorting(sort);
    }

    @Override
    public String createCountQueryFor() {
        return this.createCountQueryFor(null);
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        return QueryRenderer.TokenRenderer.render(this.countQueryFunction.apply(countProjection, this.detectAlias()).visit((ParseTree)this.context));
    }

    static class EqlQueryParser
    extends JpaQueryEnhancer {
        private EqlQueryParser(String query) {
            super(EqlQueryParser.parse(query, EqlLexer::new, EqlParser::new, EqlParser::start), new EqlQueryIntrospector(), EqlSortedQueryTransformer::new, EqlCountQueryTransformer::new);
        }

        public static EqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new EqlQueryParser(query);
        }
    }

    static class HqlQueryParser
    extends JpaQueryEnhancer {
        private HqlQueryParser(String query) {
            super(HqlQueryParser.parse(query, HqlLexer::new, HqlParser::new, HqlParser::start), new HqlQueryIntrospector(), HqlSortedQueryTransformer::new, HqlCountQueryTransformer::new);
        }

        public static HqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new HqlQueryParser(query);
        }
    }

    static class JpqlQueryParser
    extends JpaQueryEnhancer {
        private JpqlQueryParser(String query) {
            super(JpqlQueryParser.parse(query, JpqlLexer::new, JpqlParser::new, JpqlParser::start), new JpqlQueryIntrospector(), JpqlSortedQueryTransformer::new, JpqlCountQueryTransformer::new);
        }

        public static JpqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new JpqlQueryParser(query);
        }
    }
}

