/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.LockModeType;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.Meta;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributeSource;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaQueryMethod
extends QueryMethod {
    private static final Set<Class<?>> NATIVE_ARRAY_TYPES = Set.of(byte[].class, Byte[].class, char[].class, Character[].class);
    private static final StoredProcedureAttributeSource storedProcedureAttributeSource = StoredProcedureAttributeSource.INSTANCE;
    private final QueryExtractor extractor;
    private final Method method;
    private final Class<?> returnType;
    @Nullable
    private StoredProcedureAttributes storedProcedureAttributes;
    private final Lazy<LockModeType> lockModeType;
    private final Lazy<QueryHints> queryHints;
    private final Lazy<JpaEntityGraph> jpaEntityGraph;
    private final Lazy<Modifying> modifying;
    private final Lazy<Boolean> isNativeQuery;
    private final Lazy<Boolean> isCollectionQuery;
    private final Lazy<Boolean> isProcedureQuery;
    private final Lazy<JpaEntityMetadata<?>> entityMetadata;
    private final Lazy<Optional<org.springframework.data.jpa.repository.Meta>> metaAnnotation;

    public JpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        this(method, metadata, factory, extractor, JpaParameters::new);
    }

    public JpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor, Function<ParametersSource, JpaParameters> parametersFunction) {
        super(method, metadata, factory, parametersFunction);
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null");
        this.method = method;
        this.returnType = JpaQueryMethod.potentiallyUnwrapReturnTypeFor(metadata, method);
        this.extractor = extractor;
        this.lockModeType = Lazy.of(() -> Optional.ofNullable((Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class)).map(AnnotationUtils::getValue).orElse(null));
        this.queryHints = Lazy.of(() -> (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class));
        this.modifying = Lazy.of(() -> (Modifying)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Modifying.class));
        this.jpaEntityGraph = Lazy.of(() -> {
            EntityGraph entityGraph = (EntityGraph)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class);
            if (entityGraph == null) {
                return null;
            }
            return new JpaEntityGraph(entityGraph, this.getNamedQueryName());
        });
        this.isNativeQuery = Lazy.of(() -> this.getAnnotationValue("nativeQuery", Boolean.class));
        this.isCollectionQuery = Lazy.of(() -> super.isCollectionQuery() && !NATIVE_ARRAY_TYPES.contains(this.returnType));
        this.isProcedureQuery = Lazy.of(() -> AnnotationUtils.findAnnotation((Method)method, Procedure.class) != null);
        this.entityMetadata = Lazy.of(() -> new DefaultJpaEntityMetadata(this.getDomainClass()));
        this.metaAnnotation = Lazy.of(() -> Optional.ofNullable((org.springframework.data.jpa.repository.Meta)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.springframework.data.jpa.repository.Meta.class)));
        if (this.isModifyingQuery() && this.getParameters().hasSpecialParameter()) {
            throw QueryCreationException.create((QueryMethod)this, (String)String.format("Modifying method must not contain %s", Parameters.TYPES));
        }
    }

    private static Class<?> potentiallyUnwrapReturnTypeFor(RepositoryMetadata metadata, Method method) {
        TypeInformation returnType = metadata.getReturnType(method);
        while (QueryExecutionConverters.supports((Class)returnType.getType()) || QueryExecutionConverters.supportsUnwrapping((Class)returnType.getType())) {
            returnType = returnType.getRequiredComponentType();
        }
        return returnType.getType();
    }

    public JpaEntityMetadata<?> getEntityInformation() {
        return (JpaEntityMetadata)this.entityMetadata.get();
    }

    public boolean isModifyingQuery() {
        return this.modifying.getNullable() != null;
    }

    List<QueryHint> getHints() {
        QueryHints hints = (QueryHints)this.queryHints.getNullable();
        if (hints != null) {
            return Arrays.asList(hints.value());
        }
        return Collections.emptyList();
    }

    @Nullable
    LockModeType getLockModeType() {
        return (LockModeType)this.lockModeType.getNullable();
    }

    @Nullable
    JpaEntityGraph getEntityGraph() {
        return (JpaEntityGraph)this.jpaEntityGraph.getNullable();
    }

    boolean applyHintsToCountQuery() {
        QueryHints hints = (QueryHints)this.queryHints.getNullable();
        return hints != null ? hints.forCounting() : false;
    }

    public QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Method getMethod() {
        return this.method;
    }

    Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean hasQueryMetaAttributes() {
        return this.getMetaAnnotation() != null;
    }

    @Nullable
    org.springframework.data.jpa.repository.Meta getMetaAnnotation() {
        return ((Optional)this.metaAnnotation.get()).orElse(null);
    }

    public Meta getQueryMetaAttributes() {
        org.springframework.data.jpa.repository.Meta meta = this.getMetaAnnotation();
        if (meta == null) {
            return new Meta();
        }
        Meta metaAttributes = new Meta();
        if (StringUtils.hasText((String)meta.comment())) {
            metaAttributes.setComment(meta.comment());
        }
        return metaAttributes;
    }

    boolean hasAnnotatedQuery() {
        return StringUtils.hasText((String)this.getAnnotationValue("value", String.class));
    }

    @Nullable
    public String getAnnotatedQuery() {
        String query = this.getAnnotationValue("value", String.class);
        return StringUtils.hasText((String)query) ? query : null;
    }

    boolean hasAnnotatedQueryName() {
        return StringUtils.hasText((String)this.getAnnotationValue("name", String.class));
    }

    public String getRequiredAnnotatedQuery() throws IllegalStateException {
        String query = this.getAnnotatedQuery();
        if (query != null) {
            return query;
        }
        throw new IllegalStateException(String.format("No annotated query found for query method %s", this.getName()));
    }

    public DeclaredQuery getRequiredDeclaredQuery() throws IllegalStateException {
        String query = this.getAnnotatedQuery();
        if (query != null) {
            return this.getDeclaredQuery(query);
        }
        throw new IllegalStateException(String.format("No annotated query found for query method %s", this.getName()));
    }

    @Nullable
    public String getCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText((String)countQuery) ? countQuery : null;
    }

    @Nullable
    public DeclaredQuery getDeclaredCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText((String)countQuery) ? this.getDeclaredQuery(countQuery) : null;
    }

    @Nullable
    String getCountQueryProjection() {
        String countProjection = this.getAnnotationValue("countProjection", String.class);
        return StringUtils.hasText((String)countProjection) ? countProjection : null;
    }

    boolean isNativeQuery() {
        return (Boolean)this.isNativeQuery.get();
    }

    DeclaredQuery getDeclaredQuery(String query) {
        return this.isNativeQuery() ? DeclaredQuery.nativeQuery(query) : DeclaredQuery.jpqlQuery(query);
    }

    public String getNamedQueryName() {
        String annotatedName = this.getAnnotationValue("name", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    public String getNamedCountQueryName() {
        String annotatedName = this.getAnnotationValue("countName", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    boolean getFlushAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("flushAutomatically", Modifying.class, Boolean.class);
    }

    boolean getClearAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("clearAutomatically", Modifying.class, Boolean.class);
    }

    private <T> T getAnnotationValue(String attribute, Class<T> type) {
        return this.getMergedOrDefaultAnnotationValue(attribute, Query.class, type);
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    public JpaParameters getParameters() {
        return (JpaParameters)super.getParameters();
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isProcedureQuery() {
        return (Boolean)this.isProcedureQuery.get();
    }

    StoredProcedureAttributes getProcedureAttributes() {
        if (this.storedProcedureAttributes == null) {
            this.storedProcedureAttributes = storedProcedureAttributeSource.createFrom(this.method, (JpaEntityMetadata<?>)this.getEntityInformation());
        }
        return this.storedProcedureAttributes;
    }

    public Class<? extends QueryRewriter> getQueryRewriter() {
        return this.getMergedOrDefaultAnnotationValue("queryRewriter", Query.class, Class.class);
    }
}

