/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Lazy;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.springframework.util.CollectionUtils;

class AotMetamodel
implements Metamodel {
    private static final Logger log = LoggerFactory.getLogger(AotMetamodel.class);
    private static final Map<String, Object> FAILSAFE_AOT_PROPERTIES = Map.of("hibernate.boot.allow_jdbc_metadata_access", false, "hibernate.connection.provider_class", NoOpConnectionProvider.INSTANCE, "hibernate.query.startup_check", false, "hibernate.jpa_callbacks.enabled", false);
    private final Lazy<EntityManagerFactory> entityManagerFactory;
    private final Lazy<EntityManager> entityManager = Lazy.of(() -> this.getEntityManagerFactory().createEntityManager());

    public AotMetamodel(PersistenceManagedTypes managedTypes, Map<String, Object> jpaProperties) {
        this(managedTypes.getManagedClassNames(), managedTypes.getPersistenceUnitRootUrl(), jpaProperties);
    }

    public AotMetamodel(Collection<String> managedTypes, @Nullable URL persistenceUnitRootUrl, Map<String, Object> jpaProperties) {
        SpringPersistenceUnitInfo persistenceUnitInfo = new SpringPersistenceUnitInfo(managedTypes.getClass().getClassLoader());
        persistenceUnitInfo.setPersistenceUnitName("AotMetamodel");
        persistenceUnitInfo.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        this.entityManagerFactory = AotMetamodel.init(() -> {
            managedTypes.forEach(arg_0 -> ((SpringPersistenceUnitInfo)persistenceUnitInfo).addManagedClassName(arg_0));
            persistenceUnitInfo.setPersistenceProviderClassName(HibernatePersistenceProvider.class.getName());
            return new PersistenceUnitInfoDescriptor(persistenceUnitInfo.asStandardPersistenceUnitInfo());
        }, jpaProperties);
    }

    public AotMetamodel(PersistenceUnitInfo unitInfo, Map<String, Object> jpaProperties) {
        this.entityManagerFactory = AotMetamodel.init(() -> new PersistenceUnitInfoDescriptor(unitInfo), jpaProperties);
    }

    static Lazy<EntityManagerFactory> init(Supplier<PersistenceUnitInfoDescriptor> unitInfo, Map<String, Object> jpaProperties) {
        return Lazy.of(() -> new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)unitInfo.get(), AotMetamodel.initProperties(jpaProperties)).build());
    }

    static Map<String, Object> initProperties(Map<String, Object> jpaProperties) {
        LinkedHashMap properties = CollectionUtils.newLinkedHashMap((int)(jpaProperties.size() + FAILSAFE_AOT_PROPERTIES.size() + 1));
        properties.put("hibernate.dialect", SpringDataJpaAotDialect.INSTANCE);
        properties.putAll(jpaProperties);
        AotMetamodel.applyPropertyOverrides(properties);
        return properties;
    }

    private static void applyPropertyOverrides(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : FAILSAFE_AOT_PROPERTIES.entrySet()) {
            if (log.isDebugEnabled() && properties.containsKey(entry.getKey())) {
                log.debug("Overriding property [%s] with value [%s] for AOT Repository processing.".formatted(entry.getKey(), entry.getValue()));
            }
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    private Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        return this.getMetamodel().entity(cls);
    }

    public EntityType<?> entity(String s) {
        return this.getMetamodel().entity(s);
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        return this.getMetamodel().managedType(cls);
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        return this.getMetamodel().embeddable(cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return this.getMetamodel().getManagedTypes();
    }

    public Set<EntityType<?>> getEntities() {
        return this.getMetamodel().getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.getMetamodel().getEmbeddables();
    }

    public EntityManager entityManager() {
        return (EntityManager)this.entityManager.get();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return (EntityManagerFactory)this.entityManagerFactory.get();
    }

    static class NoOpConnectionProvider
    extends UserSuppliedConnectionProviderImpl {
        static final NoOpConnectionProvider INSTANCE = new NoOpConnectionProvider();

        NoOpConnectionProvider() {
        }

        public String toString() {
            return "NoOpConnectionProvider";
        }
    }

    @NullUnmarked
    static class SpringDataJpaAotDialect
    extends Dialect {
        static SpringDataJpaAotDialect INSTANCE = new SpringDataJpaAotDialect();

        SpringDataJpaAotDialect() {
        }

        public boolean isCurrentTimestampSelectStringCallable() {
            return false;
        }

        public String getCurrentTimestampSelectString() {
            return "call current_timestamp()";
        }

        public LimitHandler getLimitHandler() {
            return OffsetFetchLimitHandler.INSTANCE;
        }

        public SequenceSupport getSequenceSupport() {
            return ANSISequenceSupport.INSTANCE;
        }

        public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
            return new StandardSqlAstTranslatorFactory();
        }

        public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
            if (unit == null) {
                return "(?3-?2)";
            }
            return "datediff(?1,?2,?3)";
        }
    }
}

