/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class SpelPropertyComparator<T>
implements Comparator<T> {
    private static final Comparator<?> NULLS_FIRST = Comparator.nullsFirst(Comparator.naturalOrder());
    private static final Comparator<?> NULLS_LAST = Comparator.nullsLast(Comparator.naturalOrder());
    private final String path;
    private final SpelExpressionParser parser;
    private boolean asc = true;
    private boolean nullsFirst = true;
    private @Nullable SpelExpression expression;

    public SpelPropertyComparator(String path, SpelExpressionParser parser) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null");
        this.path = path;
        this.parser = parser;
    }

    @Contract(value="-> this")
    public SpelPropertyComparator<@Nullable T> asc() {
        this.asc = true;
        return this;
    }

    @Contract(value="-> this")
    public SpelPropertyComparator<@Nullable T> desc() {
        this.asc = false;
        return this;
    }

    @Contract(value="-> this")
    public SpelPropertyComparator<@Nullable T> nullsFirst() {
        this.nullsFirst = true;
        return this;
    }

    @Contract(value="-> this")
    public SpelPropertyComparator<@Nullable T> nullsLast() {
        this.nullsFirst = false;
        return this;
    }

    protected SpelExpression getExpression() {
        if (this.expression == null) {
            this.expression = this.parser.parseRaw(this.buildExpressionForPath());
        }
        return this.expression;
    }

    protected String buildExpressionForPath() {
        return String.format("#comparator.compare(#arg1?.%s,#arg2?.%s)", this.path.replace(".", "?."), this.path.replace(".", "?."));
    }

    @Override
    public int compare(@Nullable T arg1, @Nullable T arg2) {
        SpelExpression expressionToUse = this.getExpression();
        SimpleEvaluationContext ctx = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
        ctx.setVariable("comparator", this.nullsFirst ? NULLS_FIRST : NULLS_LAST);
        ctx.setVariable("arg1", arg1);
        ctx.setVariable("arg2", arg2);
        expressionToUse.setEvaluationContext((EvaluationContext)ctx);
        Integer value = (Integer)expressionToUse.getValue(Integer.class);
        return (value != null ? value : 0) * (this.asc ? 1 : -1);
    }

    public String getPath() {
        return this.path;
    }
}

