/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.CollectionFactory;
import org.springframework.data.map.KeySpaceStore;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

record MapKeySpaceStore(Map<String, Map<Object, Object>> store, Class<? extends Map> keySpaceMapType, int initialCapacity) implements KeySpaceStore
{
    public static final int DEFAULT_INITIAL_CAPACITY = 1000;

    public static KeySpaceStore create() {
        return new MapKeySpaceStore(new ConcurrentHashMap<String, Map<Object, Object>>(100), ConcurrentHashMap.class, 1000);
    }

    public static KeySpaceStore of(Class<? extends Map> mapType) {
        Assert.notNull(mapType, (String)"Store map type must not be null");
        return MapKeySpaceStore.of(CollectionFactory.createMap(mapType, (int)100));
    }

    public static KeySpaceStore of(Map<String, Map<Object, Object>> store) {
        Assert.notNull(store, (String)"Store map must not be null");
        Class userClass = ClassUtils.getUserClass(store);
        return new MapKeySpaceStore(store, userClass, 1000);
    }

    @Override
    public Map<Object, Object> getKeySpace(String keyspace) {
        return this.store.computeIfAbsent(keyspace, k -> CollectionFactory.createMap(this.keySpaceMapType, (int)this.initialCapacity));
    }

    @Override
    public void clear() {
        this.store.values().forEach(Map::clear);
        this.store.clear();
    }
}

