/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.crossstore;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import javax.persistence.EntityManagerFactory;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.crossstore.ChangeSet;
import org.springframework.data.crossstore.ChangeSetBacked;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.ClassUtils;

public class MongoChangeSetPersister
implements ChangeSetPersister<Object> {
    private static final String ENTITY_CLASS = "_entity_class";
    private static final String ENTITY_ID = "_entity_id";
    private static final String ENTITY_FIELD_NAME = "_entity_field_name";
    private static final String ENTITY_FIELD_CLASS = "_entity_field_class";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private MongoTemplate mongoTemplate;
    private EntityManagerFactory entityManagerFactory;

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void getPersistentState(Class<? extends ChangeSetBacked> entityClass, Object id, ChangeSet changeSet) throws DataAccessException, ChangeSetPersister.NotFoundException {
        if (id == null) {
            this.log.debug("Unable to load MongoDB data for null id");
            return;
        }
        String collName = this.getCollectionNameForEntity(entityClass);
        BasicDBObject dbk = new BasicDBObject();
        dbk.put(ENTITY_ID, id);
        dbk.put(ENTITY_CLASS, (Object)entityClass.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading MongoDB data for " + dbk);
        }
        this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>((DBObject)dbk, changeSet){
            private final /* synthetic */ DBObject val$dbk;
            private final /* synthetic */ ChangeSet val$changeSet;
            {
                this.val$dbk = dBObject;
                this.val$changeSet = changeSet;
            }

            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                for (DBObject dbo : collection.find(this.val$dbk)) {
                    String key = (String)dbo.get(MongoChangeSetPersister.ENTITY_FIELD_NAME);
                    if (MongoChangeSetPersister.this.log.isDebugEnabled()) {
                        MongoChangeSetPersister.this.log.debug("Processing key: " + key);
                    }
                    if (this.val$changeSet.getValues().containsKey(key)) continue;
                    String className = (String)dbo.get(MongoChangeSetPersister.ENTITY_FIELD_CLASS);
                    if (className == null) {
                        throw new DataIntegrityViolationException("Unble to convert property " + key + ": Invalid metadata, " + MongoChangeSetPersister.ENTITY_FIELD_CLASS + " not available");
                    }
                    Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Object value = MongoChangeSetPersister.this.mongoTemplate.getConverter().read(clazz, (Object)dbo);
                    if (MongoChangeSetPersister.this.log.isDebugEnabled()) {
                        MongoChangeSetPersister.this.log.debug("Adding to ChangeSet: " + key);
                    }
                    this.val$changeSet.set(key, value);
                }
                return null;
            }
        });
    }

    public Object getPersistentId(ChangeSetBacked entity, ChangeSet cs) throws DataAccessException {
        this.log.debug("getPersistentId called on " + entity);
        if (this.entityManagerFactory == null) {
            throw new DataAccessResourceFailureException("EntityManagerFactory cannot be null");
        }
        return this.entityManagerFactory.getPersistenceUnitUtil().getIdentifier((Object)entity);
    }

    public Object persistState(ChangeSetBacked entity, ChangeSet cs) throws DataAccessException {
        String collName;
        if (cs == null) {
            this.log.debug("Flush: changeset was null, nothing to flush.");
            return 0L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush: changeset: " + cs.getValues());
        }
        if (this.mongoTemplate.getCollection(collName = this.getCollectionNameForEntity(entity.getClass())) == null) {
            this.mongoTemplate.createCollection(collName);
        }
        for (String key : cs.getValues().keySet()) {
            if (key == null || key.startsWith("_") || key.equals("_id")) continue;
            Object value = cs.getValues().get(key);
            BasicDBObject dbQuery = new BasicDBObject();
            dbQuery.put(ENTITY_ID, this.getPersistentId(entity, cs));
            dbQuery.put(ENTITY_CLASS, (Object)entity.getClass().getName());
            dbQuery.put(ENTITY_FIELD_NAME, (Object)key);
            DBObject dbId = (DBObject)this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<DBObject>((DBObject)dbQuery){
                private final /* synthetic */ DBObject val$dbQuery;
                {
                    this.val$dbQuery = dBObject;
                }

                public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                    return collection.findOne(this.val$dbQuery);
                }
            });
            if (value == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Flush: removing: " + dbQuery);
                }
                this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>((DBObject)dbQuery){
                    private final /* synthetic */ DBObject val$dbQuery;
                    {
                        this.val$dbQuery = dBObject;
                    }

                    public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                        collection.remove(this.val$dbQuery);
                        return null;
                    }
                });
                continue;
            }
            BasicDBObject dbDoc = new BasicDBObject();
            dbDoc.putAll((BSONObject)dbQuery);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Flush: saving: " + dbQuery);
            }
            this.mongoTemplate.getConverter().write(value, (Object)dbDoc);
            dbDoc.put(ENTITY_FIELD_CLASS, (Object)value.getClass().getName());
            if (dbId != null) {
                dbDoc.put("_id", dbId.get("_id"));
            }
            this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>((DBObject)dbDoc){
                private final /* synthetic */ DBObject val$dbDoc;
                {
                    this.val$dbDoc = dBObject;
                }

                public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                    collection.save(this.val$dbDoc);
                    return null;
                }
            });
        }
        return 0L;
    }

    private String getCollectionNameForEntity(Class<? extends ChangeSetBacked> entityClass) {
        return this.mongoTemplate.getCollectionName(entityClass);
    }
}

