/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.support.IndexEnsuringQueryCreationListener;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private MongoTemplate template;
    private boolean createIndexesForQueryMethods = false;

    public void setTemplate(MongoTemplate template) {
        this.template = template;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.getFactoryInstance(this.template);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener((QueryCreationListener)new IndexEnsuringQueryCreationListener(this.template));
        }
        return factory;
    }

    protected RepositoryFactorySupport getFactoryInstance(MongoTemplate template) {
        return new MongoRepositoryFactory(template);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.template, (String)"MongoTemplate must not be null!");
    }
}

