/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMongoRepository<T, ID extends Serializable>
implements PagingAndSortingRepository<T, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public SimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public T save(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
        return entity;
    }

    public List<T> save(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        ArrayList<T> result = new ArrayList<T>();
        for (T entity : entities) {
            this.save(entity);
            result.add(entity);
        }
        return result;
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.findById(id, this.entityInformation.getJavaType());
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.findOne(new Query(Criteria.where("_id").is(id)), Object.class, this.entityInformation.getCollectionName()) != null;
    }

    public long count() {
        return this.mongoOperations.getCollection(this.entityInformation.getCollectionName()).count();
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName());
    }

    public List<T> findAll() {
        return this.findAll(new Query());
    }

    public Page<T> findAll(Pageable pageable) {
        Long count = this.count();
        List<T> list = this.findAll(QueryUtils.applyPagination(new Query(), pageable));
        return new PageImpl(list, pageable, count.longValue());
    }

    public List<T> findAll(Sort sort) {
        return this.findAll(QueryUtils.applySorting(new Query(), sort));
    }

    public List<T> findAll(Iterable<ID> ids) {
        Query query = null;
        ArrayList<Serializable> idList = new ArrayList<Serializable>();
        for (Serializable id : ids) {
            idList.add(id);
        }
        query = new Query(Criteria.where(this.entityInformation.getIdAttribute()).in(idList));
        return this.findAll(query);
    }

    private List<T> findAll(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    protected MongoOperations getMongoOperations() {
        return this.mongoOperations;
    }

    protected MongoEntityInformation<T, ID> getEntityInformation() {
        return this.entityInformation;
    }
}

