/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapper {
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private static final String N_OR_PATTERN = "\\$.*or";
    private final ConversionService conversionService;
    private final MongoConverter converter;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter);
        this.conversionService = converter.getConversionService();
        this.converter = converter;
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        BasicDBObject newDbo = new BasicDBObject();
        Iterator i$ = query.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String newKey = key = (String)i$.next();
            Object value = query.get(key);
            if (this.isIdKey(key, entity)) {
                if (value instanceof DBObject) {
                    DBObject valueDbo = (DBObject)value;
                    if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                        String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                        ArrayList<Object> ids = new ArrayList<Object>();
                        for (Object id : (Iterable)valueDbo.get(inKey)) {
                            ids.add(this.convertId(id));
                        }
                        valueDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                    } else {
                        value = this.getMappedObject((DBObject)value, null);
                    }
                } else {
                    value = this.convertId(value);
                }
                newKey = "_id";
            } else if (key.matches(N_OR_PATTERN)) {
                Iterable conditions = (Iterable)value;
                BasicBSONList newConditions = new BasicBSONList();
                Iterator iter = conditions.iterator();
                while (iter.hasNext()) {
                    newConditions.add((Object)this.getMappedObject((DBObject)iter.next(), null));
                }
                value = newConditions;
            } else if (key.equals("$ne")) {
                value = this.convertId(value);
            }
            newDbo.put(newKey, this.convertSimpleOrDBObject(value, null));
        }
        return newDbo;
    }

    private Object convertSimpleOrDBObject(Object source, MongoPersistentEntity<?> entity) {
        if (source instanceof BasicDBList) {
            return this.converter.convertToMongoType(source);
        }
        if (source instanceof DBObject) {
            return this.getMappedObject((DBObject)source, entity);
        }
        return this.converter.convertToMongoType(source);
    }

    private boolean isIdKey(String key, MongoPersistentEntity<?> entity) {
        if (entity == null) {
            return false;
        }
        if (entity.getIdProperty() != null) {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
            return idProperty.getName().equals(key) || idProperty.getFieldName().equals(key);
        }
        return DEFAULT_ID_NAMES.contains(key);
    }

    public Object convertId(Object id) {
        try {
            return this.conversionService.convert(id, ObjectId.class);
        }
        catch (ConversionException conversionException) {
            return this.converter.convertToMongoType(id);
        }
    }
}

