/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.SerializationUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private LinkedHashMap<String, Criteria> criteria = new LinkedHashMap();
    private Field fieldSpec;
    private Sort sort;
    private int skip;
    private int limit;
    private String hint;

    public static Query query(Criteria critera) {
        return new Query(critera);
    }

    public Query() {
    }

    public Query(Criteria criteria) {
        this.addCriteria(criteria);
    }

    public Query addCriteria(Criteria criteria) {
        CriteriaDefinition existing = this.criteria.get(criteria.getKey());
        String key = criteria.getKey();
        if (existing != null) {
            throw new InvalidMongoDbApiUsageException("Due to limitations of the com.mongodb.BasicDBObject, you can't add a second '" + key + "' criteria. " + "Query already contains '" + existing.getCriteriaObject() + "'.");
        }
        this.criteria.put(key, criteria);
        return this;
    }

    public Field fields() {
        if (this.fieldSpec == null) {
            this.fieldSpec = new Field();
        }
        return this.fieldSpec;
    }

    public Query skip(int skip) {
        this.skip = skip;
        return this;
    }

    public Query limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query withHint(String name) {
        Assert.hasText((String)name, (String)"Hint must not be empty or null!");
        this.hint = name;
        return this;
    }

    public Sort sort() {
        if (this.sort == null) {
            this.sort = new Sort();
        }
        return this.sort;
    }

    public DBObject getQueryObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.criteria.keySet()) {
            CriteriaDefinition c = this.criteria.get(k);
            DBObject cl = c.getCriteriaObject();
            dbo.putAll((BSONObject)cl);
        }
        return dbo;
    }

    public DBObject getFieldsObject() {
        if (this.fieldSpec == null) {
            return null;
        }
        return this.fieldSpec.getFieldsObject();
    }

    public DBObject getSortObject() {
        if (this.sort == null) {
            return null;
        }
        return this.sort.getSortObject();
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getHint() {
        return this.hint;
    }

    protected List<Criteria> getCriteria() {
        return new ArrayList<Criteria>(this.criteria.values());
    }

    public String toString() {
        return String.format("Query: %s, Fields: %s, Sort: %s", SerializationUtils.serializeToJsonSafely(this.getQueryObject()), SerializationUtils.serializeToJsonSafely(this.getFieldsObject()), SerializationUtils.serializeToJsonSafely(this.getSortObject()));
    }

    public boolean equals(Object obj) {
        boolean sortEqual;
        boolean fieldsEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Query that = (Query)obj;
        boolean criteriaEqual = this.criteria.equals(that.criteria);
        boolean bl = this.fieldSpec == null ? that.fieldSpec == null : (fieldsEqual = this.fieldSpec.equals(that.fieldSpec));
        boolean bl2 = this.sort == null ? that.sort == null : (sortEqual = this.sort.equals(that.sort));
        boolean hintEqual = this.hint == null ? that.hint == null : this.hint.equals(that.hint);
        boolean skipEqual = this.skip == that.skip;
        boolean limitEqual = this.limit == that.limit;
        return criteriaEqual && fieldsEqual && sortEqual && hintEqual && skipEqual && limitEqual;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.criteria.hashCode();
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.fieldSpec);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.sort);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.hint);
        result += 31 * this.skip;
        return result += 31 * this.limit;
    }
}

