/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.index.IndexField;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfo {
    private final List<IndexField> indexFields;
    private final String name;
    private final boolean unique;
    private final boolean dropDuplicates;
    private final boolean sparse;

    public IndexInfo(List<IndexField> indexFields, String name, boolean unique, boolean dropDuplicates, boolean sparse) {
        this.indexFields = Collections.unmodifiableList(indexFields);
        this.name = name;
        this.unique = unique;
        this.dropDuplicates = dropDuplicates;
        this.sparse = sparse;
    }

    public List<IndexField> getIndexFields() {
        return this.indexFields;
    }

    public boolean isIndexForFields(Collection<String> keys) {
        Assert.notNull(keys);
        ArrayList<String> indexKeys = new ArrayList<String>(this.indexFields.size());
        for (IndexField field : this.indexFields) {
            indexKeys.add(field.getKey());
        }
        return indexKeys.containsAll(keys);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isDropDuplicates() {
        return this.dropDuplicates;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public String toString() {
        return "IndexInfo [indexFields=" + this.indexFields + ", name=" + this.name + ", unique=" + this.unique + ", dropDuplicates=" + this.dropDuplicates + ", sparse=" + this.sparse + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dropDuplicates ? 1231 : 1237);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.indexFields);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sparse ? 1231 : 1237);
        result = 31 * result + (this.unique ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexInfo other = (IndexInfo)obj;
        if (this.dropDuplicates != other.dropDuplicates) {
            return false;
        }
        if (this.indexFields == null ? other.indexFields != null : !((Object)this.indexFields).equals(other.indexFields)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sparse != other.sparse) {
            return false;
        }
        return this.unique == other.unique;
    }
}

