/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class ProjectionOperation
extends ExposedFieldsAggregationOperationContext
implements AggregationOperation {
    private static final List<Projection> NONE = Collections.emptyList();
    private final List<Projection> projections;

    public ProjectionOperation() {
        this(NONE, NONE);
    }

    public ProjectionOperation(Fields fields) {
        this(NONE, ProjectionOperationBuilder.FieldProjection.from(fields, true));
    }

    private ProjectionOperation(List<? extends Projection> current, List<? extends Projection> projections) {
        Assert.notNull(current, (String)"Current projections must not be null!");
        Assert.notNull(projections, (String)"Projections must not be null!");
        this.projections = new ArrayList<Projection>(current.size() + projections.size());
        this.projections.addAll(current);
        this.projections.addAll(projections);
    }

    private ProjectionOperation and(Projection projection) {
        return new ProjectionOperation(this.projections, Arrays.asList(projection));
    }

    private ProjectionOperation andReplaceLastOneWith(Projection projection) {
        List projections = this.projections.isEmpty() ? Collections.emptyList() : this.projections.subList(0, this.projections.size() - 1);
        return new ProjectionOperation(projections, Arrays.asList(projection));
    }

    public ProjectionOperationBuilder and(String name) {
        return new ProjectionOperationBuilder(name, this, null);
    }

    public ProjectionOperation andExclude(String ... fields) {
        List<ProjectionOperationBuilder.FieldProjection> excludeProjections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fields), false);
        return new ProjectionOperation(this.projections, excludeProjections);
    }

    public ProjectionOperation andInclude(String ... fields) {
        List<ProjectionOperationBuilder.FieldProjection> projections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fields), true);
        return new ProjectionOperation(this.projections, projections);
    }

    public ProjectionOperation andInclude(Fields fields) {
        return new ProjectionOperation(this.projections, ProjectionOperationBuilder.FieldProjection.from(fields, true));
    }

    @Override
    protected ExposedFields getFields() {
        ExposedFields fields = null;
        for (Projection projection : this.projections) {
            ExposedFields.ExposedField field = projection.getExposedField();
            fields = fields == null ? ExposedFields.from(field) : fields.and(field);
        }
        return fields;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject fieldObject = new BasicDBObject();
        for (Projection projection : this.projections) {
            fieldObject.putAll((BSONObject)projection.toDBObject(context));
        }
        return new BasicDBObject("$project", (Object)fieldObject);
    }

    private static abstract class Projection {
        private final ExposedFields.ExposedField field;

        public Projection(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        public ExposedFields.ExposedField getExposedField() {
            return this.field;
        }

        public abstract DBObject toDBObject(AggregationOperationContext var1);
    }

    public static class ProjectionOperationBuilder
    implements AggregationOperation {
        private final String name;
        private final ProjectionOperation operation;
        private final OperationProjection previousProjection;

        public ProjectionOperationBuilder(String name, ProjectionOperation operation, OperationProjection previousProjection) {
            Assert.hasText((String)name, (String)"Field name must not be null or empty!");
            Assert.notNull((Object)operation, (String)"ProjectionOperation must not be null!");
            this.name = name;
            this.operation = operation;
            this.previousProjection = previousProjection;
        }

        public ProjectionOperation previousOperation() {
            return this.operation.andExclude(Fields.UNDERSCORE_ID).and(new PreviousOperationProjection(this.name));
        }

        public ProjectionOperation nested(Fields fields) {
            return this.operation.and(new NestedFieldProjection(this.name, fields));
        }

        public ProjectionOperation as(String alias) {
            if (this.previousProjection != null) {
                return this.operation.andReplaceLastOneWith(this.previousProjection.withAlias(alias));
            }
            return this.operation.and(new FieldProjection(Fields.field(alias, this.name), null));
        }

        public ProjectionOperationBuilder plus(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("add", number);
        }

        public ProjectionOperationBuilder minus(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("subtract", number);
        }

        public ProjectionOperationBuilder multiply(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            return this.project("multiply", number);
        }

        public ProjectionOperationBuilder divide(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("divide", number);
        }

        public ProjectionOperationBuilder mod(Number number) {
            Assert.notNull((Object)number, (String)"Number must not be null!");
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("mod", number);
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return this.operation.toDBObject(context);
        }

        public ProjectionOperationBuilder project(String operation, Object ... values) {
            OperationProjection projectionOperation = new OperationProjection(Fields.field(this.name), operation, values);
            return new ProjectionOperationBuilder(this.name, this.operation.and(projectionOperation), projectionOperation);
        }

        static class NestedFieldProjection
        extends Projection {
            private final String name;
            private final Fields fields;

            public NestedFieldProjection(String name, Fields fields) {
                super(Fields.field(name));
                this.name = name;
                this.fields = fields;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBObject nestedObject = new BasicDBObject();
                for (Field field : this.fields) {
                    nestedObject.put(field.getName(), (Object)context.getReference(field.getTarget()).toString());
                }
                return new BasicDBObject(this.name, (Object)nestedObject);
            }
        }

        static class OperationProjection
        extends Projection {
            private final Field field;
            private final String operation;
            private final List<Object> values;

            public OperationProjection(Field field, String operation, Object[] values) {
                super(field);
                Assert.hasText((String)operation, (String)"Operation must not be null or empty!");
                Assert.notNull((Object)values, (String)"Values must not be null!");
                this.field = field;
                this.operation = operation;
                this.values = Arrays.asList(values);
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBList values = new BasicDBList();
                values.addAll(this.buildReferences(context));
                BasicDBObject inner = new BasicDBObject("$" + this.operation, (Object)values);
                return new BasicDBObject(this.field.getName(), (Object)inner);
            }

            private List<Object> buildReferences(AggregationOperationContext context) {
                ArrayList<Object> result = new ArrayList<Object>(this.values.size());
                result.add(context.getReference(this.field.getTarget()).toString());
                for (Object element : this.values) {
                    result.add(element instanceof Field ? context.getReference((Field)element).toString() : element);
                }
                return result;
            }

            public OperationProjection withAlias(String alias) {
                return new OperationProjection(Fields.field(alias, this.field.getName()), this.operation, this.values.toArray());
            }
        }

        static class FieldProjection
        extends Projection {
            private final Field field;
            private final Object value;

            public FieldProjection(String name, Object value) {
                this(Fields.field(name), value);
            }

            private FieldProjection(Field field, Object value) {
                super(field);
                this.field = field;
                this.value = value;
            }

            public static List<FieldProjection> from(Fields fields, boolean include) {
                Assert.notNull((Object)fields, (String)"Fields must not be null!");
                ArrayList<FieldProjection> projections = new ArrayList<FieldProjection>();
                for (Field field : fields) {
                    projections.add(new FieldProjection(field, (Object)(include ? null : Integer.valueOf(0))));
                }
                return projections;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                if (this.value != null) {
                    return new BasicDBObject(this.field.getName(), this.value);
                }
                ExposedFields.FieldReference reference = context.getReference(this.field.getTarget());
                return new BasicDBObject(this.field.getName(), (Object)reference.toString());
            }
        }

        static class PreviousOperationProjection
        extends Projection {
            private final String name;

            public PreviousOperationProjection(String name) {
                super(Fields.field(name));
                this.name = name;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.name, (Object)Fields.UNDERSCORE_ID_REF);
            }
        }
    }
}

