/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class MongoQueryCreator
extends AbstractQueryCreator<Query, Criteria> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoQueryCreator.class);
    private final MongoParameterAccessor accessor;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context) {
        this(tree, accessor, context, false);
    }

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context, boolean isGeoNearQuery) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull(context);
        this.accessor = accessor;
        this.isGeoNearQuery = isGeoNearQuery;
        this.context = context;
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        if (this.isGeoNearQuery && part.getType().equals((Object)Part.Type.NEAR)) {
            return null;
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        Criteria criteria = this.from(part.getType(), property, Criteria.where(path.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return criteria;
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        return this.from(part.getType(), property, base.and(path.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        Criteria result = new Criteria();
        return result.orOperator(base, criteria);
    }

    protected Query complete(Criteria criteria, Sort sort) {
        if (criteria == null) {
            return null;
        }
        Query query = new Query(criteria).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + query);
        }
        return query;
    }

    private Criteria from(Part.Type type, MongoPersistentProperty property, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return criteria.gt(parameters.nextConverted(property));
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.nextConverted(property));
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lt(parameters.nextConverted(property));
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.nextConverted(property));
            }
            case BETWEEN: {
                return criteria.gt(parameters.nextConverted(property)).lt(parameters.nextConverted(property));
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return criteria.nin(this.nextAsArray(parameters, property));
            }
            case IN: {
                return criteria.in(this.nextAsArray(parameters, property));
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: 
            case CONTAINING: {
                String value = parameters.next().toString();
                return criteria.regex(this.toLikeRegex(value, type));
            }
            case REGEX: {
                return criteria.regex(parameters.next().toString());
            }
            case EXISTS: {
                return criteria.exists((Boolean)parameters.next());
            }
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case NEAR: {
                Distance distance = this.accessor.getMaxDistance();
                Point point = this.accessor.getGeoNearLocation();
                Point point2 = point = point == null ? this.nextAs(parameters, Point.class) : point;
                if (distance == null) {
                    return criteria.near(point);
                }
                if (distance.getMetric() != null) {
                    criteria.nearSphere(point);
                } else {
                    criteria.near(point);
                }
                criteria.maxDistance(distance.getNormalizedValue());
                return criteria;
            }
            case WITHIN: {
                Object parameter = parameters.next();
                return criteria.within((Shape)parameter);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(parameters.nextConverted(property));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.ne(parameters.nextConverted(property));
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (parameter.getClass().isAssignableFrom(type)) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s!", type, parameter.getClass()));
    }

    private Object[] nextAsArray(ConvertingParameterAccessor.PotentiallyConvertingIterator iterator, MongoPersistentProperty property) {
        Object next = iterator.nextConverted(property);
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    private String toLikeRegex(String source, Part.Type type) {
        switch (type) {
            case STARTING_WITH: {
                source = "^" + source;
                break;
            }
            case ENDING_WITH: {
                source = source + "$";
                break;
            }
            case CONTAINING: {
                source = "*" + source + "*";
                break;
            }
        }
        return source.replaceAll("\\*", ".*");
    }
}

