/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;
import org.springframework.util.CompositeIterator;

public class ExposedFields
implements Iterable<ExposedField> {
    private static final List<ExposedField> NO_FIELDS = Collections.emptyList();
    private static final ExposedFields EMPTY = new ExposedFields(NO_FIELDS, NO_FIELDS);
    private final List<ExposedField> originalFields;
    private final List<ExposedField> syntheticFields;

    public static ExposedFields from(ExposedField ... fields) {
        return ExposedFields.from(Arrays.asList(fields));
    }

    private static ExposedFields from(List<ExposedField> fields) {
        ExposedFields result = EMPTY;
        for (ExposedField field : fields) {
            result = result.and(field);
        }
        return result;
    }

    public static ExposedFields synthetic(Fields fields) {
        return ExposedFields.createFields(fields, true);
    }

    public static ExposedFields nonSynthetic(Fields fields) {
        return ExposedFields.createFields(fields, false);
    }

    private static ExposedFields createFields(Fields fields, boolean synthetic) {
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        ArrayList<ExposedField> result = new ArrayList<ExposedField>();
        for (Field field : fields) {
            result.add(new ExposedField(field, synthetic));
        }
        return ExposedFields.from(result);
    }

    private ExposedFields(List<ExposedField> originals, List<ExposedField> synthetic) {
        this.originalFields = originals;
        this.syntheticFields = synthetic;
    }

    public ExposedFields and(ExposedField field) {
        Assert.notNull((Object)field, (String)"Exposed field must not be null!");
        ArrayList<ExposedField> result = new ArrayList<ExposedField>();
        result.addAll(field.synthetic ? this.syntheticFields : this.originalFields);
        result.add(field);
        return new ExposedFields(field.synthetic ? this.originalFields : result, field.synthetic ? result : this.syntheticFields);
    }

    public ExposedField getField(String name) {
        for (ExposedField field : this) {
            if (!field.canBeReferredToBy(name)) continue;
            return field;
        }
        return null;
    }

    boolean exposesNoNonSyntheticFields() {
        return this.originalFields.isEmpty();
    }

    boolean exposesSingleNonSyntheticFieldOnly() {
        return this.originalFields.size() == 1;
    }

    boolean exposesNoFields() {
        return this.exposedFieldsCount() == 0;
    }

    boolean exposesSingleFieldOnly() {
        return this.exposedFieldsCount() == 1;
    }

    private int exposedFieldsCount() {
        return this.originalFields.size() + this.syntheticFields.size();
    }

    @Override
    public Iterator<ExposedField> iterator() {
        CompositeIterator iterator = new CompositeIterator();
        iterator.add(this.syntheticFields.iterator());
        iterator.add(this.originalFields.iterator());
        return iterator;
    }

    static class FieldReference {
        private final ExposedField field;

        public FieldReference(ExposedField field) {
            Assert.notNull((Object)field, (String)"ExposedField must not be null!");
            this.field = field;
        }

        public String getRaw() {
            String target = this.field.getTarget();
            return this.field.synthetic ? target : String.format("%s.%s", Fields.UNDERSCORE_ID, target);
        }

        public Object getReferenceValue() {
            return this.field.synthetic && !this.field.isAliased() ? Integer.valueOf(1) : this.toString();
        }

        public String toString() {
            return String.format("$%s", this.getRaw());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FieldReference)) {
                return false;
            }
            FieldReference that = (FieldReference)obj;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }

    static class ExposedField
    implements Field {
        private final boolean synthetic;
        private final Field field;

        public ExposedField(String key, boolean synthetic) {
            this(Fields.field(key), synthetic);
        }

        public ExposedField(Field delegate, boolean synthetic) {
            this.field = delegate;
            this.synthetic = synthetic;
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public String getTarget() {
            return this.field.getTarget();
        }

        @Override
        public boolean isAliased() {
            return this.field.isAliased();
        }

        public boolean canBeReferredToBy(String input) {
            return this.getTarget().equals(input);
        }

        public String toString() {
            return String.format("AggregationField: %s, synthetic: %s", this.field, this.synthetic);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExposedField)) {
                return false;
            }
            ExposedField that = (ExposedField)obj;
            return this.field.equals(that.field) && this.synthetic == that.synthetic;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.field.hashCode();
            return result += 31 * (this.synthetic ? 0 : 1);
        }
    }
}

