/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.Assert;

public class Box
implements Shape {
    @Field(order=10)
    private final Point first;
    @Field(order=20)
    private final Point second;

    public Box(Point lowerLeft, Point upperRight) {
        Assert.notNull((Object)lowerLeft);
        Assert.notNull((Object)upperRight);
        this.first = lowerLeft;
        this.second = upperRight;
    }

    public Box(double[] lowerLeft, double[] upperRight) {
        Assert.isTrue((lowerLeft.length == 2 ? 1 : 0) != 0, (String)"Point array has to have 2 elements!");
        Assert.isTrue((upperRight.length == 2 ? 1 : 0) != 0, (String)"Point array has to have 2 elements!");
        this.first = new Point(lowerLeft[0], lowerLeft[1]);
        this.second = new Point(upperRight[0], upperRight[1]);
    }

    public Point getLowerLeft() {
        return this.first;
    }

    public Point getUpperRight() {
        return this.second;
    }

    @Override
    public List<? extends Object> asList() {
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        list.add(this.getLowerLeft().asList());
        list.add(this.getUpperRight().asList());
        return list;
    }

    @Override
    public String getCommand() {
        return "$box";
    }

    public String toString() {
        return String.format("Box [%s, %s]", this.first, this.second);
    }

    public int hashCode() {
        int result = 31;
        result += 17 * this.first.hashCode();
        return result += 17 * this.second.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Box that = (Box)obj;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }
}

