/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CollectionFactory;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DBObjectAccessor;
import org.springframework.data.mongodb.core.convert.DBObjectPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware,
ValueResolver {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions. Parent object was: %4$s";
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected ApplicationContext applicationContext;
    protected MongoTypeMapper typeMapper;
    protected String mapKeyDotReplacement = null;
    private SpELContext spELContext;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super((GenericConversionService)new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DBObjectPropertyAccessor.INSTANCE);
    }

    @Deprecated
    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
    }

    public void setTypeMapper(MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setMapKeyDotReplacement(String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read((TypeInformation<S>)ClassTypeInformation.from(clazz), dbo);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        return this.read(type, dbo, ObjectPath.ROOT);
    }

    private <S> S read(TypeInformation<S> type, DBObject dbo, ObjectPath path) {
        if (null == dbo) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(dbo, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(dbo.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)dbo;
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            return (S)this.readCollectionOrArray(typeToUse, (BasicDBList)dbo, path);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, dbo, path);
        }
        if (dbo instanceof BasicDBList) {
            throw new MappingException(String.format(INCOMPATIBLE_TYPES, dbo, BasicDBList.class, typeToUse.getType(), path));
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo, path);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(MongoPersistentEntity<?> entity, DBObject source, DefaultSpELExpressionEvaluator evaluator, ObjectPath path) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(source, (SpELExpressionEvaluator)evaluator, path);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, path.getCurrentObject());
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider, path);
    }

    private <S> S read(final MongoPersistentEntity<S> entity, final DBObject dbo, ObjectPath path) {
        final DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)dbo, this.spELContext);
        ParameterValueProvider<MongoPersistentProperty> provider = this.getParameterProvider(entity, dbo, evaluator, path);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        Object result = instance;
        Object idValue = null;
        if (idProperty != null) {
            idValue = this.getValueInternal(idProperty, dbo, (SpELExpressionEvaluator)evaluator, path);
            accessor.setProperty((PersistentProperty)idProperty, idValue);
        }
        final ObjectPath currentPath = path.push(result, entity, idValue);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>((PersistentPropertyAccessor)accessor, evaluator, currentPath){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            final /* synthetic */ DefaultSpELExpressionEvaluator val$evaluator;
            final /* synthetic */ ObjectPath val$currentPath;
            {
                this.val$accessor = persistentPropertyAccessor;
                this.val$evaluator = defaultSpELExpressionEvaluator;
                this.val$currentPath = objectPath;
            }

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (idProperty != null && idProperty.equals(prop)) {
                    return;
                }
                if (!dbo.containsField(prop.getFieldName()) || entity.isConstructorArgument(prop)) {
                    return;
                }
                this.val$accessor.setProperty((PersistentProperty)prop, MappingMongoConverter.this.getValueInternal(prop, dbo, (SpELExpressionEvaluator)this.val$evaluator, this.val$currentPath));
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>((PersistentPropertyAccessor)accessor){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            {
                this.val$accessor = persistentPropertyAccessor;
            }

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
                Object value = dbo.get(property.getFieldName());
                if (value == null) {
                    return;
                }
                com.mongodb.DBRef dbref = value instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)value : null;
                DefaultDbRefProxyHandler handler = new DefaultDbRefProxyHandler(MappingMongoConverter.this.spELContext, MappingMongoConverter.this.mappingContext, MappingMongoConverter.this);
                DefaultDbRefResolverCallback callback = new DefaultDbRefResolverCallback(dbo, currentPath, (SpELExpressionEvaluator)evaluator, MappingMongoConverter.this);
                this.val$accessor.setProperty((PersistentProperty)property, MappingMongoConverter.this.dbRefResolver.resolveDbRef(property, dbref, callback, handler));
            }
        });
        return (S)result;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, MongoPersistentProperty referingProperty) {
        DBRef annotation = null;
        if (referingProperty != null) {
            annotation = referingProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        if (object instanceof LazyLoadingProxy) {
            return ((LazyLoadingProxy)object).toDBRef();
        }
        return this.createDBRef(object, referingProperty);
    }

    public void write(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        boolean handledByCustomConverter = this.conversions.getCustomWriteTarget(entityType, DBObject.class) != null;
        ClassTypeInformation type = ClassTypeInformation.from(entityType);
        if (!handledByCustomConverter && !(dbo instanceof BasicDBList)) {
            this.typeMapper.writeType((TypeInformation)type, dbo);
        }
        Object target = obj instanceof LazyLoadingProxy ? ((LazyLoadingProxy)obj).getTarget() : obj;
        this.writeInternal(target, dbo, (TypeInformation<?>)type);
    }

    protected void writeInternal(Object obj, DBObject dbo, TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Class<?> customTarget = this.conversions.getCustomWriteTarget(entityType, DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, dbo, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, (TypeInformation<?>)ClassTypeInformation.LIST, (BasicDBList)dbo);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        this.writeInternal(obj, dbo, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, dbo);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            try {
                Object id = accessor.getProperty((PersistentProperty)idProperty);
                dbo.put("_id", this.idMapper.convertId(id));
            }
            catch (ConversionException ignored) {
                // empty catch block
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (prop.equals(idProperty) || !prop.isWritable()) {
                    return;
                }
                Object propertyObj = accessor.getProperty((PersistentProperty)prop);
                if (null != propertyObj) {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(propertyObj, dbo, prop);
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object propertyObj = accessor.getProperty((PersistentProperty)inverseProp);
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, inverseProp);
                }
            }
        });
    }

    protected void writePropertyInternal(Object obj, DBObject dbo, MongoPersistentProperty prop) {
        Class<?> basicTargetType;
        if (obj == null) {
            return;
        }
        DBObjectAccessor accessor = new DBObjectAccessor(dbo);
        ClassTypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            DBObject collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            DBObject mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                dbRefObj = ((LazyLoadingProxy)obj).toDBRef();
            }
            com.mongodb.DBRef dBRef = dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            if (null != dbRefObj) {
                accessor.put(prop, dbRefObj);
                return;
            }
        }
        if (obj instanceof LazyLoadingProxy) {
            obj = ((LazyLoadingProxy)obj).getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null)) != null) {
            accessor.put(prop, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        Object existingValue = accessor.get(prop);
        BasicDBObject propDbObj = existingValue instanceof BasicDBObject ? (BasicDBObject)existingValue : new BasicDBObject();
        this.addCustomTypeKeyIfNecessary((TypeInformation<?>)ClassTypeInformation.from((Class)prop.getRawType()), obj, (DBObject)propDbObj);
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        this.writeInternal(obj, (DBObject)propDbObj, entity);
        accessor.put(prop, propDbObj);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected DBObject createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new BasicDBList());
        }
        BasicDBList dbList = new BasicDBList();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add((Object)dbRef);
        }
        return dbList;
    }

    protected DBObject createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        if (!property.isDbReference()) {
            return this.writeMapInternal(map, (DBObject)new BasicDBObject(), property.getTypeInformation());
        }
        BasicDBObject dbObject = new BasicDBObject();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                dbObject.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbObject;
    }

    private BasicDBList writeCollectionInternal(Collection<?> source, TypeInformation<?> type, BasicDBList sink) {
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                sink.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                sink.add((Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(element), componentType, new BasicDBList()));
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, componentType);
            sink.add((Object)propDbObj);
        }
        return sink;
    }

    protected DBObject writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, dbo, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    dbo.put(simpleKey, (Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(val), propertyType.getMapValueType(), new BasicDBList()));
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                ClassTypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (DBObject)newDbo, (TypeInformation<?>)valueTypeInfo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbo;
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : null;
        Class reference = actualType == null ? Object.class : actualType.getType();
        Class valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(valueType, dbObject);
        }
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, String key) {
        dbObject.put(key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, MongoPersistentProperty property) {
        DBObjectAccessor accessor = new DBObjectAccessor(dbObject);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, MongoPersistentProperty property) {
        Assert.notNull((Object)target);
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        MongoPersistentEntity mongoPersistentEntity = targetEntity = targetEntity == null ? (targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property)) : targetEntity;
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        if (idProperty == null) {
            throw new MappingException("No id property found on class " + targetEntity.getType());
        }
        Object id = null;
        if (target.getClass().equals(idProperty.getType())) {
            id = target;
        } else {
            PersistentPropertyAccessor accessor = targetEntity.getPropertyAccessor(target);
            id = accessor.getProperty((PersistentProperty)idProperty);
        }
        if (null == id) {
            throw new MappingException("Cannot create a reference to an object with a NULL id.");
        }
        return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), targetEntity, this.idMapper.convertId(id));
    }

    @Override
    public Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, SpELExpressionEvaluator evaluator, ObjectPath path) {
        return new MongoDbPropertyValueProvider(dbo, evaluator, path).getPropertyValue(prop);
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, BasicDBList sourceValue, ObjectPath path) {
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class<List> collectionType = targetType.getType();
        if (sourceValue.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(new HashSet(), collectionType);
        }
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType == null ? null : componentType.getType();
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        ArrayList<Object> items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (Class)rawComponentType, (int)sourceValue.size());
        for (int i = 0; i < sourceValue.size(); ++i) {
            Object dbObjItem = sourceValue.get(i);
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(com.mongodb.DBRef.class.equals((Object)rawComponentType) ? dbObjItem : this.read(componentType, this.readRef((com.mongodb.DBRef)dbObjItem), path));
                continue;
            }
            if (dbObjItem instanceof DBObject) {
                items.add(this.read(componentType, (DBObject)dbObjItem, path));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject, ObjectPath path) {
        Assert.notNull((Object)dbObject, (String)"DBObject must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class mapType = this.typeMapper.readType(dbObject, type).getType();
        TypeInformation keyType = type.getComponentType();
        Class rawKeyType = keyType == null ? null : keyType.getType();
        TypeInformation valueType = type.getMapValueType();
        Class rawValueType = valueType == null ? null : valueType.getType();
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)dbObject.keySet().size());
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object value;
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey((String)entry.getKey());
            if (rawKeyType != null) {
                key = this.conversionService.convert(key, rawKeyType);
            }
            if ((value = entry.getValue()) instanceof DBObject) {
                map.put(key, this.read(valueType, (DBObject)value, path));
                continue;
            }
            if (value instanceof com.mongodb.DBRef) {
                map.put(key, com.mongodb.DBRef.class.equals((Object)rawValueType) ? value : this.read(valueType, this.readRef((com.mongodb.DBRef)value)));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    @Override
    public Object convertToMongoType(Object obj, TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        TypeInformation<?> typeHint = typeInformation;
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((Iterable<?>)((BasicDBList)obj), typeHint);
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeHint));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            BasicDBObject result = new BasicDBObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeHint));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeHint);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeHint);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        if (typeInformation == null) {
            return this.removeTypeInfoRecursively(newDbo);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDbo : this.removeTypeInfoRecursively(newDbo);
    }

    public BasicDBList maybeConvertList(Iterable<?> source, TypeInformation<?> typeInformation) {
        BasicDBList newDbl = new BasicDBList();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfoRecursively(Object object) {
        if (!(object instanceof DBObject)) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        String keyToRemove = null;
        for (String key : dbObject.keySet()) {
            Object value;
            if (this.typeMapper.isTypeKey(key)) {
                keyToRemove = key;
            }
            if ((value = dbObject.get(key)) instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value);
        }
        if (keyToRemove != null) {
            dbObject.removeField(keyToRemove);
        }
        return dbObject;
    }

    private <T> T readValue(Object value, TypeInformation<?> type, ObjectPath path) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.conversionService.convert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return this.potentiallyReadOrResolveDbRef((com.mongodb.DBRef)value, type, path, rawType);
        }
        if (value instanceof BasicDBList) {
            return (T)this.readCollectionOrArray(type, (BasicDBList)value, path);
        }
        if (value instanceof DBObject) {
            return (T)this.read(type, (DBObject)value, path);
        }
        return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    private <T> T potentiallyReadOrResolveDbRef(com.mongodb.DBRef dbref, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        Object object;
        if (rawType.equals(com.mongodb.DBRef.class)) {
            return (T)dbref;
        }
        Object object2 = object = dbref == null ? null : path.getPathItem(dbref.getId(), dbref.getRef());
        if (object != null) {
            return (T)object;
        }
        return (T)(object != null ? object : this.read(type, this.readRef(dbref), path));
    }

    DBObject readRef(com.mongodb.DBRef ref) {
        return ref.fetch();
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ObjectPath path;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate, ObjectPath path) {
            super(evaluator, conversionService, delegate);
            this.path = path;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return (T)MappingMongoConverter.this.readValue(object, parameter.getType(), this.path);
        }
    }

    private class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        private final DBObjectAccessor source;
        private final SpELExpressionEvaluator evaluator;
        private final ObjectPath path;

        public MongoDbPropertyValueProvider(DBObject source, SpELExpressionEvaluator evaluator, ObjectPath path) {
            Assert.notNull((Object)source);
            Assert.notNull((Object)evaluator);
            this.source = new DBObjectAccessor(source);
            this.evaluator = evaluator;
            this.path = path;
        }

        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(property);
            if (value == null) {
                return null;
            }
            return (T)MappingMongoConverter.this.readValue(value, property.getTypeInformation(), this.path);
        }
    }
}

