/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bson.Document;
import org.springframework.util.Assert;

public class AggregationResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final Document rawResults;
    private final String serverUsed;

    public AggregationResults(List<T> mappedResults, Document rawResults) {
        Assert.notNull(mappedResults, (String)"List of mapped results must not be null!");
        Assert.notNull((Object)rawResults, (String)"Raw results must not be null!");
        this.mappedResults = Collections.unmodifiableList(mappedResults);
        this.rawResults = rawResults;
        this.serverUsed = this.parseServerUsed();
    }

    public List<T> getMappedResults() {
        return this.mappedResults;
    }

    public T getUniqueMappedResult() {
        Assert.isTrue((this.mappedResults.size() < 2 ? 1 : 0) != 0, (String)"Expected unique result or null, but got more than one!");
        return this.mappedResults.size() == 1 ? (T)this.mappedResults.get(0) : null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public String getServerUsed() {
        return this.serverUsed;
    }

    public Document getRawResults() {
        return this.rawResults;
    }

    private String parseServerUsed() {
        Object object = this.rawResults.get((Object)"serverUsed");
        return object instanceof String ? (String)object : null;
    }
}

