/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ObjectPath {
    public static final ObjectPath ROOT = new ObjectPath();
    private final List<ObjectPathItem> items;

    private ObjectPath() {
        this.items = Collections.emptyList();
    }

    private ObjectPath(ObjectPath parent, ObjectPathItem item) {
        ArrayList<ObjectPathItem> items = new ArrayList<ObjectPathItem>(parent.items);
        items.add(item);
        this.items = Collections.unmodifiableList(items);
    }

    public ObjectPath push(Object object, MongoPersistentEntity<?> entity, Object id) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
        ObjectPathItem item = new ObjectPathItem(object, id, entity.getCollection());
        return new ObjectPath(this, item);
    }

    public Object getPathItem(Object id, String collection) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.hasText((String)collection, (String)"Collection name must not be null!");
        for (ObjectPathItem item : this.items) {
            Object object = item.getObject();
            if (object == null || item.getIdValue() == null || !collection.equals(item.getCollection()) || !id.equals(item.getIdValue())) continue;
            return object;
        }
        return null;
    }

    public Optional<Object> getCurrentObject() {
        return this.items.isEmpty() ? Optional.empty() : Optional.of(this.items.get(this.items.size() - 1).getObject());
    }

    public String toString() {
        if (this.items.isEmpty()) {
            return "[empty]";
        }
        ArrayList<String> strings = new ArrayList<String>(this.items.size());
        for (ObjectPathItem item : this.items) {
            strings.add(item.object.toString());
        }
        return StringUtils.collectionToDelimitedString(strings, (String)" -> ");
    }

    private static class ObjectPathItem {
        private final Object object;
        private final Object idValue;
        private final String collection;

        ObjectPathItem(Object object, Object idValue, String collection) {
            this.object = object;
            this.idValue = idValue;
            this.collection = collection;
        }

        public Object getObject() {
            return this.object;
        }

        public Object getIdValue() {
            return this.idValue;
        }

        public String getCollection() {
            return this.collection;
        }
    }
}

