/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.ObjectUtils;

public class BasicQuery
extends Query {
    private final Document queryObject;
    private Document fieldsObject;
    private Document sortObject;

    public BasicQuery(String query) {
        this(query, null);
    }

    public BasicQuery(Document queryObject) {
        this(queryObject, null);
    }

    public BasicQuery(String query, String fields) {
        this.queryObject = query != null ? Document.parse((String)query) : null;
        this.fieldsObject = fields != null ? Document.parse((String)fields) : null;
    }

    public BasicQuery(Document queryObject, Document fieldsObject) {
        this.queryObject = queryObject;
        this.fieldsObject = fieldsObject;
    }

    @Override
    public Query addCriteria(CriteriaDefinition criteria) {
        this.queryObject.putAll((Map)criteria.getCriteriaObject());
        return this;
    }

    @Override
    public Document getQueryObject() {
        return this.queryObject;
    }

    @Override
    public Document getFieldsObject() {
        if (this.fieldsObject == null) {
            return super.getFieldsObject();
        }
        if (super.getFieldsObject() != null) {
            Document combinedFieldsObject = new Document();
            combinedFieldsObject.putAll((Map)this.fieldsObject);
            combinedFieldsObject.putAll((Map)super.getFieldsObject());
            return combinedFieldsObject;
        }
        return this.fieldsObject;
    }

    @Override
    public Document getSortObject() {
        Document overrides;
        Document result = new Document();
        if (this.sortObject != null) {
            result.putAll((Map)this.sortObject);
        }
        if ((overrides = super.getSortObject()) != null) {
            result.putAll((Map)overrides);
        }
        return result;
    }

    public void setSortObject(Document sortObject) {
        this.sortObject = sortObject;
    }

    protected void setFieldsObject(Document fieldsObject) {
        this.fieldsObject = fieldsObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicQuery)) {
            return false;
        }
        BasicQuery that = (BasicQuery)o;
        return this.querySettingsEquals(that) && ObjectUtils.nullSafeEquals((Object)this.fieldsObject, (Object)that.fieldsObject) && ObjectUtils.nullSafeEquals((Object)this.queryObject, (Object)that.queryObject) && ObjectUtils.nullSafeEquals((Object)this.sortObject, (Object)that.sortObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.queryObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.fieldsObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sortObject);
        return result;
    }
}

