/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Optional;
import org.springframework.data.mongodb.core.Collation;
import org.springframework.util.Assert;

public class CollectionOptions {
    private Long maxDocuments;
    private Long size;
    private Boolean capped;
    private Collation collation;

    @Deprecated
    public CollectionOptions(Long size, Long maxDocuments, Boolean capped) {
        this(size, maxDocuments, capped, null);
    }

    private CollectionOptions(Long size, Long maxDocuments, Boolean capped, Collation collation) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, (String)"Collation must not be null!");
        return new CollectionOptions(null, null, null, collation);
    }

    public static CollectionOptions empty() {
        return new CollectionOptions(null, null, null, null);
    }

    public CollectionOptions capped() {
        return new CollectionOptions(this.size, this.maxDocuments, true, this.collation);
    }

    public CollectionOptions maxDocuments(long maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation);
    }

    public CollectionOptions size(long size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation);
    }

    public CollectionOptions collation(Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, collation);
    }

    public Optional<Long> getMaxDocuments() {
        return Optional.ofNullable(this.maxDocuments);
    }

    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> getCapped() {
        return Optional.ofNullable(this.capped);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }
}

