/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.FindIterable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ExecutableFindOperationSupport
implements ExecutableFindOperation {
    private final MongoTemplate template;

    ExecutableFindOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableFindOperation.FindOperation<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new FindOperationSupport<T>(this.template, domainType, domainType, null, null);
    }

    static class DelegatingQueryCursorPreparer
    implements CursorPreparer {
        private final CursorPreparer delegate;
        private Optional<Integer> limit = Optional.empty();

        DelegatingQueryCursorPreparer(CursorPreparer delegate) {
            this.delegate = delegate;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> cursor) {
            FindIterable<Document> target = this.delegate.prepare(cursor);
            return this.limit.map(arg_0 -> target.limit(arg_0)).orElse(target);
        }

        CursorPreparer limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }
    }

    static class FindOperationSupport<T>
    implements ExecutableFindOperation.FindOperation<T>,
    ExecutableFindOperation.FindOperationWithCollection<T>,
    ExecutableFindOperation.FindOperationWithProjection<T>,
    ExecutableFindOperation.FindOperationWithQuery<T> {
        private final MongoTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String collection;
        private final Query query;

        @Override
        public ExecutableFindOperation.FindOperationWithProjection<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection name must not be null nor empty!");
            return new FindOperationSupport<T>(this.template, this.domainType, this.returnType, collection, this.query);
        }

        @Override
        public <T1> ExecutableFindOperation.FindOperationWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null!");
            return new FindOperationSupport<T1>(this.template, this.domainType, returnType, this.collection, this.query);
        }

        @Override
        public ExecutableFindOperation.TerminatingFindOperation<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new FindOperationSupport<T>(this.template, this.domainType, this.returnType, this.collection, query);
        }

        @Override
        public Optional<T> one() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(2));
            if (ObjectUtils.isEmpty(result)) {
                return Optional.empty();
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException("Query " + this.asString() + " returned non unique result.", 1);
            }
            return Optional.of(result.iterator().next());
        }

        @Override
        public Optional<T> first() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(1));
            return ObjectUtils.isEmpty(result) ? Optional.empty() : Optional.of(result.iterator().next());
        }

        @Override
        public List<T> all() {
            return this.doFind(null);
        }

        @Override
        public CloseableIterator<T> stream() {
            return this.doStream();
        }

        @Override
        public ExecutableFindOperation.TerminatingFindNearOperation<T> near(NearQuery nearQuery) {
            return () -> this.template.geoNear(nearQuery, this.domainType, this.getCollectionName(), this.returnType);
        }

        private List<T> doFind(CursorPreparer preparer) {
            Document queryObject = this.query != null ? this.query.getQueryObject() : new Document();
            Document fieldsObject = this.query != null ? this.query.getFieldsObject() : new Document();
            return this.template.doFind(this.getCollectionName(), queryObject, fieldsObject, this.domainType, this.returnType, this.getCursorPreparer(this.query, preparer));
        }

        private CloseableIterator<T> doStream() {
            return this.template.doStream(this.query != null ? this.query : new BasicQuery(new Document()), this.domainType, this.getCollectionName(), this.returnType);
        }

        private CursorPreparer getCursorPreparer(Query query, CursorPreparer preparer) {
            CursorPreparer cursorPreparer;
            if (query == null || preparer != null) {
                cursorPreparer = preparer;
            } else {
                MongoTemplate mongoTemplate = this.template;
                mongoTemplate.getClass();
                cursorPreparer = mongoTemplate.new MongoTemplate.QueryCursorPreparer(query, this.domainType);
            }
            return cursorPreparer;
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        private String asString() {
            return SerializationUtils.serializeToJsonSafely(this.query);
        }

        @ConstructorProperties(value={"template", "domainType", "returnType", "collection", "query"})
        public FindOperationSupport(MongoTemplate template, Class<?> domainType, Class<T> returnType, String collection, Query query) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
        }
    }
}

