/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import java.beans.ConstructorProperties;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableRemoveOperationSupport
implements ExecutableRemoveOperation {
    private final MongoTemplate tempate;

    ExecutableRemoveOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.tempate = template;
    }

    @Override
    public <T> ExecutableRemoveOperation.RemoveOperation<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new RemoveOperationSupport<T>(this.tempate, null, domainType, null);
    }

    static class RemoveOperationSupport<T>
    implements ExecutableRemoveOperation.RemoveOperation<T>,
    ExecutableRemoveOperation.RemoveOperationWithCollection<T> {
        private final MongoTemplate template;
        private final Query query;
        private final Class<T> domainType;
        private final String collection;

        @Override
        public ExecutableRemoveOperation.RemoveOperationWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new RemoveOperationSupport<T>(this.template, this.query, this.domainType, collection);
        }

        @Override
        public ExecutableRemoveOperation.TerminatingRemoveOperation<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new RemoveOperationSupport<T>(this.template, query, this.domainType, this.collection);
        }

        @Override
        public DeleteResult all() {
            String collectionName = this.getCollectionName();
            return this.template.doRemove(collectionName, this.getQuery(), this.domainType);
        }

        @Override
        public List<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.getQuery(), this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        private Query getQuery() {
            return this.query != null ? this.query : new BasicQuery(new Document());
        }

        @ConstructorProperties(value={"template", "query", "domainType", "collection"})
        public RemoveOperationSupport(MongoTemplate template, Query query, Class<T> domainType, String collection) {
            this.template = template;
            this.query = query;
            this.domainType = domainType;
            this.collection = collection;
        }
    }
}

