/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationRenderer;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.BucketAutoOperation;
import org.springframework.data.mongodb.core.aggregation.BucketOperation;
import org.springframework.data.mongodb.core.aggregation.CountOperation;
import org.springframework.data.mongodb.core.aggregation.FacetOperation;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.GeoNearOperation;
import org.springframework.data.mongodb.core.aggregation.GraphLookupOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.OutOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.ReplaceRootOperation;
import org.springframework.data.mongodb.core.aggregation.SampleOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.util.Assert;

public class Aggregation {
    public static final String ROOT = SystemVariable.ROOT.toString();
    public static final String CURRENT = SystemVariable.CURRENT.toString();
    public static final AggregationOperationContext DEFAULT_CONTEXT = AggregationOperationRenderer.DEFAULT_CONTEXT;
    public static final AggregationOptions DEFAULT_OPTIONS = Aggregation.newAggregationOptions().build();
    protected final List<AggregationOperation> operations;
    private final AggregationOptions options;

    public static Aggregation newAggregation(List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static Aggregation newAggregation(AggregationOperation ... operations) {
        return new Aggregation(operations);
    }

    public Aggregation withOptions(AggregationOptions options) {
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null.");
        return new Aggregation(this.operations, options);
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(type, operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, AggregationOperation ... operations) {
        return new TypedAggregation<T>(type, operations);
    }

    protected Aggregation(AggregationOperation ... aggregationOperations) {
        this(Aggregation.asAggregationList(aggregationOperations));
    }

    protected static List<AggregationOperation> asAggregationList(AggregationOperation ... aggregationOperations) {
        Assert.notEmpty((Object[])aggregationOperations, (String)"AggregationOperations must not be null or empty!");
        return Arrays.asList(aggregationOperations);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations) {
        this(aggregationOperations, DEFAULT_OPTIONS);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations, AggregationOptions options) {
        Assert.notNull(aggregationOperations, (String)"AggregationOperations must not be null!");
        Assert.isTrue((!aggregationOperations.isEmpty() ? 1 : 0) != 0, (String)"At least one AggregationOperation has to be provided");
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null!");
        for (AggregationOperation aggregationOperation : aggregationOperations) {
            if (!(aggregationOperation instanceof OutOperation) || this.isLast(aggregationOperation, aggregationOperations)) continue;
            throw new IllegalArgumentException("The $out operator must be the last stage in the pipeline.");
        }
        this.operations = aggregationOperations;
        this.options = options;
    }

    private boolean isLast(AggregationOperation aggregationOperation, List<AggregationOperation> aggregationOperations) {
        return aggregationOperations.indexOf(aggregationOperation) == aggregationOperations.size() - 1;
    }

    public static String previousOperation() {
        return "_id";
    }

    public static ProjectionOperation project(String ... fields) {
        return Aggregation.project(Aggregation.fields(fields));
    }

    public static ProjectionOperation project(Fields fields) {
        return new ProjectionOperation(fields);
    }

    public static UnwindOperation unwind(String field) {
        return new UnwindOperation(Fields.field(field));
    }

    public static ReplaceRootOperation replaceRoot(String fieldName) {
        return ReplaceRootOperation.builder().withValueOf(fieldName);
    }

    public static ReplaceRootOperation replaceRoot(AggregationExpression aggregationExpression) {
        return ReplaceRootOperation.builder().withValueOf(aggregationExpression);
    }

    public static ReplaceRootOperation.ReplaceRootOperationBuilder replaceRoot() {
        return ReplaceRootOperation.builder();
    }

    public static UnwindOperation unwind(String field, boolean preserveNullAndEmptyArrays) {
        return new UnwindOperation(Fields.field(field), preserveNullAndEmptyArrays);
    }

    public static UnwindOperation unwind(String field, String arrayIndex) {
        return new UnwindOperation(Fields.field(field), Fields.field(arrayIndex), false);
    }

    public static UnwindOperation unwind(String field, String arrayIndex, boolean preserveNullAndEmptyArrays) {
        return new UnwindOperation(Fields.field(field), Fields.field(arrayIndex), preserveNullAndEmptyArrays);
    }

    public static GroupOperation group(String ... fields) {
        return Aggregation.group(Aggregation.fields(fields));
    }

    public static GroupOperation group(Fields fields) {
        return new GroupOperation(fields);
    }

    public static GraphLookupOperation.StartWithBuilder graphLookup(String fromCollection) {
        return GraphLookupOperation.builder().from(fromCollection);
    }

    public static SortOperation sort(Sort sort) {
        return new SortOperation(sort);
    }

    public static SortOperation sort(Sort.Direction direction, String ... fields) {
        return new SortOperation(Sort.by((Sort.Direction)direction, (String[])fields));
    }

    public static SkipOperation skip(int elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static SkipOperation skip(long elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static LimitOperation limit(long maxElements) {
        return new LimitOperation(maxElements);
    }

    public static SampleOperation sample(long sampleSize) {
        return new SampleOperation(sampleSize);
    }

    public static MatchOperation match(Criteria criteria) {
        return new MatchOperation(criteria);
    }

    public static MatchOperation match(CriteriaDefinition criteria) {
        return new MatchOperation(criteria);
    }

    public static OutOperation out(String outCollectionName) {
        return new OutOperation(outCollectionName);
    }

    public static BucketOperation bucket(String groupByField) {
        return new BucketOperation(Fields.field(groupByField));
    }

    public static BucketOperation bucket(AggregationExpression groupByExpression) {
        return new BucketOperation(groupByExpression);
    }

    public static BucketAutoOperation bucketAuto(String groupByField, int buckets) {
        return new BucketAutoOperation(Fields.field(groupByField), buckets);
    }

    public static BucketAutoOperation bucketAuto(AggregationExpression groupByExpression, int buckets) {
        return new BucketAutoOperation(groupByExpression, buckets);
    }

    public static FacetOperation facet() {
        return FacetOperation.EMPTY;
    }

    public static FacetOperation.FacetOperationBuilder facet(AggregationOperation ... aggregationOperations) {
        return Aggregation.facet().and(aggregationOperations);
    }

    public static LookupOperation lookup(String from, String localField, String foreignField, String as) {
        return Aggregation.lookup(Fields.field(from), Fields.field(localField), Fields.field(foreignField), Fields.field(as));
    }

    public static LookupOperation lookup(Field from, Field localField, Field foreignField, Field as) {
        return new LookupOperation(from, localField, foreignField, as);
    }

    public static CountOperation.CountOperationBuilder count() {
        return new CountOperation.CountOperationBuilder();
    }

    public static Fields fields(String ... fields) {
        return Fields.fields(fields);
    }

    public static Fields bind(String name, String target) {
        return Fields.from(Fields.field(name, target));
    }

    public static GeoNearOperation geoNear(NearQuery query, String distanceField) {
        return new GeoNearOperation(query, distanceField);
    }

    public static AggregationOptions.Builder newAggregationOptions() {
        return new AggregationOptions.Builder();
    }

    public Document toDocument(String inputCollectionName, AggregationOperationContext rootContext) {
        List<Document> operationDocuments = AggregationOperationRenderer.toDocument(this.operations, rootContext);
        Document command = new Document("aggregate", (Object)inputCollectionName);
        command.put("pipeline", operationDocuments);
        command = this.options.applyAndReturnPotentiallyChangedCommand(command);
        return command;
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument("__collection__", DEFAULT_CONTEXT));
    }

    static enum SystemVariable {
        ROOT,
        CURRENT;

        private static final String PREFIX = "$$";

        public static boolean isReferingToSystemVariable(String fieldRef) {
            if (fieldRef == null || !fieldRef.startsWith(PREFIX) || fieldRef.length() <= 2) {
                return false;
            }
            int indexOfFirstDot = fieldRef.indexOf(46);
            String candidate = fieldRef.substring(2, indexOfFirstDot == -1 ? fieldRef.length() : indexOfFirstDot);
            for (SystemVariable value : SystemVariable.values()) {
                if (!value.name().equals(candidate)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return PREFIX.concat(this.name());
        }
    }
}

