/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.Collation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Index
implements IndexDefinition {
    private final Map<String, Sort.Direction> fieldSpec = new LinkedHashMap<String, Sort.Direction>();
    private String name;
    private boolean unique = false;
    private boolean dropDuplicates = false;
    private boolean sparse = false;
    private boolean background = false;
    private long expire = -1L;
    private Optional<IndexFilter> filter = Optional.empty();
    private Optional<Collation> collation = Optional.empty();

    public Index() {
    }

    public Index(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
    }

    public Index on(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
        return this;
    }

    public Index named(String name) {
        this.name = name;
        return this;
    }

    public Index unique() {
        this.unique = true;
        return this;
    }

    public Index sparse() {
        this.sparse = true;
        return this;
    }

    public Index background() {
        this.background = true;
        return this;
    }

    public Index expire(long value) {
        return this.expire(value, TimeUnit.SECONDS);
    }

    public Index expire(long value, TimeUnit unit) {
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit for expiration must not be null.");
        this.expire = unit.toSeconds(value);
        return this;
    }

    public Index partial(IndexFilter filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    public Index collation(Collation collation) {
        this.collation = Optional.ofNullable(collation);
        return this;
    }

    @Override
    public Document getIndexKeys() {
        Document document = new Document();
        for (Map.Entry<String, Sort.Direction> entry : this.fieldSpec.entrySet()) {
            document.put(entry.getKey(), (Object)(Sort.Direction.ASC.equals((Object)entry.getValue()) ? 1 : -1));
        }
        return document;
    }

    @Override
    public Document getIndexOptions() {
        Document document = new Document();
        if (StringUtils.hasText((String)this.name)) {
            document.put("name", (Object)this.name);
        }
        if (this.unique) {
            document.put("unique", (Object)true);
        }
        if (this.dropDuplicates) {
            document.put("dropDups", (Object)true);
        }
        if (this.sparse) {
            document.put("sparse", (Object)true);
        }
        if (this.background) {
            document.put("background", (Object)true);
        }
        if (this.expire >= 0L) {
            document.put("expireAfterSeconds", (Object)this.expire);
        }
        this.filter.ifPresent(val -> document.put("partialFilterExpression", (Object)val.getFilterObject()));
        this.collation.ifPresent(val -> document.append("collation", (Object)val.toDocument()));
        return document;
    }

    public String toString() {
        return String.format("Index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }

    public static enum Duplicates {
        RETAIN;

    }
}

