/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.result.DeleteResult;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.DtoInstantiatingConverter;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;

interface ReactiveMongoQueryExecution {
    public Object execute(Query var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final ReactiveMongoOperations operations;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.operations.getConverter().getMappingContext(), this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        @ConstructorProperties(value={"processor", "operations", "instantiators"})
        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull ReactiveMongoOperations operations, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor");
            }
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators");
            }
            this.processor = processor;
            this.operations = operations;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveMongoQueryExecution {
        @NonNull
        private final ReactiveMongoQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, collection));
        }

        @ConstructorProperties(value={"delegate", "converter"})
        public ResultProcessingExecution(@NonNull ReactiveMongoQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class DeleteExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoQueryMethod method;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collection);
            }
            return this.operations.remove(query, type, collection).map(DeleteResult::getDeletedCount);
        }

        @ConstructorProperties(value={"operations", "method"})
        public DeleteExecution(ReactiveMongoOperations operations, MongoQueryMethod method) {
            this.operations = operations;
            this.method = method;
        }
    }

    public static class GeoNearExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoParameterAccessor accessor;
        private final TypeInformation<?> returnType;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            Flux results = this.doExecuteQuery(query, type, collection);
            return this.isStreamOfGeoResult() ? results : results.map(GeoResult::getContent);
        }

        protected Flux<GeoResult<Object>> doExecuteQuery(Query query, Class<?> type, String collection) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            if (pageable != null) {
                nearQuery.with(pageable);
            }
            return this.operations.geoNear(nearQuery, type, collection);
        }

        private boolean isStreamOfGeoResult() {
            if (!ReactiveWrappers.supports((Class)this.returnType.getType())) {
                return false;
            }
            Optional componentType = this.returnType.getComponentType();
            return componentType.isPresent() && GeoResult.class.equals((Object)((TypeInformation)componentType.get()).getType());
        }

        @ConstructorProperties(value={"operations", "accessor", "returnType"})
        public GeoNearExecution(ReactiveMongoOperations operations, MongoParameterAccessor accessor, TypeInformation<?> returnType) {
            this.operations = operations;
            this.accessor = accessor;
            this.returnType = returnType;
        }
    }

    public static final class SingleEntityExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final boolean countProjection;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.countProjection ? this.operations.count(query, type, collection) : this.operations.findOne(query, type, collection);
        }

        @ConstructorProperties(value={"operations", "countProjection"})
        public SingleEntityExecution(ReactiveMongoOperations operations, boolean countProjection) {
            this.operations = operations;
            this.countProjection = countProjection;
        }
    }

    public static final class TailExecution
    implements ReactiveMongoQueryExecution {
        @NonNull
        private final ReactiveMongoOperations operations;
        private final Pageable pageable;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.operations.tail(query.with(this.pageable), type, collection);
        }

        @ConstructorProperties(value={"operations", "pageable"})
        public TailExecution(@NonNull ReactiveMongoOperations operations, Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }

    public static final class CollectionExecution
    implements ReactiveMongoQueryExecution {
        @NonNull
        private final ReactiveMongoOperations operations;
        private final Pageable pageable;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.operations.find(query.with(this.pageable), type, collection);
        }

        @ConstructorProperties(value={"operations", "pageable"})
        public CollectionExecution(@NonNull ReactiveMongoOperations operations, Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }
}

