/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.FindIterable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.bson.Document;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ExecutableFindOperationSupport
implements ExecutableFindOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate template;

    ExecutableFindOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableFindSupport<T>(this.template, domainType, domainType, null, ALL_QUERY);
    }

    static class DelegatingQueryCursorPreparer
    implements CursorPreparer {
        @Nullable
        private final CursorPreparer delegate;
        private Optional<Integer> limit = Optional.empty();

        DelegatingQueryCursorPreparer(@Nullable CursorPreparer delegate) {
            this.delegate = delegate;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> cursor) {
            FindIterable<Document> target = this.delegate != null ? this.delegate.prepare(cursor) : cursor;
            return this.limit.map(arg_0 -> target.limit(arg_0)).orElse(target);
        }

        CursorPreparer limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }
    }

    static class ExecutableFindSupport<T>
    implements ExecutableFindOperation.ExecutableFind<T>,
    ExecutableFindOperation.FindWithCollection<T>,
    ExecutableFindOperation.FindWithProjection<T>,
    ExecutableFindOperation.FindWithQuery<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class<?> domainType;
        private final Class<T> returnType;
        @Nullable
        private final String collection;
        private final Query query;

        @Override
        public ExecutableFindOperation.FindWithProjection<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection name must not be null nor empty!");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, collection, this.query);
        }

        @Override
        public <T1> ExecutableFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null!");
            return new ExecutableFindSupport<T1>(this.template, this.domainType, returnType, this.collection, this.query);
        }

        @Override
        public ExecutableFindOperation.TerminatingFind<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, this.collection, query);
        }

        @Override
        public T oneValue() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(2));
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException("Query " + this.asString() + " returned non unique result.", 1);
            }
            return result.iterator().next();
        }

        @Override
        public T firstValue() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(1));
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.doFind(null);
        }

        @Override
        public Stream<T> stream() {
            return StreamUtils.createStreamFromIterator(this.doStream());
        }

        @Override
        public ExecutableFindOperation.TerminatingFindNear<T> near(NearQuery nearQuery) {
            return () -> this.template.geoNear(nearQuery, this.domainType, this.getCollectionName(), this.returnType);
        }

        @Override
        public long count() {
            return this.template.count(this.query, this.domainType, this.getCollectionName());
        }

        @Override
        public boolean exists() {
            return this.template.exists(this.query, this.domainType, this.getCollectionName());
        }

        private List<T> doFind(@Nullable CursorPreparer preparer) {
            Document queryObject = this.query.getQueryObject();
            Document fieldsObject = this.query.getFieldsObject();
            return this.template.doFind(this.getCollectionName(), queryObject, fieldsObject, this.domainType, this.returnType, this.getCursorPreparer(this.query, preparer));
        }

        private CloseableIterator<T> doStream() {
            return this.template.doStream(this.query, this.domainType, this.getCollectionName(), this.returnType);
        }

        private CursorPreparer getCursorPreparer(Query query, @Nullable CursorPreparer preparer) {
            CursorPreparer cursorPreparer;
            if (preparer != null) {
                cursorPreparer = preparer;
            } else {
                MongoTemplate mongoTemplate = this.template;
                mongoTemplate.getClass();
                cursorPreparer = new MongoTemplate.QueryCursorPreparer(mongoTemplate, query, this.domainType);
            }
            return cursorPreparer;
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        private String asString() {
            return SerializationUtils.serializeToJsonSafely(this.query);
        }

        @ConstructorProperties(value={"template", "domainType", "returnType", "collection", "query"})
        public ExecutableFindSupport(@NonNull MongoTemplate template, @NonNull Class<?> domainType, Class<T> returnType, @Nullable String collection, Query query) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
        }
    }
}

