/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.DocumentAccessor;
import org.springframework.data.mongodb.core.convert.DocumentPropertyAccessor;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware,
ValueResolver {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions. Parent object was: %4$s";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter!";
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected final DefaultDbRefProxyHandler dbRefProxyHandler;
    @Nullable
    protected ApplicationContext applicationContext;
    protected MongoTypeMapper typeMapper;
    @Nullable
    protected String mapKeyDotReplacement = null;
    private SpELContext spELContext;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super((GenericConversionService)new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
        this.dbRefProxyHandler = new DefaultDbRefProxyHandler(this.spELContext, mappingContext, this);
    }

    @Deprecated
    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
    }

    public void setTypeMapper(@Nullable MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setMapKeyDotReplacement(@Nullable String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public <S> S read(Class<S> clazz, Bson bson) {
        return this.read((TypeInformation<S>)ClassTypeInformation.from(clazz), bson);
    }

    protected <S> S read(TypeInformation<S> type, Bson bson) {
        return this.read(type, bson, ObjectPath.ROOT);
    }

    @Nullable
    private <S> S read(TypeInformation<S> type, @Nullable Bson bson, ObjectPath path) {
        if (null == bson) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(bson, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(bson.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)bson, rawType);
        }
        if (bson instanceof DBObject && this.conversions.hasCustomReadTarget(Document.class, rawType)) {
            return (S)this.conversionService.convert((Object)new Document(BsonUtils.asMap(bson)), rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (typeToUse.isCollectionLike() && bson instanceof List) {
            return (S)this.readCollectionOrArray(typeToUse, (List)bson, path);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, bson, path);
        }
        if (bson instanceof Collection) {
            throw new MappingException(String.format(INCOMPATIBLE_TYPES, bson, BasicDBList.class, typeToUse.getType(), path));
        }
        if (typeToUse.equals(ClassTypeInformation.OBJECT)) {
            return (S)bson;
        }
        Document target = bson instanceof BasicDBObject ? new Document((Map)((BasicDBObject)bson)) : (Document)bson;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (entity == null) {
            throw new MappingException(String.format(INVALID_TYPE_TO_READ, target, typeToUse.getType()));
        }
        return this.read(entity, target, path);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(MongoPersistentEntity<?> entity, DocumentAccessor source, DefaultSpELExpressionEvaluator evaluator, ObjectPath path) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(source, (SpELExpressionEvaluator)evaluator, path);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, path.getCurrentObject());
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider, path);
    }

    private <S> S read(MongoPersistentEntity<S> entity, Document bson, ObjectPath path) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)bson, this.spELContext);
        DocumentAccessor documentAccessor = new DocumentAccessor((Bson)bson);
        PreferredConstructor constructor = entity.getPersistenceConstructor();
        ParameterValueProvider<MongoPersistentProperty> provider = constructor != null && constructor.hasParameters() ? this.getParameterProvider(entity, documentAccessor, evaluator, path) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        Object idValue = null;
        if (idProperty != null && documentAccessor.hasValue(idProperty)) {
            idValue = this.readIdValue(path, evaluator, idProperty, documentAccessor);
            accessor.setProperty((PersistentProperty)idProperty, idValue);
        }
        ObjectPath currentPath = path.push(instance, entity, idValue != null ? bson.get((Object)idProperty.getFieldName()) : null);
        MongoDbPropertyValueProvider valueProvider = new MongoDbPropertyValueProvider(documentAccessor, (SpELExpressionEvaluator)evaluator, currentPath);
        this.readProperties(entity, (PersistentPropertyAccessor)accessor, idProperty, documentAccessor, valueProvider, currentPath, (SpELExpressionEvaluator)evaluator);
        return (S)instance;
    }

    private Object readIdValue(ObjectPath path, DefaultSpELExpressionEvaluator evaluator, MongoPersistentProperty idProperty, DocumentAccessor documentAccessor) {
        String expression = idProperty.getSpelExpression();
        Object resolvedValue = expression != null ? evaluator.evaluate(expression) : documentAccessor.get(idProperty);
        return resolvedValue != null ? this.readValue(resolvedValue, idProperty.getTypeInformation(), path) : null;
    }

    private void readProperties(MongoPersistentEntity<?> entity, PersistentPropertyAccessor accessor, @Nullable MongoPersistentProperty idProperty, DocumentAccessor documentAccessor, MongoDbPropertyValueProvider valueProvider, ObjectPath currentPath, SpELExpressionEvaluator evaluator) {
        DbRefResolverCallback callback = null;
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (callback == null) {
                callback = this.getDbRefResolverCallback(documentAccessor, currentPath, evaluator);
            }
            if (prop.isAssociation() && !entity.isConstructorArgument(prop)) {
                this.readAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback);
                continue;
            }
            if (idProperty != null && idProperty.equals(prop) || entity.isConstructorArgument(prop) || !documentAccessor.hasValue(prop)) continue;
            if (prop.isAssociation()) {
                this.readAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback);
                continue;
            }
            accessor.setProperty((PersistentProperty)prop, valueProvider.getPropertyValue(prop));
        }
    }

    private DbRefResolverCallback getDbRefResolverCallback(DocumentAccessor documentAccessor, ObjectPath currentPath, SpELExpressionEvaluator evaluator) {
        return new DefaultDbRefResolverCallback(documentAccessor.getDocument(), currentPath, evaluator, this);
    }

    private void readAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor accessor, DocumentAccessor documentAccessor, DbRefProxyHandler handler, DbRefResolverCallback callback) {
        MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
        Object value = documentAccessor.get(property);
        if (value == null) {
            return;
        }
        com.mongodb.DBRef dbref = value instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)value : null;
        accessor.setProperty((PersistentProperty)property, this.dbRefResolver.resolveDbRef(property, dbref, callback, handler));
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty != null) {
            DBRef annotation = referringProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        if (object instanceof LazyLoadingProxy) {
            return ((LazyLoadingProxy)object).toDBRef();
        }
        return this.createDBRef(object, referringProperty);
    }

    public void write(Object obj, Bson bson) {
        if (null == obj) {
            return;
        }
        Class entityType = ClassUtils.getUserClass(obj.getClass());
        ClassTypeInformation type = ClassTypeInformation.from((Class)entityType);
        Object target = obj instanceof LazyLoadingProxy ? ((LazyLoadingProxy)obj).getTarget() : obj;
        this.writeInternal(target, bson, (TypeInformation<?>)type);
        if (MappingMongoConverter.asMap(bson).containsKey("_id") && MappingMongoConverter.asMap(bson).get("_id") == null) {
            MappingMongoConverter.removeFromMap(bson, "_id");
        }
        if (this.requiresTypeHint(entityType)) {
            this.typeMapper.writeType((TypeInformation)type, bson);
        }
    }

    private boolean requiresTypeHint(Class<?> type) {
        return !this.conversions.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Document.class);
        if (customTarget.isPresent()) {
            Document result = (Document)this.conversionService.convert(obj, Document.class);
            MappingMongoConverter.addAllToMap(bson, result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, bson, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, (TypeInformation<?>)ClassTypeInformation.LIST, (Collection)bson);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeInternal(obj, bson, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, bson);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable MongoPersistentEntity<?> entity) {
        Object value;
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        DocumentAccessor dbObjectAccessor = new DocumentAccessor(bson);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null && !dbObjectAccessor.hasValue(idProperty) && (value = this.idMapper.convertId(accessor.getProperty((PersistentProperty)idProperty))) != null) {
            dbObjectAccessor.put(idProperty, value);
        }
        this.writeProperties(bson, entity, accessor, dbObjectAccessor, idProperty);
    }

    private void writeProperties(Bson bson, MongoPersistentEntity<?> entity, PersistentPropertyAccessor accessor, DocumentAccessor dbObjectAccessor, @Nullable MongoPersistentProperty idProperty) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (prop.equals(idProperty) || !prop.isWritable()) continue;
            if (prop.isAssociation()) {
                this.writeAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, dbObjectAccessor);
                continue;
            }
            Object value = accessor.getProperty((PersistentProperty)prop);
            if (value == null) continue;
            if (!this.conversions.isSimpleType(value.getClass())) {
                this.writePropertyInternal(value, dbObjectAccessor, prop);
                continue;
            }
            this.writeSimpleInternal(value, bson, prop);
        }
    }

    private void writeAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor accessor, DocumentAccessor dbObjectAccessor) {
        MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
        this.writePropertyInternal(accessor.getProperty((PersistentProperty)inverseProp), dbObjectAccessor, inverseProp);
    }

    protected void writePropertyInternal(@Nullable Object obj, DocumentAccessor accessor, MongoPersistentProperty prop) {
        Optional basicTargetType;
        if (obj == null) {
            return;
        }
        ClassTypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Bson mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                dbRefObj = ((LazyLoadingProxy)obj).toDBRef();
            }
            com.mongodb.DBRef dBRef = dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            if (null != dbRefObj) {
                accessor.put(prop, dbRefObj);
                return;
            }
        }
        if (obj instanceof LazyLoadingProxy) {
            obj = ((LazyLoadingProxy)obj).getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass())).isPresent()) {
            accessor.put(prop, this.conversionService.convert(obj, (Class)basicTargetType.get()));
            return;
        }
        MongoPersistentEntity entity = MappingMongoConverter.isSubTypeOf(obj.getClass(), prop.getType()) ? (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        Object existingValue = accessor.get(prop);
        Document document = existingValue instanceof Document ? (Document)existingValue : new Document();
        this.writeInternal(obj, (Bson)document, entity);
        this.addCustomTypeKeyIfNecessary((TypeInformation<?>)ClassTypeInformation.from((Class)prop.getRawType()), obj, (Bson)document);
        accessor.put(prop, document);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected List<Object> createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, (TypeInformation<?>)property.getTypeInformation(), (Collection<?>)new BasicDBList());
        }
        ArrayList<Object> dbList = new ArrayList<Object>(collection.size());
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add(dbRef);
        }
        return dbList;
    }

    protected Bson createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        if (!property.isDbReference()) {
            return this.writeMapInternal(map, (Bson)new Document(), property.getTypeInformation());
        }
        Document document = new Document();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key.toString());
                document.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return document;
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(MappingMongoConverter.asCollection(element), (TypeInformation<?>)componentType, (Collection<?>)new BasicDBList()));
                continue;
            }
            Document document = new Document();
            this.writeInternal(element, (Bson)document, componentType);
            collection.add(document);
        }
        return collection;
    }

    protected Bson writeMapInternal(Map<Object, Object> obj, Bson bson, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key);
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, bson, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    MappingMongoConverter.addToMap(bson, simpleKey, this.writeCollectionInternal(MappingMongoConverter.asCollection(val), (TypeInformation<?>)propertyType.getMapValueType(), (Collection<?>)new BasicDBList()));
                    continue;
                }
                Document document = new Document();
                ClassTypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (Bson)document, (TypeInformation<?>)valueTypeInfo);
                MappingMongoConverter.addToMap(bson, simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return bson;
    }

    private String prepareMapKey(Object key) {
        Assert.notNull((Object)key, (String)"Map key must not be null!");
        String convertedKey = this.potentiallyConvertMapKey(key);
        return this.potentiallyEscapeMapKey(convertedKey);
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class) ? (String)this.getPotentiallyConvertedSimpleWrite(key) : key.toString();
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(@Nullable TypeInformation<?> type, Object value, Bson bson) {
        boolean notTheSameClass;
        Class reference = type != null ? type.getActualType().getType() : Object.class;
        Class valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(valueType, bson);
        }
    }

    private void writeSimpleInternal(Object value, Bson bson, String key) {
        MappingMongoConverter.addToMap(bson, key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private void writeSimpleInternal(Object value, Bson bson, MongoPersistentProperty property) {
        DocumentAccessor accessor = new DocumentAccessor(bson);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value));
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        if (ObjectUtils.isArray((Object)value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return MappingMongoConverter.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, MongoPersistentProperty property) {
        Assert.notNull((Object)target, (String)"Target object must not be null!");
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        MongoPersistentEntity mongoPersistentEntity = targetEntity = targetEntity != null ? targetEntity : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentEntity entity = targetEntity;
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object id;
            Object object = id = target.getClass().equals(idProperty.getType()) ? target : entity.getPropertyAccessor(target).getProperty((PersistentProperty)idProperty);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
            return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), entity, this.idMapper.convertId(id));
        }
        throw new MappingException("No id property found on class " + entity.getType());
    }

    @Override
    public Object getValueInternal(MongoPersistentProperty prop, Bson bson, SpELExpressionEvaluator evaluator, ObjectPath path) {
        return new MongoDbPropertyValueProvider(bson, evaluator, path).getPropertyValue(prop);
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, Collection<?> source, ObjectPath path) {
        Collection<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class<List> collectionType = targetType.getType();
        collectionType = MappingMongoConverter.isSubTypeOf(collectionType, Collection.class) ? collectionType : List.class;
        ClassTypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : ClassTypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection(collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }
        if (!com.mongodb.DBRef.class.equals((Object)rawComponentType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(source)) {
            List objects = this.bulkReadAndConvertDBRefs((List)source, (TypeInformation<?>)componentType, path, rawComponentType);
            return this.getPotentiallyConvertedSimpleRead(objects, targetType.getType());
        }
        for (Object element : source) {
            if (element instanceof com.mongodb.DBRef) {
                items.add(com.mongodb.DBRef.class.equals((Object)rawComponentType) ? element : this.readAndConvertDBRef((com.mongodb.DBRef)element, (TypeInformation<?>)componentType, path, rawComponentType));
                continue;
            }
            if (element instanceof Document) {
                items.add(this.read((TypeInformation)componentType, (Bson)((Document)element), path));
                continue;
            }
            if (element instanceof BasicDBObject) {
                items.add(this.read((TypeInformation)componentType, (Bson)((BasicDBObject)element), path));
                continue;
            }
            if (!Object.class.equals((Object)rawComponentType) && element instanceof Collection && !rawComponentType.isArray() && !ClassUtils.isAssignable(Iterable.class, (Class)rawComponentType)) {
                throw new MappingException(String.format(INCOMPATIBLE_TYPES, element, element.getClass(), rawComponentType, path));
            }
            if (element instanceof List) {
                items.add(this.readCollectionOrArray((TypeInformation<?>)componentType, (Collection)element, path));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(element, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, Bson bson, ObjectPath path) {
        Assert.notNull((Object)bson, (String)"Document must not be null!");
        Assert.notNull((Object)path, (String)"Object path must not be null!");
        Class mapType = this.typeMapper.readType(bson, type).getType();
        TypeInformation keyType = type.getComponentType();
        TypeInformation valueType = type.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Class rawValueType = valueType != null ? valueType.getType() : null;
        Map<String, Object> sourceMap = MappingMongoConverter.asMap(bson);
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)sourceMap.keySet().size());
        if (!com.mongodb.DBRef.class.equals((Object)rawValueType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceMap.values())) {
            this.bulkReadAndConvertDBRefMapIntoTarget(valueType, rawValueType, sourceMap, map);
            return map;
        }
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            TypeInformation defaultedValueType;
            if (this.typeMapper.isTypeKey(entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey(entry.getKey());
            if (rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.conversionService.convert(key, rawKeyType);
            }
            Object value = entry.getValue();
            Object object = defaultedValueType = valueType != null ? valueType : ClassTypeInformation.OBJECT;
            if (value instanceof Document) {
                map.put(key, this.read(defaultedValueType, (Bson)((Document)value), path));
                continue;
            }
            if (value instanceof BasicDBObject) {
                map.put(key, this.read(defaultedValueType, (Bson)((BasicDBObject)value), path));
                continue;
            }
            if (value instanceof com.mongodb.DBRef) {
                map.put(key, com.mongodb.DBRef.class.equals((Object)rawValueType) ? value : this.readAndConvertDBRef((com.mongodb.DBRef)value, defaultedValueType, ObjectPath.ROOT, rawValueType));
                continue;
            }
            if (value instanceof List) {
                map.put(key, this.readCollectionOrArray((TypeInformation<?>)(valueType != null ? valueType : ClassTypeInformation.LIST), (List)value, path));
                continue;
            }
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, rawValueType));
        }
        return map;
    }

    private static Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof DBObject) {
            return ((DBObject)bson).toMap();
        }
        throw new IllegalArgumentException(String.format("Cannot read %s. as map. Given Bson must be a Document or DBObject!", bson.getClass()));
    }

    private static void addToMap(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).put(key, value);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add key/value pair to %s. as map. Given Bson must be a Document or DBObject!", bson.getClass()));
    }

    private static void addAllToMap(Bson bson, Map<String, ?> value) {
        if (bson instanceof Document) {
            ((Document)bson).putAll(value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).putAll(value);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add all to %s. Given Bson must be a Document or DBObject.", bson.getClass()));
    }

    private static void removeFromMap(Bson bson, String key) {
        if (bson instanceof Document) {
            ((Document)bson).remove((Object)key);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).removeField(key);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot remove from %s. Given Bson must be a Document or DBObject.", bson.getClass()));
    }

    @Override
    @Nullable
    public Object convertToMongoType(@Nullable Object obj, TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Optional target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target.isPresent()) {
            return this.conversionService.convert(obj, (Class)target.get());
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        if (obj instanceof List) {
            return this.maybeConvertList((List)obj, typeInformation);
        }
        if (obj instanceof Document) {
            Document newValueDocument = new Document();
            for (String vk : ((Document)obj).keySet()) {
                Object o = ((Document)obj).get((Object)vk);
                newValueDocument.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDocument;
        }
        if (obj instanceof DBObject) {
            Document newValueDbo = new Document();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            Document result = new Document();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeInformation));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeInformation);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeInformation);
        }
        Document newDocument = new Document();
        this.write(obj, (Bson)newDocument);
        if (typeInformation == null) {
            return this.removeTypeInfo(newDocument, true);
        }
        if (typeInformation.getType().equals(NestedDocument.class)) {
            return this.removeTypeInfo(newDocument, false);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDocument : this.removeTypeInfo(newDocument, true);
    }

    public List<Object> maybeConvertList(Iterable<?> source, TypeInformation<?> typeInformation) {
        ArrayList<Object> newDbl = new ArrayList<Object>();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfo(Object object, boolean recursively) {
        if (!(object instanceof Document)) {
            return object;
        }
        Document document = (Document)object;
        String keyToRemove = null;
        for (String key : document.keySet()) {
            if (recursively) {
                Object value = document.get((Object)key);
                if (value instanceof BasicDBList) {
                    for (Object element : (BasicDBList)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else if (value instanceof List) {
                    for (Object element : (List)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else {
                    this.removeTypeInfo(value, recursively);
                }
            }
            if (!this.typeMapper.isTypeKey(key)) continue;
            keyToRemove = key;
            if (recursively) continue;
            break;
        }
        if (keyToRemove != null) {
            document.remove(keyToRemove);
        }
        return document;
    }

    @Nullable
    <T> T readValue(Object value, TypeInformation<?> type, ObjectPath path) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.conversionService.convert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return this.potentiallyReadOrResolveDbRef((com.mongodb.DBRef)value, type, path, rawType);
        }
        if (value instanceof List) {
            return (T)this.readCollectionOrArray(type, (List)value, path);
        }
        if (value instanceof Document) {
            return (T)this.read(type, (Bson)((Document)value), path);
        }
        if (value instanceof DBObject) {
            return (T)this.read(type, (Bson)((BasicDBObject)value), path);
        }
        return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    @Nullable
    private <T> T potentiallyReadOrResolveDbRef(@Nullable com.mongodb.DBRef dbref, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        if (rawType.equals(com.mongodb.DBRef.class)) {
            return (T)dbref;
        }
        T object = dbref == null ? null : (T)path.getPathItem(dbref.getId(), dbref.getCollectionName(), rawType);
        return object != null ? object : (T)this.readAndConvertDBRef(dbref, type, path, rawType);
    }

    @Nullable
    private <T> T readAndConvertDBRef(@Nullable com.mongodb.DBRef dbref, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        List<T> result = this.bulkReadAndConvertDBRefs(Collections.singletonList(dbref), type, path, rawType);
        return CollectionUtils.isEmpty(result) ? null : (T)result.iterator().next();
    }

    private void bulkReadAndConvertDBRefMapIntoTarget(TypeInformation<?> valueType, Class<?> rawValueType, Map<String, Object> sourceMap, Map<Object, Object> targetMap) {
        LinkedHashMap<String, Object> referenceMap = new LinkedHashMap<String, Object>(sourceMap);
        List convertedObjects = this.bulkReadAndConvertDBRefs(new ArrayList<Object>(referenceMap.values()), valueType, ObjectPath.ROOT, rawValueType);
        int index = 0;
        for (String key : referenceMap.keySet()) {
            targetMap.put(key, convertedObjects.get(index));
            ++index;
        }
    }

    private <T> List<T> bulkReadAndConvertDBRefs(List<com.mongodb.DBRef> dbrefs, TypeInformation<?> type, ObjectPath path, Class<?> rawType) {
        if (CollectionUtils.isEmpty(dbrefs)) {
            return Collections.emptyList();
        }
        List<Document> referencedRawDocuments = dbrefs.size() == 1 ? Collections.singletonList(this.readRef(dbrefs.iterator().next())) : this.bulkReadRefs(dbrefs);
        String collectionName = dbrefs.iterator().next().getCollectionName();
        ArrayList targeList = new ArrayList(dbrefs.size());
        for (Document document : referencedRawDocuments) {
            if (document != null) {
                this.maybeEmitEvent(new AfterLoadEvent(document, rawType, collectionName));
            }
            Object target = this.read(type, (Bson)document, path);
            targeList.add(target);
            if (target == null) continue;
            this.maybeEmitEvent(new AfterConvertEvent(document, target, collectionName));
        }
        return targeList;
    }

    private void maybeEmitEvent(MongoMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    Document readRef(com.mongodb.DBRef ref) {
        return this.dbRefResolver.fetch(ref);
    }

    List<Document> bulkReadRefs(List<com.mongodb.DBRef> references) {
        return this.dbRefResolver.bulkFetch(references);
    }

    private static boolean isCollectionOfDbRefWhereBulkFetchIsPossible(Iterable<?> source) {
        Assert.notNull(source, (String)"Iterable of DBRefs must not be null!");
        HashSet<String> collectionsFound = new HashSet<String>();
        for (Object dbObjItem : source) {
            if (!(dbObjItem instanceof com.mongodb.DBRef)) {
                return false;
            }
            collectionsFound.add(((com.mongodb.DBRef)dbObjItem).getCollectionName());
            if (collectionsFound.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubTypeOf(Class<?> type, Class<?> reference) {
        return !type.equals(reference) && reference.isAssignableFrom(type);
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<MongoPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return null;
        }
    }

    static class NestedDocument {
        NestedDocument() {
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ObjectPath path;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate, ObjectPath path) {
            super(evaluator, conversionService, delegate);
            this.path = path;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return MappingMongoConverter.this.readValue(object, parameter.getType(), this.path);
        }
    }

    class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        private final DocumentAccessor source;
        private final SpELExpressionEvaluator evaluator;
        private final ObjectPath path;

        public MongoDbPropertyValueProvider(Bson source, SpELExpressionEvaluator evaluator, ObjectPath path) {
            Assert.notNull((Object)source, (String)"Source document must no be null!");
            Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null!");
            Assert.notNull((Object)path, (String)"ObjectPath must not be null!");
            this.source = new DocumentAccessor(source);
            this.evaluator = evaluator;
            this.path = path;
        }

        public MongoDbPropertyValueProvider(DocumentAccessor accessor, SpELExpressionEvaluator evaluator, ObjectPath path) {
            Assert.notNull((Object)accessor, (String)"DocumentAccessor must no be null!");
            Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null!");
            Assert.notNull((Object)path, (String)"ObjectPath must not be null!");
            this.source = accessor;
            this.evaluator = evaluator;
            this.path = path;
        }

        @Nullable
        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(property);
            if (value == null) {
                return null;
            }
            return MappingMongoConverter.this.readValue(value, property.getTypeInformation(), this.path);
        }
    }
}

