/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.ReactiveMongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveMongoQuery
implements RepositoryQuery {
    private final ReactiveMongoQueryMethod method;
    private final ReactiveMongoOperations operations;
    private final EntityInstantiators instantiators;

    public AbstractReactiveMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations operations) {
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveMongoOperations must not be null!");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        return this.method.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new MongoParametersParameterAccessor(this.method, parameters));
    }

    private Object executeDeferred(Object[] parameters) {
        ReactiveMongoParameterAccessor parameterAccessor = new ReactiveMongoParameterAccessor(this.method, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(MongoParameterAccessor parameterAccessor) {
        Query query = this.createQuery(new ConvertingParameterAccessor(this.operations.getConverter(), parameterAccessor));
        this.applyQueryMetaAttributesWhenPresent(query);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        String collection = this.method.getEntityInformation().getCollectionName();
        ReactiveMongoQueryExecution execution = this.getExecution(query, parameterAccessor, new ReactiveMongoQueryExecution.ResultProcessingConverter(processor, this.operations, this.instantiators));
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private ReactiveMongoQueryExecution getExecution(Query query, MongoParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        return new ReactiveMongoQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor), resultProcessing);
    }

    private ReactiveMongoQueryExecution getExecutionToWrap(MongoParameterAccessor accessor) {
        if (this.isDeleteQuery()) {
            return new ReactiveMongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery()) {
            return new ReactiveMongoQueryExecution.GeoNearExecution(this.operations, accessor, this.method.getReturnType());
        }
        if (this.isTailable(this.method)) {
            return new ReactiveMongoQueryExecution.TailExecution(this.operations, accessor.getPageable());
        }
        if (this.method.isCollectionQuery()) {
            return new ReactiveMongoQueryExecution.CollectionExecution(this.operations, accessor.getPageable());
        }
        return new ReactiveMongoQueryExecution.SingleEntityExecution(this.operations, this.isCountQuery());
    }

    private boolean isTailable(MongoQueryMethod method) {
        return method.getTailableAnnotation() != null;
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isDeleteQuery();
}

