/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BasicQuery
extends Query {
    private final Document queryObject;
    private Document fieldsObject;
    private Document sortObject;

    public BasicQuery(@Nullable String query) {
        this(query, null);
    }

    public BasicQuery(Document queryObject) {
        this(queryObject, new Document());
    }

    public BasicQuery(@Nullable String query, @Nullable String fields) {
        this(query != null ? Document.parse((String)query) : new Document(), fields != null ? Document.parse((String)fields) : new Document());
    }

    public BasicQuery(Document queryObject, Document fieldsObject) {
        Assert.notNull((Object)queryObject, (String)"Query document must not be null");
        Assert.notNull((Object)fieldsObject, (String)"Field document must not be null");
        this.queryObject = queryObject;
        this.fieldsObject = fieldsObject;
        this.sortObject = new Document();
    }

    @Override
    public Query addCriteria(CriteriaDefinition criteria) {
        this.queryObject.putAll((Map)criteria.getCriteriaObject());
        return this;
    }

    @Override
    public Document getQueryObject() {
        return this.queryObject;
    }

    @Override
    public Document getFieldsObject() {
        Document combinedFieldsObject = new Document();
        combinedFieldsObject.putAll((Map)this.fieldsObject);
        combinedFieldsObject.putAll((Map)super.getFieldsObject());
        return combinedFieldsObject;
    }

    @Override
    public Document getSortObject() {
        Document result = new Document();
        result.putAll((Map)this.sortObject);
        Document overrides = super.getSortObject();
        result.putAll((Map)overrides);
        return result;
    }

    public void setSortObject(Document sortObject) {
        Assert.notNull((Object)sortObject, (String)"Sort document must not be null");
        this.sortObject = sortObject;
    }

    protected void setFieldsObject(Document fieldsObject) {
        Assert.notNull((Object)this.sortObject, (String)"Field document must not be null");
        this.fieldsObject = fieldsObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicQuery)) {
            return false;
        }
        BasicQuery that = (BasicQuery)o;
        return this.querySettingsEquals(that) && ObjectUtils.nullSafeEquals((Object)this.fieldsObject, (Object)that.fieldsObject) && ObjectUtils.nullSafeEquals((Object)this.queryObject, (Object)that.queryObject) && ObjectUtils.nullSafeEquals((Object)this.sortObject, (Object)that.sortObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.queryObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.fieldsObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sortObject);
        return result;
    }
}

