/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleMongoDbFactory
implements DisposableBean,
MongoDbFactory {
    private final MongoClient mongoClient;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern writeConcern;

    public SimpleMongoDbFactory(MongoClientURI uri) {
        this(new MongoClient(uri), uri.getDatabase(), true);
    }

    public SimpleMongoDbFactory(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    private SimpleMongoDbFactory(MongoClient mongoClient, String databaseName, boolean mongoInstanceCreated) {
        Assert.notNull((Object)mongoClient, (String)"MongoClient must not be null!");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty!");
        Assert.isTrue((boolean)databaseName.matches("[^/\\\\.$\"\\s]+"), (String)"Database name must not contain slashes, dots, spaces, quotes, or dollar signs!");
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.exceptionTranslator = new MongoExceptionTranslator();
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public MongoDatabase getDb() throws DataAccessException {
        return this.getDb(this.databaseName);
    }

    @Override
    public MongoDatabase getDb(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty.");
        MongoDatabase db = this.mongoClient.getDatabase(dbName);
        if (this.writeConcern == null) {
            return db;
        }
        return db.withWriteConcern(this.writeConcern);
    }

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.mongoClient.close();
        }
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Override
    public DB getLegacyDb() {
        return this.mongoClient.getDB(this.databaseName);
    }
}

