/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableRemoveOperationSupport
implements ExecutableRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final MongoTemplate tempate;

    @Override
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableRemoveSupport<T>(this.tempate, domainType, ALL_QUERY, null);
    }

    public ExecutableRemoveOperationSupport(@NonNull MongoTemplate tempate) {
        if (tempate == null) {
            throw new IllegalArgumentException("tempate is null");
        }
        this.tempate = tempate;
    }

    static class ExecutableRemoveSupport<T>
    implements ExecutableRemoveOperation.ExecutableRemove<T>,
    ExecutableRemoveOperation.RemoveWithCollection<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        private final Query query;
        @Nullable
        private final String collection;

        @Override
        public ExecutableRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ExecutableRemoveSupport<T>(this.template, this.domainType, this.query, collection);
        }

        @Override
        public ExecutableRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableRemoveSupport<T>(this.template, this.domainType, query, this.collection);
        }

        @Override
        public DeleteResult all() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, true);
        }

        @Override
        public DeleteResult one() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, false);
        }

        @Override
        public List<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        public ExecutableRemoveSupport(@NonNull MongoTemplate template, @NonNull Class<T> domainType, Query query, @Nullable String collection) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
        }
    }
}

