/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import lombok.NonNull;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableUpdateOperationSupport
implements ExecutableUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final MongoTemplate template;

    @Override
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableUpdateSupport<T>(this.template, domainType, ALL_QUERY, null, null, null);
    }

    public ExecutableUpdateOperationSupport(@NonNull MongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        this.template = template;
    }

    static class ExecutableUpdateSupport<T>
    implements ExecutableUpdateOperation.ExecutableUpdate<T>,
    ExecutableUpdateOperation.UpdateWithCollection<T>,
    ExecutableUpdateOperation.UpdateWithQuery<T>,
    ExecutableUpdateOperation.TerminatingUpdate<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        private final Query query;
        @Nullable
        private final Update update;
        @Nullable
        private final String collection;
        @Nullable
        private final FindAndModifyOptions options;

        @Override
        public ExecutableUpdateOperation.TerminatingUpdate<T> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, update, this.collection, this.options);
        }

        @Override
        public ExecutableUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, collection, this.options);
        }

        @Override
        public ExecutableUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, options);
        }

        @Override
        public ExecutableUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, query, this.update, this.collection, this.options);
        }

        @Override
        public UpdateResult all() {
            return this.doUpdate(true, false);
        }

        @Override
        public UpdateResult first() {
            return this.doUpdate(false, false);
        }

        @Override
        public UpdateResult upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        @Nullable
        public T findAndModifyValue() {
            return this.template.findAndModify(this.query, this.update, this.options != null ? this.options : new FindAndModifyOptions(), this.domainType, this.getCollectionName());
        }

        private UpdateResult doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        public ExecutableUpdateSupport(@NonNull MongoTemplate template, @NonNull Class<T> domainType, Query query, @Nullable Update update, @Nullable String collection, @Nullable FindAndModifyOptions options) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.options = options;
        }
    }
}

