/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.ClientSessionOptions;
import com.mongodb.CursorType;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.util.JSONParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ChangeStreamEvent;
import org.springframework.data.mongodb.core.ChangeStreamOptions;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.DefaultReactiveIndexOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindPublisherPreparer;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.ReactiveAggregationOperation;
import org.springframework.data.mongodb.core.ReactiveAggregationOperationSupport;
import org.springframework.data.mongodb.core.ReactiveCollectionCallback;
import org.springframework.data.mongodb.core.ReactiveDatabaseCallback;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveFindOperationSupport;
import org.springframework.data.mongodb.core.ReactiveInsertOperation;
import org.springframework.data.mongodb.core.ReactiveInsertOperationSupport;
import org.springframework.data.mongodb.core.ReactiveMapReduceOperation;
import org.springframework.data.mongodb.core.ReactiveMapReduceOperationSupport;
import org.springframework.data.mongodb.core.ReactiveMongoContext;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveRemoveOperation;
import org.springframework.data.mongodb.core.ReactiveRemoveOperationSupport;
import org.springframework.data.mongodb.core.ReactiveSessionCallback;
import org.springframework.data.mongodb.core.ReactiveSessionScoped;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.ReactiveUpdateOperationSupport;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.PrefixingDelegatingAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.JsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperations;
import org.springframework.data.mongodb.core.index.ReactiveMongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ReactiveMongoTemplate
implements ReactiveMongoOperations,
ApplicationContextAware {
    public static final DbRefResolver NO_OP_REF_RESOLVER = new NoOpDbRefResolver();
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMongoTemplate.class);
    private static final String ID_FIELD = "_id";
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private static final Collection<Class<?>> ITERABLE_CLASSES;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final ReactiveMongoDatabaseFactory mongoDatabaseFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final JsonSchemaMapper schemaMapper;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final ApplicationListener<MappingContextEvent<?, ?>> indexCreatorListener;
    @Nullable
    private WriteConcern writeConcern;
    private WriteConcernResolver writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    @Nullable
    private ReadPreference readPreference;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    @Nullable
    private ReactiveMongoPersistentEntityIndexCreator indexCreator;

    public ReactiveMongoTemplate(MongoClient mongoClient, String databaseName) {
        this((ReactiveMongoDatabaseFactory)new SimpleReactiveMongoDatabaseFactory(mongoClient, databaseName), (MongoConverter)null);
    }

    public ReactiveMongoTemplate(ReactiveMongoDatabaseFactory mongoDatabaseFactory) {
        this(mongoDatabaseFactory, (MongoConverter)null);
    }

    public ReactiveMongoTemplate(ReactiveMongoDatabaseFactory mongoDatabaseFactory, @Nullable MongoConverter mongoConverter) {
        this(mongoDatabaseFactory, mongoConverter, ReactiveMongoTemplate::handleSubscriptionException);
    }

    public ReactiveMongoTemplate(ReactiveMongoDatabaseFactory mongoDatabaseFactory, @Nullable MongoConverter mongoConverter, Consumer<Throwable> subscriptionExceptionHandler) {
        Assert.notNull((Object)mongoDatabaseFactory, (String)"ReactiveMongoDatabaseFactory must not be null!");
        this.mongoDatabaseFactory = mongoDatabaseFactory;
        this.exceptionTranslator = mongoDatabaseFactory.getExceptionTranslator();
        this.mongoConverter = mongoConverter == null ? ReactiveMongoTemplate.getDefaultMongoConverter() : mongoConverter;
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
        this.schemaMapper = new MongoJsonSchemaMapper(this.mongoConverter);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.indexCreatorListener = new IndexCreatorEventListener(subscriptionExceptionHandler);
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (this.mappingContext instanceof MongoMappingContext) {
            MongoMappingContext mongoMappingContext = (MongoMappingContext)this.mappingContext;
            this.indexCreator = new ReactiveMongoPersistentEntityIndexCreator(mongoMappingContext, this::indexOps);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreatorListener);
            mongoMappingContext.setApplicationEventPublisher(this.eventPublisher);
            this.mappingContext.getPersistentEntities().forEach(entity -> this.onCheckForIndexes((MongoPersistentEntity<?>)entity, subscriptionExceptionHandler));
        }
    }

    private ReactiveMongoTemplate(ReactiveMongoDatabaseFactory dbFactory, ReactiveMongoTemplate that) {
        this.mongoDatabaseFactory = dbFactory;
        this.exceptionTranslator = that.exceptionTranslator;
        this.mongoConverter = that.mongoConverter;
        this.queryMapper = that.queryMapper;
        this.updateMapper = that.updateMapper;
        this.schemaMapper = that.schemaMapper;
        this.projectionFactory = that.projectionFactory;
        this.indexCreator = that.indexCreator;
        this.indexCreatorListener = that.indexCreatorListener;
        this.mappingContext = that.mappingContext;
    }

    private void onCheckForIndexes(MongoPersistentEntity<?> entity, Consumer<Throwable> subscriptionExceptionHandler) {
        if (this.indexCreator != null) {
            this.indexCreator.checkForIndexes(entity).subscribe(v -> {}, subscriptionExceptionHandler);
        }
    }

    private static void handleSubscriptionException(Throwable t) {
        LOGGER.error("Unexpected exception during asynchronous execution", t);
    }

    public void setWriteResultChecking(@Nullable WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(@Nullable WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.eventPublisher = applicationContext;
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
        }
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(ReactiveMongoPersistentEntityIndexCreator.class)) {
            ReactiveMongoPersistentEntityIndexCreator creatorBean = (ReactiveMongoPersistentEntityIndexCreator)context.getBean(creator, ReactiveMongoPersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).addApplicationListener(this.indexCreatorListener);
        }
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public ReactiveIndexOperations indexOps(String collectionName) {
        return new DefaultReactiveIndexOperations(this, collectionName, this.queryMapper);
    }

    @Override
    public ReactiveIndexOperations indexOps(Class<?> entityClass) {
        return new DefaultReactiveIndexOperations((ReactiveMongoOperations)this, this.determineCollectionName(entityClass), this.queryMapper, entityClass);
    }

    public String getCollectionName(Class<?> entityClass) {
        return this.determineCollectionName(entityClass);
    }

    @Override
    public Mono<Document> executeCommand(String jsonCommand) {
        Assert.notNull((Object)jsonCommand, (String)"Command must not be empty!");
        return this.executeCommand(Document.parse((String)jsonCommand));
    }

    @Override
    public Mono<Document> executeCommand(Document command) {
        return this.executeCommand(command, null);
    }

    @Override
    public Mono<Document> executeCommand(Document command, @Nullable ReadPreference readPreference) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        return this.createFlux(db -> readPreference != null ? db.runCommand((Bson)command, readPreference, Document.class) : db.runCommand((Bson)command, Document.class)).next();
    }

    @Override
    public <T> Flux<T> execute(Class<?> entityClass, ReactiveCollectionCallback<T> action) {
        return this.createFlux(this.determineCollectionName(entityClass), action);
    }

    @Override
    public <T> Flux<T> execute(ReactiveDatabaseCallback<T> action) {
        return this.createFlux(action);
    }

    @Override
    public <T> Flux<T> execute(String collectionName, ReactiveCollectionCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveCollectionCallback must not be null!");
        return this.createFlux(collectionName, callback);
    }

    @Override
    public ReactiveSessionScoped withSession(Publisher<ClientSession> sessionProvider) {
        final Mono cachedSession = Mono.from(sessionProvider).cache();
        return new ReactiveSessionScoped(){

            @Override
            public <T> Flux<T> execute(ReactiveSessionCallback<T> action, Consumer<ClientSession> doFinally) {
                return cachedSession.flatMapMany(session -> ReactiveMongoTemplate.this.withSession(action, session).doFinally(signalType -> doFinally.accept((ClientSession)session)));
            }
        };
    }

    @Override
    public ReactiveSessionScoped inTransaction() {
        return this.inTransaction((Publisher<ClientSession>)this.mongoDatabaseFactory.getSession(ClientSessionOptions.builder().causallyConsistent(true).build()));
    }

    @Override
    public ReactiveSessionScoped inTransaction(Publisher<ClientSession> sessionProvider) {
        final Mono cachedSession = Mono.from(sessionProvider).cache();
        return new ReactiveSessionScoped(){

            @Override
            public <T> Flux<T> execute(ReactiveSessionCallback<T> action, Consumer<ClientSession> doFinally) {
                return cachedSession.flatMapMany(session -> {
                    if (!session.hasActiveTransaction()) {
                        session.startTransaction();
                    }
                    return ReactiveMongoTemplate.this.withSession(action, session).materialize().flatMap(signal -> {
                        if (session.hasActiveTransaction()) {
                            if (signal.isOnComplete()) {
                                return Mono.from((Publisher)session.commitTransaction()).thenReturn(signal);
                            }
                            if (signal.isOnError()) {
                                return Mono.from((Publisher)session.abortTransaction()).thenReturn(signal);
                            }
                        }
                        return Mono.just((Object)signal);
                    }).dematerialize().doFinally(signalType -> doFinally.accept((ClientSession)session));
                });
            }
        };
    }

    private <T> Flux<T> withSession(ReactiveSessionCallback<T> action, ClientSession session) {
        return Flux.from(action.doInSession(new ReactiveSessionBoundMongoTemplate(session, this))).subscriberContext(ctx -> ReactiveMongoContext.setSession(ctx, (Publisher<ClientSession>)Mono.just((Object)session)));
    }

    @Override
    public ReactiveMongoOperations withSession(ClientSession session) {
        return new ReactiveSessionBoundMongoTemplate(session, this);
    }

    @Override
    public ReactiveSessionScoped withSession(ClientSessionOptions sessionOptions) {
        return this.withSession((Publisher<ClientSession>)this.mongoDatabaseFactory.getSession(sessionOptions));
    }

    public <T> Flux<T> createFlux(ReactiveDatabaseCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveDatabaseCallback must not be null!");
        return Flux.defer(() -> callback.doInDB(this.prepareDatabase(this.doGetDatabase()))).onErrorMap(this.translateException());
    }

    public <T> Mono<T> createMono(ReactiveDatabaseCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveDatabaseCallback must not be null!");
        return Mono.defer(() -> Mono.from(callback.doInDB(this.prepareDatabase(this.doGetDatabase())))).onErrorMap(this.translateException());
    }

    public <T> Flux<T> createFlux(String collectionName, ReactiveCollectionCallback<T> callback) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull(callback, (String)"ReactiveDatabaseCallback must not be null!");
        Mono collectionPublisher = Mono.fromCallable(() -> this.getAndPrepareCollection(this.doGetDatabase(), collectionName));
        return collectionPublisher.flatMapMany(callback::doInCollection).onErrorMap(this.translateException());
    }

    public <T> Mono<T> createMono(String collectionName, ReactiveCollectionCallback<T> callback) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull(callback, (String)"ReactiveCollectionCallback must not be null!");
        Mono collectionPublisher = Mono.fromCallable(() -> this.getAndPrepareCollection(this.doGetDatabase(), collectionName));
        return collectionPublisher.flatMap(collection -> Mono.from(callback.doInCollection((MongoCollection<Document>)collection))).onErrorMap(this.translateException());
    }

    @Override
    public <T> Mono<MongoCollection<Document>> createCollection(Class<T> entityClass) {
        return this.createCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<MongoCollection<Document>> createCollection(Class<T> entityClass, @Nullable CollectionOptions collectionOptions) {
        return this.doCreateCollection(this.determineCollectionName(entityClass), this.convertToCreateCollectionOptions(collectionOptions, entityClass));
    }

    @Override
    public Mono<MongoCollection<Document>> createCollection(String collectionName) {
        return this.doCreateCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public Mono<MongoCollection<Document>> createCollection(String collectionName, @Nullable CollectionOptions collectionOptions) {
        return this.doCreateCollection(collectionName, this.convertToCreateCollectionOptions(collectionOptions));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.execute((MongoDatabase db) -> db.getCollection(collectionName));
    }

    @Override
    public <T> Mono<Boolean> collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.determineCollectionName(entityClass));
    }

    @Override
    public Mono<Boolean> collectionExists(String collectionName) {
        return this.createMono(db -> Flux.from((Publisher)db.listCollectionNames()).filter(s -> s.equals(collectionName)).map(s -> true).single((Object)false));
    }

    @Override
    public <T> Mono<Void> dropCollection(Class<T> entityClass) {
        return this.dropCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public Mono<Void> dropCollection(String collectionName) {
        return this.createMono(collectionName, collection -> collection.drop()).doOnSuccess(success -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Dropped collection [" + collectionName + "]");
            }
        }).then();
    }

    @Override
    public Flux<String> getCollectionNames() {
        return this.createFlux(MongoDatabase::listCollectionNames);
    }

    public MongoDatabase getMongoDatabase() {
        return this.doGetDatabase();
    }

    protected MongoDatabase doGetDatabase() {
        return this.mongoDatabaseFactory.getMongoDatabase();
    }

    @Override
    public <T> Mono<T> findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<T> findOne(Query query, Class<T> entityClass, String collectionName) {
        if (ObjectUtils.isEmpty((Object)query.getSortObject())) {
            return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, query.getCollation().orElse(null));
        }
        query.limit(1);
        return this.find(query, entityClass, collectionName).next();
    }

    @Override
    public Mono<Boolean> exists(Query query, Class<?> entityClass) {
        return this.exists(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public Mono<Boolean> exists(Query query, String collectionName) {
        return this.exists(query, null, collectionName);
    }

    @Override
    public Mono<Boolean> exists(Query query, @Nullable Class<?> entityClass, String collectionName) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        return this.createFlux(collectionName, collection -> {
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), this.getPersistentEntity(entityClass));
            FindPublisher findPublisher = collection.find((Bson)mappedQuery, Document.class).projection((Bson)new Document(ID_FIELD, (Object)1));
            findPublisher = query.getCollation().map(Collation::toMongoCollation).map(arg_0 -> ((FindPublisher)findPublisher).collation(arg_0)).orElse(findPublisher);
            return findPublisher.limit(1);
        }).hasElements();
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<T> find(@Nullable Query query, Class<T> entityClass, String collectionName) {
        if (query == null) {
            return this.findAll(entityClass, collectionName);
        }
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, new QueryFindPublisherPreparer(query, entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass, String collectionName) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        MongoPersistentProperty idProperty = persistentEntity != null ? (MongoPersistentProperty)persistentEntity.getIdProperty() : null;
        String idKey = idProperty == null ? ID_FIELD : idProperty.getName();
        return this.doFindOne(collectionName, new Document(idKey, id), null, entityClass, null);
    }

    @Override
    public <T> Flux<T> findDistinct(Query query, String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(query, field, this.determineCollectionName(entityClass), entityClass, resultClass);
    }

    @Override
    public <T> Flux<T> findDistinct(Query query, String field, String collectionName, Class<?> entityClass, Class<T> resultClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull(resultClass, (String)"ResultClass must not be null!");
        MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
        String mappedFieldName = (String)this.queryMapper.getMappedFields(new Document(field, (Object)1), entity).keySet().iterator().next();
        Class<BsonValue> mongoDriverCompatibleType = this.mongoDatabaseFactory.getCodecFor(resultClass).map(Encoder::getEncoderClass).orElse(BsonValue.class);
        Flux result = this.execute(collectionName, (MongoCollection<Document> collection) -> {
            DistinctPublisher publisher = collection.distinct(mappedFieldName, (Bson)mappedQuery, mongoDriverCompatibleType);
            return (Publisher)query.getCollation().map(Collation::toMongoCollation).map(arg_0 -> ((DistinctPublisher)publisher).collation(arg_0)).orElse(publisher);
        });
        if (resultClass == Object.class || mongoDriverCompatibleType != resultClass) {
            Class<?> targetType = ReactiveMongoTemplate.getMostSpecificConversionTargetType(resultClass, entityClass, field);
            MongoConverter converter = this.getConverter();
            result = result.map(it -> converter.mapValueToTargetType(it, targetType, NO_OP_REF_RESOLVER));
        }
        return result;
    }

    private static Class<?> getMostSpecificConversionTargetType(Class<?> userType, Class<?> domainType, String field) {
        Class conversionTargetType = userType;
        try {
            Class propertyType = PropertyPath.from((String)field, domainType).getLeafProperty().getLeafType();
            if (ClassUtils.isAssignable(userType, (Class)propertyType)) {
                conversionTargetType = propertyType;
            }
        }
        catch (PropertyReferenceException propertyReferenceException) {
            // empty catch block
        }
        return conversionTargetType;
    }

    @Override
    public <O> Flux<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null!");
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(aggregation.getInputType(), this.mappingContext, this.queryMapper);
        return this.aggregate(aggregation, inputCollectionName, outputType, context);
    }

    @Override
    public <O> Flux<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> Flux<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(inputType), outputType, new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper));
    }

    @Override
    public <O> Flux<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregate(aggregation, collectionName, outputType, null);
    }

    protected <O> Flux<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AggregationOperationContext rootContext = context == null ? Aggregation.DEFAULT_CONTEXT : context;
        AggregationOptions options = aggregation.getOptions();
        List<Document> pipeline = aggregation.toPipeline(rootContext);
        Assert.isTrue((!options.isExplain() ? 1 : 0) != 0, (String)"Cannot use explain option with streaming!");
        Assert.isNull((Object)options.getCursorBatchSize(), (String)"Cannot use batchSize cursor option with streaming!");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Streaming aggregation: {} in collection {}", (Object)SerializationUtils.serializeToJsonSafely(pipeline), (Object)collectionName);
        }
        ReadDocumentCallback<Object> readCallback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> this.aggregateAndMap((MongoCollection<Document>)collection, pipeline, options, readCallback));
    }

    private <O> Flux<O> aggregateAndMap(MongoCollection<Document> collection, List<Document> pipeline, AggregationOptions options, ReadDocumentCallback<O> readCallback) {
        AggregatePublisher cursor = collection.aggregate(pipeline, Document.class).allowDiskUse(Boolean.valueOf(options.isAllowDiskUse())).useCursor(Boolean.valueOf(true));
        if (options.getCollation().isPresent()) {
            cursor = cursor.collation(options.getCollation().map(Collation::toMongoCollation).get());
        }
        return Flux.from((Publisher)cursor).map(readCallback::doWith);
    }

    @Override
    public <T> Flux<GeoResult<T>> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<GeoResult<T>> geoNear(NearQuery near, Class<T> entityClass, String collectionName) {
        return this.geoNear(near, entityClass, collectionName, entityClass);
    }

    protected <T> Flux<GeoResult<T>> geoNear(NearQuery near, Class<?> entityClass, String collectionName, Class<T> returnType) {
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null!");
        }
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null!");
        }
        String collection = StringUtils.hasText((String)collectionName) ? collectionName : this.determineCollectionName(entityClass);
        Document nearDbObject = near.toDocument();
        Document command = new Document("geoNear", (Object)collection);
        command.putAll((Map)nearDbObject);
        return Flux.defer(() -> {
            if (nearDbObject.containsKey((Object)"query")) {
                Document query = (Document)nearDbObject.get((Object)"query");
                command.put("query", (Object)this.queryMapper.getMappedObject((Bson)query, this.getPersistentEntity(entityClass)));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing geoNear using: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(command), entityClass, collectionName});
            }
            GeoNearResultDbObjectCallback callback = new GeoNearResultDbObjectCallback(new ProjectingReadCallback(this.mongoConverter, entityClass, returnType, collectionName), near.getMetric());
            return this.executeCommand(command, this.readPreference).flatMapMany(document -> {
                List l = (List)document.get((Object)"results", List.class);
                if (l == null) {
                    return Flux.empty();
                }
                return Flux.fromIterable((Iterable)l);
            }).skip(near.getSkip() != null ? near.getSkip() : 0L).map(callback::doWith);
        });
    }

    @Override
    public <T> Mono<T> findAndModify(Query query, Update update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<T> findAndModify(Query query, Update update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    public <T> Mono<T> findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<T> findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        FindAndModifyOptions optionsToUse = FindAndModifyOptions.of(options);
        Optionals.ifAllPresent(query.getCollation(), optionsToUse.getCollation(), (l, r) -> {
            throw new IllegalArgumentException("Both Query and FindAndModifyOptions define a collation. Please provide the collation only via one of the two.");
        });
        query.getCollation().ifPresent(optionsToUse::collation);
        return this.doFindAndModify(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass, update, optionsToUse);
    }

    @Override
    public <T> Mono<T> findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Mono<T> findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), query.getCollation().orElse(null), entityClass);
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.count(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public Mono<Long> count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public Mono<Long> count(@Nullable Query query, @Nullable Class<?> entityClass, String collectionName) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        return this.createMono(collectionName, collection -> {
            Document Document2 = query == null ? null : this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entityClass == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass));
            CountOptions options = new CountOptions();
            if (query != null) {
                query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((CountOptions)options).collation(arg_0));
            }
            return collection.count((Bson)Document2, options);
        });
    }

    @Override
    public <T> Mono<T> insert(Mono<? extends T> objectToSave) {
        Assert.notNull(objectToSave, (String)"Mono to insert must not be null!");
        return objectToSave.flatMap(this::insert);
    }

    @Override
    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> batchToSave, Class<?> entityClass) {
        return this.insertAll(batchToSave, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> batchToSave, String collectionName) {
        Assert.notNull(batchToSave, (String)"Batch to insert must not be null!");
        return Flux.from(batchToSave).flatMap(collection -> this.insert((Collection)collection, collectionName));
    }

    @Override
    public <T> Mono<T> insert(T objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to insert must not be null!");
        this.ensureNotIterable(objectToSave);
        return this.insert(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public <T> Mono<T> insert(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, (String)"Object to insert must not be null!");
        this.ensureNotIterable(objectToSave);
        return this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected <T> Mono<T> doInsert(String collectionName, T objectToSave, MongoWriter<Object> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        return Mono.defer(() -> {
            this.initializeVersionProperty(objectToSave);
            this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToSave, collectionName));
            Document dbDoc = this.toDbObject(objectToSave, writer);
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToSave, dbDoc, collectionName));
            Mono afterInsert = this.insertDBObject(collectionName, dbDoc, objectToSave.getClass()).flatMap(id -> {
                this.populateIdIfNecessary(objectToSave, id);
                this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToSave, dbDoc, collectionName));
                return Mono.just((Object)objectToSave);
            });
            return afterInsert;
        });
    }

    @Override
    public <T> Flux<T> insert(Collection<? extends T> batchToSave, Class<?> entityClass) {
        return this.doInsertBatch(this.determineCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Flux<T> insert(Collection<? extends T> batchToSave, String collectionName) {
        return this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Flux<T> insertAll(Collection<? extends T> objectsToSave) {
        return this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    @Override
    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> objectsToSave) {
        return Flux.from(objectsToSave).flatMap(this::insertAll);
    }

    protected <T> Flux<T> doInsertAll(Collection<? extends T> listToSave, MongoWriter<Object> writer) {
        HashMap elementsByCollection = new HashMap();
        listToSave.forEach(element -> {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(element.getClass());
            String collection = entity.getCollection();
            ArrayList<Object> collectionElements = (ArrayList<Object>)elementsByCollection.get(collection);
            if (null == collectionElements) {
                collectionElements = new ArrayList<Object>();
                elementsByCollection.put(collection, collectionElements);
            }
            collectionElements.add(element);
        });
        return Flux.fromIterable(elementsByCollection.keySet()).flatMap(collectionName -> this.doInsertBatch((String)collectionName, (Collection)elementsByCollection.get(collectionName), writer));
    }

    protected <T> Flux<T> doInsertBatch(final String collectionName, Collection<? extends T> batchToSave, final MongoWriter<Object> writer) {
        Assert.notNull(writer, (String)"MongoWriter must not be null!");
        Mono prepareDocuments = Flux.fromIterable(batchToSave).flatMap(new Function<T, Flux<Tuple2<T, Document>>>(){

            @Override
            public Flux<Tuple2<T, Document>> apply(T o) {
                ReactiveMongoTemplate.this.initializeVersionProperty(o);
                ReactiveMongoTemplate.this.maybeEmitEvent(new BeforeConvertEvent(o, collectionName));
                Document dbDoc = ReactiveMongoTemplate.this.toDbObject(o, writer);
                ReactiveMongoTemplate.this.maybeEmitEvent(new BeforeSaveEvent(o, dbDoc, collectionName));
                return Flux.zip((Publisher)Mono.just(o), (Publisher)Mono.just((Object)dbDoc));
            }
        }).collectList();
        Flux insertDocuments = prepareDocuments.flatMapMany(tuples -> {
            List<Document> dbObjects = tuples.stream().map(Tuple2::getT2).collect(Collectors.toList());
            return this.insertDocumentList(collectionName, dbObjects).thenMany((Publisher)Flux.fromIterable((Iterable)tuples));
        });
        return insertDocuments.map(tuple -> {
            this.populateIdIfNecessary(tuple.getT1(), ((Document)tuple.getT2()).get((Object)ID_FIELD));
            this.maybeEmitEvent(new AfterSaveEvent<Object>(tuple.getT1(), (Document)tuple.getT2(), collectionName));
            return tuple.getT1();
        });
    }

    @Override
    public <T> Mono<T> save(Mono<? extends T> objectToSave) {
        Assert.notNull(objectToSave, (String)"Mono to save must not be null!");
        return objectToSave.flatMap(this::save);
    }

    @Override
    public <T> Mono<T> save(Mono<? extends T> objectToSave, String collectionName) {
        Assert.notNull(objectToSave, (String)"Mono to save must not be null!");
        return objectToSave.flatMap(o -> this.save(o, collectionName));
    }

    @Override
    public <T> Mono<T> save(T objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        return this.save(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public <T> Mono<T> save(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        MongoPersistentEntity<?> mongoPersistentEntity = this.getPersistentEntity(objectToSave.getClass());
        if (mongoPersistentEntity == null || !mongoPersistentEntity.hasVersionProperty()) {
            return this.doSave(collectionName, objectToSave, this.mongoConverter);
        }
        return this.doSaveVersioned(objectToSave, mongoPersistentEntity, collectionName);
    }

    private <T> Mono<T> doSaveVersioned(T objectToSave, MongoPersistentEntity<?> entity, String collectionName) {
        return this.createMono(collectionName, collection -> {
            ConvertingPropertyAccessor convertingAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(objectToSave), this.mongoConverter.getConversionService());
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)entity.getRequiredVersionProperty();
            Object version = convertingAccessor.getProperty((PersistentProperty)versionProperty);
            Number versionNumber = (Number)convertingAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
            if (version == null) {
                return this.doInsert(collectionName, objectToSave, this.mongoConverter);
            }
            this.assertUpdateableIdIfNotSet(objectToSave);
            Object id = convertingAccessor.getProperty((PersistentProperty)idProperty);
            Query query = new Query(Criteria.where(idProperty.getName()).is(id).and(versionProperty.getName()).is(version));
            if (versionNumber == null) {
                versionNumber = 0;
            }
            convertingAccessor.setProperty((PersistentProperty)versionProperty, (Object)(versionNumber.longValue() + 1L));
            this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToSave, collectionName));
            Document document = this.toDbObject(objectToSave, this.mongoConverter);
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToSave, document, collectionName));
            Update update = Update.fromDocument(document, ID_FIELD);
            return this.doUpdate(collectionName, query, update, objectToSave.getClass(), false, false).map(updateResult -> {
                this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToSave, document, collectionName));
                return objectToSave;
            });
        });
    }

    protected <T> Mono<T> doSave(String collectionName, T objectToSave, MongoWriter<Object> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        return this.createMono(collectionName, collection -> {
            this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToSave, collectionName));
            Document dbDoc = this.toDbObject(objectToSave, writer);
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToSave, dbDoc, collectionName));
            return this.saveDocument(collectionName, dbDoc, objectToSave.getClass()).map(id -> {
                this.populateIdIfNecessary(objectToSave, id);
                this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToSave, dbDoc, collectionName));
                return objectToSave;
            });
        });
    }

    protected Mono<Object> insertDBObject(String collectionName, Document dbDoc, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting Document containing fields: " + dbDoc.keySet() + " in collection: " + collectionName);
        }
        Document document = new Document((Map)dbDoc);
        Flux execute = this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, dbDoc, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MongoCollection<Document> collectionToUse = this.prepareCollection((MongoCollection<Document>)collection, writeConcernToUse);
            return collectionToUse.insertOne((Object)document);
        });
        return Flux.from(execute).last().map(success -> document.get((Object)ID_FIELD));
    }

    protected Flux<ObjectId> insertDocumentList(String collectionName, List<Document> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Flux.empty();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting list of DBObjects containing " + dbDocList.size() + " items");
        }
        ArrayList documents = new ArrayList();
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MongoCollection<Document> collectionToUse = this.prepareCollection((MongoCollection<Document>)collection, writeConcernToUse);
            documents.addAll(ReactiveMongoTemplate.toDocuments(dbDocList));
            return collectionToUse.insertMany(documents);
        }).flatMap(s -> {
            List documentsWithIds = documents.stream().filter(document -> document.get((Object)ID_FIELD) instanceof ObjectId).collect(Collectors.toList());
            return Flux.fromIterable(documentsWithIds);
        }).map(document -> (ObjectId)document.get((Object)ID_FIELD, ObjectId.class));
    }

    private MongoCollection<Document> prepareCollection(MongoCollection<Document> collection, @Nullable WriteConcern writeConcernToUse) {
        MongoCollection collectionToUse = collection;
        if (writeConcernToUse != null) {
            collectionToUse = collectionToUse.withWriteConcern(writeConcernToUse);
        }
        return collectionToUse;
    }

    protected Mono<Object> saveDocument(String collectionName, Document document, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving Document containing fields: " + document.keySet());
        }
        return this.createMono(collectionName, collection -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, document, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            Publisher publisher = !document.containsKey((Object)ID_FIELD) ? (writeConcernToUse == null ? collection.insertOne((Object)document) : collection.withWriteConcern(writeConcernToUse).insertOne((Object)document)) : (writeConcernToUse == null ? collection.replaceOne(Filters.eq((String)ID_FIELD, (Object)document.get((Object)ID_FIELD)), (Object)document, new ReplaceOptions().upsert(true)) : collection.withWriteConcern(writeConcernToUse).replaceOne(Filters.eq((String)ID_FIELD, (Object)document.get((Object)ID_FIELD)), (Object)document, new ReplaceOptions().upsert(true)));
            return Mono.from((Publisher)publisher).map(o -> document.get((Object)ID_FIELD));
        });
    }

    @Override
    public Mono<UpdateResult> upsert(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public Mono<UpdateResult> upsert(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public Mono<UpdateResult> upsert(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, true, false);
    }

    @Override
    public Mono<UpdateResult> updateFirst(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public Mono<UpdateResult> updateFirst(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public Mono<UpdateResult> updateFirst(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, false, false);
    }

    @Override
    public Mono<UpdateResult> updateMulti(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public Mono<UpdateResult> updateMulti(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    @Override
    public Mono<UpdateResult> updateMulti(Query query, Update update, Class<?> entityClass, String collectionName) {
        return this.doUpdate(collectionName, query, update, entityClass, false, true);
    }

    protected Mono<UpdateResult> doUpdate(String collectionName, @Nullable Query query, @Nullable Update update, @Nullable Class<?> entityClass, boolean upsert, boolean multi) {
        MongoPersistentEntity<?> entity = entityClass == null ? null : this.getPersistentEntity(entityClass);
        Flux result = this.execute(collectionName, (MongoCollection<Document> collection) -> {
            Document updateObj;
            this.increaseVersionForUpdateIfNecessary(entity, update);
            Document queryObj = query == null ? new Document() : this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
            Document document = updateObj = update == null ? new Document() : this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Calling update using query: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(updateObj), collectionName));
            }
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, updateObj, queryObj);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MongoCollection<Document> collectionToUse = this.prepareCollection((MongoCollection<Document>)collection, writeConcernToUse);
            UpdateOptions updateOptions = new UpdateOptions().upsert(upsert);
            query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)updateOptions).collation(arg_0));
            if (!UpdateMapper.isUpdateObject(updateObj)) {
                ReplaceOptions replaceOptions = new ReplaceOptions();
                replaceOptions.upsert(updateOptions.isUpsert());
                replaceOptions.collation(updateOptions.getCollation());
                return collectionToUse.replaceOne((Bson)queryObj, (Object)updateObj, replaceOptions);
            }
            if (multi) {
                return collectionToUse.updateMany((Bson)queryObj, (Bson)updateObj, updateOptions);
            }
            return collectionToUse.updateOne((Bson)queryObj, (Bson)updateObj, updateOptions);
        }).doOnNext(updateResult -> {
            if (entity != null && entity.hasVersionProperty() && !multi && updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
                Document updateObj;
                Document queryObj = query == null ? new Document() : this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
                Document document = updateObj = update == null ? new Document() : this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
                if (this.dbObjectContainsVersionProperty(queryObj, entity)) {
                    throw new OptimisticLockingFailureException("Optimistic lock exception on saving entity: " + updateObj.toString() + " to collection " + collectionName);
                }
            }
        });
        return result.next();
    }

    private void increaseVersionForUpdateIfNecessary(@Nullable MongoPersistentEntity<?> persistentEntity, Update update) {
        String versionFieldName;
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && !update.modifies(versionFieldName = ((MongoPersistentProperty)persistentEntity.getRequiredVersionProperty()).getFieldName())) {
            update.inc(versionFieldName, 1L);
        }
    }

    private boolean dbObjectContainsVersionProperty(Document document, @Nullable MongoPersistentEntity<?> persistentEntity) {
        if (persistentEntity == null || !persistentEntity.hasVersionProperty()) {
            return false;
        }
        return document.containsKey((Object)((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getFieldName());
    }

    @Override
    public Mono<DeleteResult> remove(Mono<? extends Object> objectToRemove) {
        return objectToRemove.flatMap(this::remove);
    }

    @Override
    public Mono<DeleteResult> remove(Mono<? extends Object> objectToRemove, String collectionName) {
        return objectToRemove.flatMap(it -> this.remove(it, collectionName));
    }

    @Override
    public Mono<DeleteResult> remove(Object object) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        return this.remove(this.getIdQueryFor(object), object.getClass());
    }

    @Override
    public Mono<DeleteResult> remove(Object object, String collectionName) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        return this.doRemove(collectionName, this.getIdQueryFor(object), object.getClass());
    }

    private Pair<String, Object> extractIdPropertyAndValue(Object object) {
        Assert.notNull((Object)object, (String)"Id cannot be extracted from 'null'.");
        Assert.notNull((Object)object, (String)"Id cannot be extracted from 'null'.");
        Class<?> objectType = object.getClass();
        if (object instanceof Document) {
            return Pair.of((Object)ID_FIELD, (Object)((Document)object).get((Object)ID_FIELD));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(objectType);
        if (entity != null && entity.hasIdProperty()) {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
            return Pair.of((Object)idProperty.getFieldName(), (Object)entity.getPropertyAccessor(object).getProperty((PersistentProperty)idProperty));
        }
        throw new MappingException("No id property found for object of type " + objectType);
    }

    private Query getIdQueryFor(Object object) {
        Pair<String, Object> id = this.extractIdPropertyAndValue(object);
        return new Query(Criteria.where((String)id.getFirst()).is(id.getSecond()));
    }

    private Query getIdInQueryFor(Collection<?> objects) {
        Assert.notEmpty(objects, (String)"Cannot create Query for empty collection.");
        Iterator<?> it = objects.iterator();
        Pair<String, Object> firstEntry = this.extractIdPropertyAndValue(it.next());
        ArrayList<Object> ids = new ArrayList<Object>(objects.size());
        ids.add(firstEntry.getSecond());
        while (it.hasNext()) {
            ids.add(this.extractIdPropertyAndValue(it.next()).getSecond());
        }
        return new Query(Criteria.where((String)firstEntry.getFirst()).in(ids));
    }

    private void assertUpdateableIdIfNotSet(Object value) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(value.getClass());
        if (entity != null && entity.hasIdProperty()) {
            MongoPersistentProperty property = (MongoPersistentProperty)entity.getRequiredIdProperty();
            Object propertyValue = entity.getPropertyAccessor(value).getProperty((PersistentProperty)property);
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", property.getType().getName(), value.getClass().getName()));
            }
        }
    }

    @Override
    public Mono<DeleteResult> remove(Query query, String collectionName) {
        return this.remove(query, null, collectionName);
    }

    @Override
    public Mono<DeleteResult> remove(Query query, Class<?> entityClass) {
        return this.remove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public Mono<DeleteResult> remove(Query query, @Nullable Class<?> entityClass, String collectionName) {
        return this.doRemove(collectionName, query, entityClass);
    }

    protected <T> Mono<DeleteResult> doRemove(String collectionName, Query query, @Nullable Class<T> entityClass) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to remove can't be null!");
        }
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Document queryObject = query.getQueryObject();
        MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            Document removeQuey = this.queryMapper.getMappedObject((Bson)queryObject, entity);
            this.maybeEmitEvent(new BeforeDeleteEvent(removeQuey, entityClass, collectionName));
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, removeQuey);
            DeleteOptions deleteOptions = new DeleteOptions();
            query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MongoCollection<Document> collectionToUse = this.prepareCollection((MongoCollection<Document>)collection, writeConcernToUse);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remove using query: {} in collection: {}.", new Object[]{SerializationUtils.serializeToJsonSafely(removeQuey), collectionName});
            }
            if (query.getLimit() > 0 || query.getSkip() > 0L) {
                FindPublisher cursor = new QueryFindPublisherPreparer(query, entityClass).prepare(collection.find((Bson)removeQuey)).projection((Bson)new Document(ID_FIELD, (Object)1));
                return Flux.from((Publisher)cursor).map(doc -> doc.get((Object)ID_FIELD)).collectList().flatMapMany(val -> collectionToUse.deleteMany((Bson)new Document(ID_FIELD, (Object)new Document("$in", val)), deleteOptions));
            }
            return collectionToUse.deleteMany((Bson)removeQuey, deleteOptions);
        }).doOnNext(deleteResult -> this.maybeEmitEvent(new AfterDeleteEvent(queryObject, entityClass, collectionName))).next();
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Override
    public <T> Flux<T> findAllAndRemove(Query query, String collectionName) {
        return this.findAllAndRemove(query, Object.class, collectionName);
    }

    @Override
    public <T> Flux<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return this.findAllAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndDelete(collectionName, query, entityClass);
    }

    @Override
    public <T> Flux<T> tail(Query query, Class<T> entityClass) {
        return this.tail(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> Flux<T> tail(@Nullable Query query, Class<T> entityClass, String collectionName) {
        if (query == null) {
            LOGGER.debug(String.format("find for class: %s in collection: %s", entityClass, collectionName));
            return this.executeFindMultiInternal(collection -> new FindCallback(null).doInCollection((MongoCollection<Document>)collection).cursorType(CursorType.TailableAwait), null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
        }
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, new TailingQueryFindPublisherPreparer(query, entityClass));
    }

    @Override
    public <T> Flux<ChangeStreamEvent<T>> changeStream(@Nullable Aggregation filter, Class<T> resultType, ChangeStreamOptions options, String collectionName) {
        Assert.notNull(resultType, (String)"Result type must not be null!");
        Assert.notNull((Object)options, (String)"ChangeStreamOptions must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        if (filter == null) {
            return this.changeStream(Collections.emptyList(), resultType, options, collectionName);
        }
        AggregationOperationContext context = filter instanceof TypedAggregation ? new TypeBasedAggregationOperationContext(((TypedAggregation)filter).getInputType(), this.mappingContext, this.queryMapper) : Aggregation.DEFAULT_CONTEXT;
        return this.changeStream(filter.toPipeline(new PrefixingDelegatingAggregationOperationContext(context, "fullDocument", Arrays.asList("operationType", "fullDocument", "documentKey", "updateDescription", "ns"))), resultType, options, collectionName);
    }

    @Override
    public <T> Flux<ChangeStreamEvent<T>> changeStream(List<Document> filter, Class<T> resultType, ChangeStreamOptions options, String collectionName) {
        Assert.notNull(filter, (String)"Filter must not be null!");
        Assert.notNull(resultType, (String)"Result type must not be null!");
        Assert.notNull((Object)options, (String)"ChangeStreamOptions must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        ChangeStreamPublisher publisher = filter.isEmpty() ? this.getCollection(collectionName).watch() : this.getCollection(collectionName).watch(filter);
        publisher = options.getResumeToken().map(BsonValue::asDocument).map(arg_0 -> ((ChangeStreamPublisher)publisher).resumeAfter(arg_0)).orElse(publisher);
        publisher = options.getCollation().map(Collation::toMongoCollation).map(arg_0 -> ((ChangeStreamPublisher)publisher).collation(arg_0)).orElse(publisher);
        if (options.getFullDocumentLookup().isPresent() || resultType != Document.class) {
            publisher = publisher.fullDocument(options.getFullDocumentLookup().isPresent() ? options.getFullDocumentLookup().get() : FullDocument.UPDATE_LOOKUP);
        }
        return Flux.from((Publisher)publisher).map(document -> new ChangeStreamEvent((ChangeStreamDocument<Document>)document, resultType, this.getConverter()));
    }

    @Override
    public <T> Flux<T> mapReduce(Query filterQuery, Class<?> domainType, Class<T> resultType, String mapFunction, String reduceFunction, MapReduceOptions options) {
        return this.mapReduce(filterQuery, domainType, this.determineCollectionName(domainType), resultType, mapFunction, reduceFunction, options);
    }

    @Override
    public <T> Flux<T> mapReduce(Query filterQuery, Class<?> domainType, String inputCollectionName, Class<T> resultType, String mapFunction, String reduceFunction, MapReduceOptions options) {
        Assert.notNull((Object)filterQuery, (String)"Filter query must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Assert.hasText((String)inputCollectionName, (String)"Input collection name must not be null or empty!");
        Assert.notNull(resultType, (String)"Result type must not be null!");
        Assert.notNull((Object)mapFunction, (String)"Map function must not be null!");
        Assert.notNull((Object)reduceFunction, (String)"Reduce function must not be null!");
        Assert.notNull((Object)options, (String)"MapReduceOptions must not be null!");
        ReactiveMongoTemplate.assertLocalFunctionNames(mapFunction, reduceFunction);
        return this.createFlux(inputCollectionName, collection -> {
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)filterQuery.getQueryObject(), (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainType));
            MapReducePublisher publisher = collection.mapReduce(mapFunction, reduceFunction, Document.class);
            if (StringUtils.hasText((String)options.getOutputCollection())) {
                publisher = publisher.collectionName(options.getOutputCollection());
            }
            publisher.filter((Bson)mappedQuery);
            publisher.sort((Bson)this.getMappedSortObject(filterQuery, domainType));
            if (filterQuery.getMeta().getMaxTimeMsec() != null) {
                publisher.maxTime(filterQuery.getMeta().getMaxTimeMsec().longValue(), TimeUnit.MILLISECONDS);
            }
            if (filterQuery.getLimit() > 0 || options.getLimit() != null) {
                if (filterQuery.getLimit() > 0 && options.getLimit() != null) {
                    throw new IllegalArgumentException("Both Query and MapReduceOptions define a limit. Please provide the limit only via one of the two.");
                }
                if (filterQuery.getLimit() > 0) {
                    publisher.limit(filterQuery.getLimit());
                }
                if (options.getLimit() != null) {
                    publisher.limit(options.getLimit().intValue());
                }
            }
            Optional<Collation> collation = filterQuery.getCollation();
            Optionals.ifAllPresent(filterQuery.getCollation(), options.getCollation(), (l, r) -> {
                throw new IllegalArgumentException("Both Query and MapReduceOptions define a collation. Please provide the collation only via one of the two.");
            });
            if (options.getCollation().isPresent()) {
                collation = options.getCollation();
            }
            if (!CollectionUtils.isEmpty(options.getScopeVariables())) {
                publisher = publisher.scope((Bson)new Document(options.getScopeVariables()));
            }
            if (options.getLimit() != null && options.getLimit() > 0) {
                publisher = publisher.limit(options.getLimit().intValue());
            }
            if (options.getFinalizeFunction().filter(StringUtils::hasText).isPresent()) {
                publisher = publisher.finalizeFunction(options.getFinalizeFunction().get());
            }
            if (options.getJavaScriptMode() != null) {
                publisher = publisher.jsMode(options.getJavaScriptMode().booleanValue());
            }
            if (options.getOutputSharded().isPresent()) {
                publisher = publisher.sharded(options.getOutputSharded().get().booleanValue());
            }
            publisher = collation.map(Collation::toMongoCollation).map(arg_0 -> ((MapReducePublisher)publisher).collation(arg_0)).orElse(publisher);
            return Flux.from((Publisher)publisher).map(new ReadDocumentCallback<Object>(this.mongoConverter, resultType, inputCollectionName)::doWith);
        });
    }

    private static void assertLocalFunctionNames(String ... functions) {
        for (String function : functions) {
            if (!ResourceUtils.isUrl((String)function)) continue;
            throw new IllegalArgumentException(String.format("Blocking accessing to resource %s is not allowed using reactive infrastructure. You may load the resource at startup and cache its value.", function));
        }
    }

    @Override
    public <T> ReactiveFindOperation.ReactiveFind<T> query(Class<T> domainType) {
        return new ReactiveFindOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ReactiveUpdateOperation.ReactiveUpdate<T> update(Class<T> domainType) {
        return new ReactiveUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public <T> ReactiveRemoveOperation.ReactiveRemove<T> remove(Class<T> domainType) {
        return new ReactiveRemoveOperationSupport(this).remove(domainType);
    }

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        return new ReactiveInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public <T> ReactiveAggregationOperation.ReactiveAggregation<T> aggregateAndReturn(Class<T> domainType) {
        return new ReactiveAggregationOperationSupport(this).aggregateAndReturn(domainType);
    }

    public <T> ReactiveMapReduceOperation.ReactiveMapReduce<T> mapReduce(Class<T> domainType) {
        return new ReactiveMapReduceOperationSupport(this).mapReduce((Class)domainType);
    }

    protected <T> Flux<T> doFindAndDelete(String collectionName, Query query, Class<T> entityClass) {
        Flux<T> flux = this.find(query, entityClass, collectionName);
        return Flux.from(flux).collectList().flatMapMany(list -> Flux.from(this.remove(this.getIdInQueryFor((Collection<?>)list), entityClass, collectionName)).flatMap(deleteResult -> Flux.fromIterable((Iterable)list)));
    }

    protected Mono<MongoCollection<Document>> doCreateCollection(String collectionName, CreateCollectionOptions collectionOptions) {
        return this.createMono(db -> db.createCollection(collectionName, collectionOptions)).map(success -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created collection [{}]", (Object)collectionName);
            }
            return this.getCollection(collectionName);
        });
    }

    protected <T> Mono<T> doFindOne(String collectionName, Document query, @Nullable Document fields, Class<T> entityClass, @Nullable Collation collation) {
        Document mappedFields;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        Document document = mappedFields = fields == null ? null : this.queryMapper.getMappedObject((Bson)fields, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("findOne using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), mappedFields, entityClass, collectionName));
        }
        return this.executeFindOneInternal(new FindOneCallback(mappedQuery, mappedFields, collation), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> Flux<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass) {
        return this.doFind(collectionName, query, fields, entityClass, null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <T> Flux<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass, FindPublisherPreparer preparer) {
        return this.doFind(collectionName, query, fields, entityClass, preparer, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <S, T> Flux<T> doFind(String collectionName, Document query, Document fields, Class<S> entityClass, @Nullable FindPublisherPreparer preparer, DocumentCallback<T> objectCallback) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Document mappedFields = this.queryMapper.getMappedFields(fields, entity);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("find using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, entityClass, collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields), preparer, objectCallback, collectionName);
    }

    <S, T> Flux<T> doFind(String collectionName, Document query, Document fields, Class<S> sourceClass, Class<T> targetClass, FindPublisherPreparer preparer) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(sourceClass);
        Document mappedFields = this.getMappedFieldsObject(fields, entity, targetClass);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find using query: {} fields: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, sourceClass, collectionName});
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields), preparer, new ProjectingReadCallback<S, T>(this.mongoConverter, sourceClass, targetClass, collectionName), collectionName);
    }

    private Document getMappedFieldsObject(Document fields, MongoPersistentEntity<?> entity, Class<?> targetType) {
        return this.queryMapper.getMappedFields(this.addFieldsForProjection(fields, entity.getType(), targetType), entity);
    }

    private Document addFieldsForProjection(Document fields, Class<?> domainType, Class<?> targetType) {
        if (!fields.isEmpty() || !targetType.isInterface() || ClassUtils.isAssignable(domainType, targetType)) {
            return fields;
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(targetType);
        if (projectionInformation.isClosed()) {
            projectionInformation.getInputProperties().forEach(it -> fields.append(it.getName(), (Object)1));
        }
        return fields;
    }

    protected CreateCollectionOptions convertToCreateCollectionOptions(@Nullable CollectionOptions collectionOptions) {
        return this.convertToCreateCollectionOptions(collectionOptions, Object.class);
    }

    protected CreateCollectionOptions convertToCreateCollectionOptions(@Nullable CollectionOptions collectionOptions, Class<?> entityType) {
        CreateCollectionOptions result = new CreateCollectionOptions();
        if (collectionOptions == null) {
            return result;
        }
        collectionOptions.getCapped().ifPresent(arg_0 -> ((CreateCollectionOptions)result).capped(arg_0));
        collectionOptions.getSize().ifPresent(arg_0 -> ((CreateCollectionOptions)result).sizeInBytes(arg_0));
        collectionOptions.getMaxDocuments().ifPresent(arg_0 -> ((CreateCollectionOptions)result).maxDocuments(arg_0));
        collectionOptions.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((CreateCollectionOptions)result).collation(arg_0));
        collectionOptions.getValidationOptions().ifPresent(it -> {
            ValidationOptions validationOptions = new ValidationOptions();
            it.getValidationAction().ifPresent(arg_0 -> ((ValidationOptions)validationOptions).validationAction(arg_0));
            it.getValidationLevel().ifPresent(arg_0 -> ((ValidationOptions)validationOptions).validationLevel(arg_0));
            it.getValidator().ifPresent(val -> validationOptions.validator((Bson)this.getMappedValidator((Validator)val, entityType)));
            result.validationOptions(validationOptions);
        });
        return result;
    }

    private Document getMappedValidator(Validator validator, Class<?> domainType) {
        Document validationRules = validator.toDocument();
        if (validationRules.containsKey((Object)"$jsonSchema")) {
            return this.schemaMapper.mapSchema(validationRules, domainType);
        }
        return this.queryMapper.getMappedObject((Bson)validationRules, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainType));
    }

    protected <T> Mono<T> doFindAndRemove(String collectionName, Document query, Document fields, Document sort, @Nullable Collation collation, Class<T> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("findAndRemove using query: %s fields: %s sort: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), fields, sort, entityClass, collectionName));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.executeFindOneInternal(new FindAndRemoveCallback(this.queryMapper.getMappedObject((Bson)query, entity), fields, sort, collation), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> Mono<T> doFindAndModify(String collectionName, Document query, Document fields, Document sort, Class<T> entityClass, Update update, FindAndModifyOptions options) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return Mono.defer(() -> {
            this.increaseVersionForUpdateIfNecessary(entity, update);
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
            Document mappedUpdate = this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("findAndModify using query: %s fields: %s sort: %s for class: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), fields, sort, entityClass, SerializationUtils.serializeToJsonSafely(mappedUpdate), collectionName));
            }
            return this.executeFindOneInternal(new FindAndModifyCallback(mappedQuery, fields, sort, mappedUpdate, options), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
        });
    }

    protected <T> void maybeEmitEvent(MongoMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private void populateIdIfNecessary(Object savedObject, @Nullable Object id) {
        if (id == null) {
            return;
        }
        if (savedObject instanceof Map) {
            Map map = (Map)savedObject;
            map.put(ID_FIELD, id);
            return;
        }
        MongoPersistentProperty idProp = this.getIdPropertyFor(savedObject.getClass());
        if (idProp == null) {
            return;
        }
        ConversionService conversionService = this.mongoConverter.getConversionService();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(savedObject.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(savedObject);
        if (accessor.getProperty((PersistentProperty)idProp) != null) {
            return;
        }
        new ConvertingPropertyAccessor(accessor, conversionService).setProperty((PersistentProperty)idProp, id);
    }

    private MongoCollection<Document> getAndPrepareCollection(MongoDatabase db, String collectionName) {
        try {
            MongoCollection collection = db.getCollection(collectionName, Document.class);
            return this.prepareCollection((MongoCollection<Document>)collection);
        }
        catch (RuntimeException e) {
            throw ReactiveMongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    protected void ensureNotIterable(Object o) {
        boolean isIterable = o.getClass().isArray();
        if (!isIterable) {
            for (Class<?> iterableClass : ITERABLE_CLASSES) {
                if (!iterableClass.isAssignableFrom(o.getClass()) && !o.getClass().getName().equals(iterableClass.getName())) continue;
                isIterable = true;
                break;
            }
        }
        if (isIterable) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected MongoCollection<Document> prepareCollection(MongoCollection<Document> collection) {
        if (this.readPreference != null) {
            return collection.withReadPreference(this.readPreference);
        }
        return collection;
    }

    protected MongoDatabase prepareDatabase(MongoDatabase database) {
        return database;
    }

    @Nullable
    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        WriteConcern wc = this.writeConcernResolver.resolve(mongoAction);
        return this.potentiallyForceAcknowledgedWrite(wc);
    }

    @Nullable
    private WriteConcern potentiallyForceAcknowledgedWrite(@Nullable WriteConcern wc) {
        if (ObjectUtils.nullSafeEquals((Object)((Object)WriteResultChecking.EXCEPTION), (Object)((Object)this.writeResultChecking)) && MongoClientVersion.isMongo3Driver() && (wc == null || wc.getWObject() == null || wc.getWObject() instanceof Number && ((Number)wc.getWObject()).intValue() < 1)) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return wc;
    }

    private <T> Mono<T> executeFindOneInternal(ReactiveCollectionCallback<Document> collectionCallback, DocumentCallback<T> objectCallback, String collectionName) {
        return this.createMono(collectionName, collection -> Mono.from(collectionCallback.doInCollection((MongoCollection<Document>)collection)).map(objectCallback::doWith));
    }

    private <T> Flux<T> executeFindMultiInternal(ReactiveCollectionQueryCallback<Document> collectionCallback, @Nullable FindPublisherPreparer preparer, DocumentCallback<T> objectCallback, String collectionName) {
        return this.createFlux(collectionName, collection -> {
            FindPublisher findPublisher = collectionCallback.doInCollection((MongoCollection<Document>)collection);
            if (preparer != null) {
                findPublisher = preparer.prepare(findPublisher);
            }
            return Flux.from(findPublisher).map(objectCallback::doWith);
        });
    }

    private <T> T execute(MongoDatabaseCallback<T> action) {
        Assert.notNull(action, (String)"MongoDatabaseCallback must not be null!");
        try {
            MongoDatabase db = this.doGetDatabase();
            return action.doInDatabase(db);
        }
        catch (RuntimeException e) {
            throw ReactiveMongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private Function<Throwable, Throwable> translateException() {
        return throwable -> {
            if (throwable instanceof RuntimeException) {
                return ReactiveMongoTemplate.potentiallyConvertRuntimeException((RuntimeException)throwable, this.exceptionTranslator);
            }
            return throwable;
        };
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    @Nullable
    private MongoPersistentEntity<?> getPersistentEntity(@Nullable Class<?> type) {
        return type == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
    }

    @Nullable
    private MongoPersistentProperty getIdPropertyFor(@Nullable Class<?> type) {
        if (type == null) {
            return null;
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        return persistentEntity != null ? (MongoPersistentProperty)persistentEntity.getIdProperty() : null;
    }

    private <T> String determineEntityCollectionName(@Nullable T obj) {
        if (null != obj) {
            return this.determineCollectionName(obj.getClass());
        }
        return null;
    }

    String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        return ((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass)).getCollection();
    }

    private static MappingMongoConverter getDefaultMongoConverter() {
        MongoCustomConversions conversions = new MongoCustomConversions(Collections.emptyList());
        MongoMappingContext context = new MongoMappingContext();
        context.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        context.afterPropertiesSet();
        MappingMongoConverter converter = new MappingMongoConverter(NO_OP_REF_RESOLVER, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)context);
        converter.setCustomConversions(conversions);
        converter.afterPropertiesSet();
        return converter;
    }

    private Document getMappedSortObject(Query query, Class<?> type) {
        if (query == null) {
            return null;
        }
        return this.queryMapper.getMappedSort(query.getSortObject(), (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type));
    }

    private <T> Document toDbObject(T objectToSave, MongoWriter<T> writer) {
        if (objectToSave instanceof Document) {
            return (Document)objectToSave;
        }
        if (!(objectToSave instanceof String)) {
            Document dbDoc = new Document();
            writer.write(objectToSave, dbDoc);
            if (dbDoc.containsKey((Object)ID_FIELD) && dbDoc.get((Object)ID_FIELD) == null) {
                dbDoc.remove((Object)ID_FIELD);
            }
            return dbDoc;
        }
        try {
            return Document.parse((String)((String)objectToSave));
        }
        catch (JSONParseException | JsonParseException e) {
            throw new MappingException("Could not parse given String to save into a JSON document!", e);
        }
    }

    private void initializeVersionProperty(Object entity) {
        MongoPersistentEntity<?> mongoPersistentEntity = this.getPersistentEntity(entity.getClass());
        if (mongoPersistentEntity != null && mongoPersistentEntity.hasVersionProperty()) {
            ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(mongoPersistentEntity.getPropertyAccessor(entity), this.mongoConverter.getConversionService());
            accessor.setProperty(mongoPersistentEntity.getRequiredVersionProperty(), (Object)0);
        }
    }

    private static FindOneAndDeleteOptions convertToFindOneAndDeleteOptions(Document fields, Document sort) {
        FindOneAndDeleteOptions result = new FindOneAndDeleteOptions();
        result = result.projection((Bson)fields).sort((Bson)sort);
        return result;
    }

    private static List<? extends Document> toDocuments(Collection<? extends Document> documents) {
        return new ArrayList<Document>(documents);
    }

    static {
        HashSet<Class> iterableClasses = new HashSet<Class>();
        iterableClasses.add(List.class);
        iterableClasses.add(Collection.class);
        iterableClasses.add(Iterator.class);
        iterableClasses.add(Publisher.class);
        ITERABLE_CLASSES = Collections.unmodifiableCollection(iterableClasses);
    }

    class IndexCreatorEventListener
    implements ApplicationListener<MappingContextEvent<?, ?>> {
        final Consumer<Throwable> subscriptionExceptionHandler;

        public void onApplicationEvent(MappingContextEvent<?, ?> event) {
            if (!event.wasEmittedBy(ReactiveMongoTemplate.this.mappingContext)) {
                return;
            }
            PersistentEntity entity = event.getPersistentEntity();
            if (entity instanceof MongoPersistentEntity) {
                ReactiveMongoTemplate.this.onCheckForIndexes((MongoPersistentEntity)entity, this.subscriptionExceptionHandler);
            }
        }

        public IndexCreatorEventListener(Consumer<Throwable> subscriptionExceptionHandler) {
            this.subscriptionExceptionHandler = subscriptionExceptionHandler;
        }
    }

    static class ReactiveSessionBoundMongoTemplate
    extends ReactiveMongoTemplate {
        private final ReactiveMongoTemplate delegate;

        ReactiveSessionBoundMongoTemplate(ClientSession session, ReactiveMongoTemplate that) {
            super(that.mongoDatabaseFactory.withSession(session), that);
            this.delegate = that;
        }

        @Override
        public MongoCollection<Document> getCollection(String collectionName) {
            return this.delegate.getCollection(collectionName);
        }

        @Override
        public MongoDatabase getMongoDatabase() {
            return this.delegate.getMongoDatabase();
        }
    }

    static class NoOpDbRefResolver
    implements DbRefResolver {
        NoOpDbRefResolver() {
        }

        @Override
        @Nullable
        public Object resolveDbRef(@Nonnull MongoPersistentProperty property, @Nonnull com.mongodb.DBRef dbref, @Nonnull DbRefResolverCallback callback, @Nonnull DbRefProxyHandler proxyHandler) {
            return null;
        }

        @Override
        @Nullable
        public com.mongodb.DBRef createDbRef(DBRef annotation, MongoPersistentEntity<?> entity, Object id) {
            return null;
        }

        @Override
        public Document fetch(com.mongodb.DBRef dbRef) {
            return null;
        }

        @Override
        public List<Document> bulkFetch(List<com.mongodb.DBRef> dbRefs) {
            return Collections.emptyList();
        }
    }

    class TailingQueryFindPublisherPreparer
    extends QueryFindPublisherPreparer {
        TailingQueryFindPublisherPreparer(Query query, Class<?> type) {
            super(query, type);
        }

        @Override
        public <T> FindPublisher<T> prepare(FindPublisher<T> findPublisher) {
            return super.prepare(findPublisher.cursorType(CursorType.TailableAwait));
        }
    }

    class QueryFindPublisherPreparer
    implements FindPublisherPreparer {
        @Nullable
        private final Query query;
        @Nullable
        private final Class<?> type;

        QueryFindPublisherPreparer(@Nullable Query query, Class<?> type) {
            this.query = query;
            this.type = type;
        }

        @Override
        public <T> FindPublisher<T> prepare(FindPublisher<T> findPublisher) {
            if (this.query == null) {
                return findPublisher;
            }
            FindPublisher findPublisherToUse = this.query.getCollation().map(Collation::toMongoCollation).map(arg_0 -> findPublisher.collation(arg_0)).orElse(findPublisher);
            if (this.query.getSkip() <= 0L && this.query.getLimit() <= 0 && ObjectUtils.isEmpty((Object)this.query.getSortObject()) && !StringUtils.hasText((String)this.query.getHint()) && !this.query.getMeta().hasValues()) {
                return findPublisherToUse;
            }
            try {
                if (this.query.getSkip() > 0L) {
                    findPublisherToUse = findPublisherToUse.skip((int)this.query.getSkip());
                }
                if (this.query.getLimit() > 0) {
                    findPublisherToUse = findPublisherToUse.limit(this.query.getLimit());
                }
                if (!ObjectUtils.isEmpty((Object)this.query.getSortObject())) {
                    Document sort = this.type != null ? ReactiveMongoTemplate.this.getMappedSortObject(this.query, this.type) : this.query.getSortObject();
                    findPublisherToUse = findPublisherToUse.sort((Bson)sort);
                }
                BasicDBObject modifiers = new BasicDBObject();
                if (StringUtils.hasText((String)this.query.getHint())) {
                    modifiers.append("$hint", (Object)this.query.getHint());
                }
                if (this.query.getMeta().hasValues()) {
                    for (Map.Entry<String, Object> entry : this.query.getMeta().values()) {
                        modifiers.append(entry.getKey(), entry.getValue());
                    }
                }
                if (!modifiers.isEmpty()) {
                    findPublisherToUse = findPublisherToUse.modifiers((Bson)modifiers);
                }
            }
            catch (RuntimeException e) {
                throw ReactiveMongoTemplate.potentiallyConvertRuntimeException(e, ReactiveMongoTemplate.this.exceptionTranslator);
            }
            return findPublisherToUse;
        }
    }

    static class GeoNearResultDbObjectCallback<T>
    implements DocumentCallback<GeoResult<T>> {
        private final DocumentCallback<T> delegate;
        private final Metric metric;

        GeoNearResultDbObjectCallback(DocumentCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate, (String)"DocumentCallback must not be null!");
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        public GeoResult<T> doWith(Document object) {
            double distance = (Double)object.get((Object)"dis");
            Document content = (Document)object.get((Object)"obj");
            T doWith = this.delegate.doWith(content);
            return new GeoResult(doWith, new Distance(distance, this.metric));
        }
    }

    private class ProjectingReadCallback<S, T>
    implements DocumentCallback<T> {
        @NonNull
        private final EntityReader<Object, Bson> reader;
        @NonNull
        private final Class<S> entityType;
        @NonNull
        private final Class<T> targetType;
        @NonNull
        private final String collectionName;

        @Override
        @Nullable
        public T doWith(@Nullable Document object) {
            Object result;
            Class<S> typeToRead;
            if (object == null) {
                return null;
            }
            Class<Object> clazz = typeToRead = this.targetType.isInterface() || this.targetType.isAssignableFrom(this.entityType) ? this.entityType : this.targetType;
            if (null != object) {
                ReactiveMongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<S>(object, typeToRead, this.collectionName));
            }
            Object source = this.reader.read(typeToRead, (Object)object);
            Object object2 = result = this.targetType.isInterface() ? ReactiveMongoTemplate.this.projectionFactory.createProjection(this.targetType, source) : source;
            if (null != source) {
                ReactiveMongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, result, this.collectionName));
            }
            return (T)result;
        }

        public ProjectingReadCallback(@NonNull EntityReader<Object, Bson> reader, @NonNull Class<S> entityType, @NonNull Class<T> targetType, String collectionName) {
            if (reader == null) {
                throw new IllegalArgumentException("reader is null");
            }
            if (entityType == null) {
                throw new IllegalArgumentException("entityType is null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is null");
            }
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName is null");
            }
            this.reader = reader;
            this.entityType = entityType;
            this.targetType = targetType;
            this.collectionName = collectionName;
        }
    }

    class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Bson> reader;
        private final Class<T> type;
        private final String collectionName;

        ReadDocumentCallback(EntityReader<? super T, Bson> reader, Class<T> type, String collectionName) {
            Assert.notNull(reader, (String)"EntityReader must not be null!");
            Assert.notNull(type, (String)"Entity type must not be null!");
            this.reader = reader;
            this.type = type;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(@Nullable Document object) {
            Object source;
            if (null != object) {
                ReactiveMongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(object, this.type, this.collectionName));
            }
            if (null != (source = this.reader.read(this.type, (Object)object))) {
                ReactiveMongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, source, this.collectionName));
            }
            return (T)source;
        }
    }

    static interface ReactiveCollectionQueryCallback<T>
    extends ReactiveCollectionCallback<T> {
        @Override
        public FindPublisher<T> doInCollection(MongoCollection<Document> var1) throws MongoException, DataAccessException;
    }

    static interface MongoDatabaseCallback<T> {
        public T doInDatabase(MongoDatabase var1);
    }

    static interface DocumentCallback<T> {
        public T doWith(Document var1);
    }

    private static class FindAndModifyCallback
    implements ReactiveCollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Document update;
        private final FindAndModifyOptions options;

        FindAndModifyCallback(Document query, Document fields, Document sort, Document update, FindAndModifyOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
        }

        @Override
        public Publisher<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            if (this.options.isRemove()) {
                FindOneAndDeleteOptions findOneAndDeleteOptions = ReactiveMongoTemplate.convertToFindOneAndDeleteOptions(this.fields, this.sort);
                findOneAndDeleteOptions = this.options.getCollation().map(Collation::toMongoCollation).map(arg_0 -> ((FindOneAndDeleteOptions)findOneAndDeleteOptions).collation(arg_0)).orElse(findOneAndDeleteOptions);
                return collection.findOneAndDelete((Bson)this.query, findOneAndDeleteOptions);
            }
            FindOneAndUpdateOptions findOneAndUpdateOptions = this.convertToFindOneAndUpdateOptions(this.options, this.fields, this.sort);
            return collection.findOneAndUpdate((Bson)this.query, (Bson)this.update, findOneAndUpdateOptions);
        }

        private FindOneAndUpdateOptions convertToFindOneAndUpdateOptions(FindAndModifyOptions options, Document fields, Document sort) {
            FindOneAndUpdateOptions result = new FindOneAndUpdateOptions();
            result = result.projection((Bson)fields).sort((Bson)sort).upsert(options.isUpsert());
            result = options.isReturnNew() ? result.returnDocument(ReturnDocument.AFTER) : result.returnDocument(ReturnDocument.BEFORE);
            result = options.getCollation().map(Collation::toMongoCollation).map(arg_0 -> ((FindOneAndUpdateOptions)result).collation(arg_0)).orElse(result);
            return result;
        }
    }

    private static class FindAndRemoveCallback
    implements ReactiveCollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Optional<Collation> collation;

        FindAndRemoveCallback(Document query, Document fields, Document sort, @Nullable Collation collation) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.collation = Optional.ofNullable(collation);
        }

        @Override
        public Publisher<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndDeleteOptions findOneAndDeleteOptions = ReactiveMongoTemplate.convertToFindOneAndDeleteOptions(this.fields, this.sort);
            this.collation.map(Collation::toMongoCollation).ifPresent(arg_0 -> ((FindOneAndDeleteOptions)findOneAndDeleteOptions).collation(arg_0));
            return collection.findOneAndDelete((Bson)this.query, findOneAndDeleteOptions);
        }
    }

    private static class FindCallback
    implements ReactiveCollectionQueryCallback<Document> {
        @Nullable
        private final Document query;
        @Nullable
        private final Document fields;

        FindCallback(@Nullable Document query) {
            this(query, null);
        }

        FindCallback(Document query, Document fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public FindPublisher<Document> doInCollection(MongoCollection<Document> collection) {
            FindPublisher findPublisher = ObjectUtils.isEmpty((Object)this.query) ? collection.find(Document.class) : collection.find((Bson)this.query, Document.class);
            if (ObjectUtils.isEmpty((Object)this.fields)) {
                return findPublisher;
            }
            return findPublisher.projection((Bson)this.fields);
        }
    }

    private static class FindOneCallback
    implements ReactiveCollectionCallback<Document> {
        private final Document query;
        private final Optional<Document> fields;
        private final Optional<Collation> collation;

        FindOneCallback(Document query, @Nullable Document fields, @Nullable Collation collation) {
            this.query = query;
            this.fields = Optional.ofNullable(fields);
            this.collation = Optional.ofNullable(collation);
        }

        @Override
        public Publisher<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindPublisher publisher = collection.find((Bson)this.query, Document.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("findOne using query: {} fields: {} in db.collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(this.query), SerializationUtils.serializeToJsonSafely(this.fields.orElseGet(Document::new)), collection.getNamespace().getFullName()});
            }
            if (this.fields.isPresent()) {
                publisher = publisher.projection((Bson)this.fields.get());
            }
            publisher = this.collation.map(Collation::toMongoCollation).map(arg_0 -> ((FindPublisher)publisher).collation(arg_0)).orElse(publisher);
            return publisher.limit(1).first();
        }
    }
}

