/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.ReactiveMongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveMongoRepository<T, ID extends Serializable>
implements ReactiveMongoRepository<T, ID> {
    @NonNull
    private final MongoEntityInformation<T, ID> entityInformation;
    @NonNull
    private final ReactiveMongoOperations mongoOperations;

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).limit(2);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName()).buffer(2).map(vals -> {
            if (vals.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return vals.iterator().next();
        }).next();
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        return this.mongoOperations.exists(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of Id's must not be null!");
        return this.findAll(new Query(new Criteria(this.entityInformation.getIdAttribute()).in((Collection)Streamable.of(ids).stream().collect(StreamUtils.toUnmodifiableList()))));
    }

    public Flux<T> findAllById(Publisher<ID> ids) {
        Assert.notNull(ids, (String)"The given Publisher of Id's must not be null!");
        return Flux.from(ids).buffer().flatMap(this::findAllById);
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.findAll(new Query().with(sort));
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).with(sort);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        return this.findAll(example, Sort.unsorted());
    }

    public Mono<Long> count() {
        return this.mongoOperations.count(new Query(), this.entityInformation.getCollectionName());
    }

    public <S extends T> Mono<Long> count(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        return this.mongoOperations.count(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<S> insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        List source = (List)Streamable.of(entities).stream().collect(StreamUtils.toUnmodifiableList());
        return source.isEmpty() ? Flux.empty() : Flux.from(this.mongoOperations.insertAll(source));
    }

    @Override
    public <S extends T> Flux<S> insert(Publisher<S> entities) {
        Assert.notNull(entities, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entities).flatMap(entity -> this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()));
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        }
        return this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        Streamable source = Streamable.of(entities);
        return source.stream().allMatch(arg_0 -> this.entityInformation.isNew(arg_0)) ? this.mongoOperations.insert((Collection)source.stream().collect(Collectors.toList()), this.entityInformation.getCollectionName()) : Flux.fromIterable(entities).flatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> this.entityInformation.isNew(entity) ? this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()).then(Mono.just((Object)entity)) : this.mongoOperations.save(entity, this.entityInformation.getCollectionName()).then(Mono.just((Object)entity)));
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"Id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName())).then();
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        Mono remove = this.mongoOperations.remove(entity, this.entityInformation.getCollectionName());
        if (this.entityInformation.isVersioned()) {
            remove = remove.handle((deleteResult, sink) -> {
                if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
                    sink.error((Throwable)new OptimisticLockingFailureException(String.format("The entity with id %s with version %s in %s cannot be deleted! Was it modified or deleted in the meantime?", this.entityInformation.getId(entity), this.entityInformation.getVersion(entity), this.entityInformation.getCollectionName())));
                } else {
                    sink.next(deleteResult);
                }
            });
        }
        return remove.then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll() {
        return this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName()).then(Mono.empty());
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    private Flux<T> findAll(Query query) {
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public SimpleReactiveMongoRepository(@NonNull MongoEntityInformation<T, ID> entityInformation, @NonNull ReactiveMongoOperations mongoOperations) {
        if (entityInformation == null) {
            throw new IllegalArgumentException("entityInformation is marked @NonNull but is null");
        }
        if (mongoOperations == null) {
            throw new IllegalArgumentException("mongoOperations is marked @NonNull but is null");
        }
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
    }
}

