/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.data.mongodb.gridfs.AsyncInputStreamAdapter;
import org.springframework.data.mongodb.gridfs.DataBufferPublisherAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class BinaryStreamAdapters {
    BinaryStreamAdapters() {
    }

    static Flux<DataBuffer> toPublisher(AsyncInputStream inputStream, DataBufferFactory dataBufferFactory) {
        return DataBufferPublisherAdapter.createBinaryStream(inputStream, dataBufferFactory).filter(it -> {
            if (it.readableByteCount() == 0) {
                DataBufferUtils.release((DataBuffer)it);
                return false;
            }
            return true;
        });
    }

    static Mono<AsyncInputStream> toAsyncInputStream(Publisher<? extends DataBuffer> dataBuffers) {
        return Mono.create(sink -> sink.success((Object)new AsyncInputStreamAdapter(dataBuffers, sink.currentContext())));
    }
}

