/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoCredentialPropertyEditor;
import org.springframework.data.mongodb.config.ReadPreferencePropertyEditor;
import org.springframework.data.mongodb.config.WriteConcernPropertyEditor;
import org.springframework.data.mongodb.core.MongoClientOptionsFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class MongoParsingUtils {
    private MongoParsingUtils() {
    }

    static void parseReplicaSet(Element element, BeanDefinitionBuilder mongoBuilder) {
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"replica-set", (String)"replicaSetSeeds");
    }

    public static boolean parseMongoClientOptions(Element element, BeanDefinitionBuilder mongoClientBuilder) {
        Element optionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"client-options");
        if (optionsElement == null) {
            return false;
        }
        BeanDefinitionBuilder clientOptionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientOptionsFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"description", (String)"description");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"min-connections-per-host", (String)"minConnectionsPerHost");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"connections-per-host", (String)"connectionsPerHost");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"threads-allowed-to-block-for-connection-multiplier", (String)"threadsAllowedToBlockForConnectionMultiplier");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"max-wait-time", (String)"maxWaitTime");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"max-connection-idle-time", (String)"maxConnectionIdleTime");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"max-connection-life-time", (String)"maxConnectionLifeTime");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"connect-timeout", (String)"connectTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"socket-timeout", (String)"socketTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"socket-keep-alive", (String)"socketKeepAlive");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"read-preference", (String)"readPreference");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"write-concern", (String)"writeConcern");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"heartbeat-frequency", (String)"heartbeatFrequency");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"min-heartbeat-frequency", (String)"minHeartbeatFrequency");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"heartbeat-connect-timeout", (String)"heartbeatConnectTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"heartbeat-socket-timeout", (String)"heartbeatSocketTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"ssl", (String)"ssl");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"ssl-socket-factory-ref", (String)"sslSocketFactory");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"encryption-settings-ref", (String)"autoEncryptionSettings");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)optionsElement, (String)"server-selection-timeout", (String)"serverSelectionTimeout");
        mongoClientBuilder.addPropertyValue("mongoClientOptions", (Object)clientOptionsDefBuilder.getBeanDefinition());
        return true;
    }

    static BeanDefinitionBuilder getWriteConcernPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.WriteConcern", WriteConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getServerAddressPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadPreferencePropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ReadPreference", ReadPreferencePropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getMongoCredentialPropertyEditor() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.MongoCredential[]", MongoCredentialPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }
}

