/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.DtoInstantiatingConverter;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;

interface ReactiveMongoQueryExecution {
    public Object execute(Query var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final ReactiveMongoOperations operations;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.operations.getConverter().getMappingContext(), this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull ReactiveMongoOperations operations, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new IllegalArgumentException("processor is marked non-null but is null");
            }
            if (operations == null) {
                throw new IllegalArgumentException("operations is marked non-null but is null");
            }
            if (instantiators == null) {
                throw new IllegalArgumentException("instantiators is marked non-null but is null");
            }
            this.processor = processor;
            this.operations = operations;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveMongoQueryExecution {
        @NonNull
        private final ReactiveMongoQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, collection));
        }

        public ResultProcessingExecution(@NonNull ReactiveMongoQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is marked non-null but is null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("converter is marked non-null but is null");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class DeleteExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoQueryMethod method;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collection);
            }
            return this.operations.remove(query, type, collection).map(deleteResult -> deleteResult.wasAcknowledged() ? deleteResult.getDeletedCount() : 0L);
        }

        public DeleteExecution(ReactiveMongoOperations operations, MongoQueryMethod method) {
            this.operations = operations;
            this.method = method;
        }
    }

    public static class GeoNearExecution
    implements ReactiveMongoQueryExecution {
        private final ReactiveMongoOperations operations;
        private final MongoParameterAccessor accessor;
        private final TypeInformation<?> returnType;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            Flux results = this.doExecuteQuery(query, type, collection);
            return this.isStreamOfGeoResult() ? results : results.map(GeoResult::getContent);
        }

        protected Flux<GeoResult<Object>> doExecuteQuery(@Nullable Query query, Class<?> type, String collection) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            nearQuery.with(pageable);
            return this.operations.geoNear(nearQuery, type, collection);
        }

        private boolean isStreamOfGeoResult() {
            if (!ReactiveWrappers.supports((Class)this.returnType.getType())) {
                return false;
            }
            TypeInformation componentType = this.returnType.getComponentType();
            return componentType != null && GeoResult.class.equals((Object)componentType.getType());
        }

        public GeoNearExecution(ReactiveMongoOperations operations, MongoParameterAccessor accessor, TypeInformation<?> returnType) {
            this.operations = operations;
            this.accessor = accessor;
            this.returnType = returnType;
        }
    }
}

