/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MappingMongoJsonSchemaCreator;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.NoOpDbRefResolver;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.util.Assert;

public interface MongoJsonSchemaCreator {
    public MongoJsonSchema createSchemaFor(Class<?> var1);

    public MongoJsonSchemaCreator filter(Predicate<JsonSchemaPropertyContext> var1);

    public static Predicate<JsonSchemaPropertyContext> encryptedOnly() {
        return new Predicate<JsonSchemaPropertyContext>(){
            private final Set<MongoPersistentProperty> seen = new HashSet<MongoPersistentProperty>();

            @Override
            public boolean test(JsonSchemaPropertyContext context) {
                return this.extracted(context.getProperty(), context);
            }

            private boolean extracted(MongoPersistentProperty property, JsonSchemaPropertyContext context) {
                if (property.isAnnotationPresent(Encrypted.class)) {
                    return true;
                }
                if (!property.isEntity() || this.seen.contains(property)) {
                    return false;
                }
                this.seen.add(property);
                Iterator iterator = context.resolveEntity(property).iterator();
                while (iterator.hasNext()) {
                    MongoPersistentProperty nested = (MongoPersistentProperty)iterator.next();
                    if (!this.extracted(nested, context)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static MongoJsonSchemaCreator create(MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoConverter, (String)"MongoConverter must not be null!");
        return new MappingMongoJsonSchemaCreator(mongoConverter);
    }

    public static MongoJsonSchemaCreator create(MappingContext mappingContext) {
        MappingMongoConverter converter = new MappingMongoConverter(NoOpDbRefResolver.INSTANCE, mappingContext);
        converter.setCustomConversions(MongoCustomConversions.create((MongoCustomConversions.MongoConverterConfigurationAdapter config) -> {}));
        converter.afterPropertiesSet();
        return MongoJsonSchemaCreator.create(converter);
    }

    public static MongoJsonSchemaCreator create() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(MongoSimpleTypes.HOLDER);
        mappingContext.afterPropertiesSet();
        MappingMongoConverter converter = new MappingMongoConverter(NoOpDbRefResolver.INSTANCE, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)mappingContext);
        converter.setCustomConversions(MongoCustomConversions.create((MongoCustomConversions.MongoConverterConfigurationAdapter config) -> {}));
        converter.afterPropertiesSet();
        return MongoJsonSchemaCreator.create(converter);
    }

    public static interface JsonSchemaPropertyContext {
        public String getPath();

        public MongoPersistentProperty getProperty();

        @Unwrapped.Nullable
        public <T> MongoPersistentEntity<T> resolveEntity(MongoPersistentProperty var1);
    }
}

