/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.bson.AbstractBsonWriter;
import org.bson.BSONObject;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonContextType;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.util.EmptyDocument;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BsonUtils {
    public static final Document EMPTY_DOCUMENT = new EmptyDocument();

    @Nullable
    public static <T> T get(Bson bson, String key) {
        return (T)BsonUtils.asMap(bson).get(key);
    }

    public static Map<String, Object> asMap(Bson bson) {
        return BsonUtils.asMap(bson, MongoClientSettings.getDefaultCodecRegistry());
    }

    public static Map<String, Object> asMap(@Nullable Bson bson, CodecRegistry codecRegistry) {
        if (bson == null) {
            return Collections.emptyMap();
        }
        if (bson instanceof Document) {
            Document document = (Document)bson;
            return document;
        }
        if (bson instanceof BasicDBObject) {
            BasicDBObject dbo = (BasicDBObject)bson;
            return dbo;
        }
        if (bson instanceof DBObject) {
            DBObject dbo = (DBObject)bson;
            return dbo.toMap();
        }
        return new Document((Map)bson.toBsonDocument(Document.class, codecRegistry));
    }

    public static Document asDocument(Bson bson) {
        return BsonUtils.asDocument(bson, MongoClientSettings.getDefaultCodecRegistry());
    }

    public static Document asDocument(Bson bson, CodecRegistry codecRegistry) {
        Map<String, Object> map = BsonUtils.asMap(bson, codecRegistry);
        if (map instanceof Document) {
            Document document = (Document)map;
            return document;
        }
        return new Document(map);
    }

    public static Document asMutableDocument(Bson bson) {
        if (bson instanceof EmptyDocument) {
            bson = new Document((Map)BsonUtils.asDocument(bson));
        }
        if (bson instanceof Document) {
            Document document = (Document)bson;
            return document;
        }
        Map<String, Object> map = BsonUtils.asMap(bson);
        if (map instanceof Document) {
            Document document = (Document)map;
            return document;
        }
        return new Document(map);
    }

    public static void addToMap(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            Document document = (Document)bson;
            document.put(key, value);
            return;
        }
        if (bson instanceof BSONObject) {
            BSONObject bsonObject = (BSONObject)bson;
            bsonObject.put(key, value);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add key/value pair to %s; as map given Bson must be a Document or BSONObject", bson.getClass()));
    }

    public static void addAllToMap(Bson target, Map<String, ?> source) {
        if (target instanceof Document) {
            Document document = (Document)target;
            document.putAll(source);
            return;
        }
        if (target instanceof BSONObject) {
            BSONObject bsonObject = (BSONObject)target;
            bsonObject.putAll(source);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot add all to %s; Given Bson must be a Document or BSONObject.", target.getClass()));
    }

    public static boolean contains(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            Document document = (Document)bson;
            return document.containsKey((Object)key) && ObjectUtils.nullSafeEquals((Object)document.get((Object)key), (Object)value);
        }
        if (bson instanceof BSONObject) {
            BSONObject bsonObject = (BSONObject)bson;
            return bsonObject.containsField(key) && ObjectUtils.nullSafeEquals((Object)bsonObject.get(key), (Object)value);
        }
        Map<String, Object> map = BsonUtils.asMap(bson);
        return map.containsKey(key) && ObjectUtils.nullSafeEquals((Object)map.get(key), (Object)value);
    }

    public static boolean removeNullId(Bson bson) {
        if (!BsonUtils.contains(bson, FieldName.ID.name(), null)) {
            return false;
        }
        BsonUtils.removeFrom(bson, FieldName.ID.name());
        return true;
    }

    static void removeFrom(Bson bson, String key) {
        if (bson instanceof Document) {
            Document document = (Document)bson;
            document.remove((Object)key);
            return;
        }
        if (bson instanceof BSONObject) {
            BSONObject bsonObject = (BSONObject)bson;
            bsonObject.removeField(key);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot remove from %s given Bson must be a Document or BSONObject.", bson.getClass()));
    }

    public static Object toJavaType(BsonValue value) {
        return switch (value.getBsonType()) {
            case BsonType.INT32 -> Integer.valueOf(value.asInt32().getValue());
            case BsonType.INT64 -> Long.valueOf(value.asInt64().getValue());
            case BsonType.STRING -> value.asString().getValue();
            case BsonType.DECIMAL128 -> Double.valueOf(value.asDecimal128().doubleValue());
            case BsonType.DOUBLE -> Double.valueOf(value.asDouble().getValue());
            case BsonType.BOOLEAN -> Boolean.valueOf(value.asBoolean().getValue());
            case BsonType.OBJECT_ID -> value.asObjectId().getValue();
            case BsonType.DB_POINTER -> new DBRef(value.asDBPointer().getNamespace(), (Object)value.asDBPointer().getId());
            case BsonType.BINARY -> (Object)value.asBinary().getData();
            case BsonType.DATE_TIME -> new Date(value.asDateTime().getValue());
            case BsonType.SYMBOL -> value.asSymbol().getSymbol();
            case BsonType.ARRAY -> value.asArray().toArray();
            case BsonType.DOCUMENT -> Document.parse((String)value.asDocument().toJson());
            default -> value;
        };
    }

    public static BsonValue simpleToBsonValue(Object source) {
        return BsonUtils.simpleToBsonValue(source, MongoClientSettings.getDefaultCodecRegistry());
    }

    public static BsonValue simpleToBsonValue(Object source, CodecRegistry codecRegistry) {
        if (source instanceof BsonValue) {
            BsonValue bsonValue = (BsonValue)source;
            return bsonValue;
        }
        if (source instanceof ObjectId) {
            ObjectId objectId = (ObjectId)source;
            return new BsonObjectId(objectId);
        }
        if (source instanceof String) {
            String stringValue = (String)source;
            return new BsonString(stringValue);
        }
        if (source instanceof Double) {
            Double doubleValue = (Double)source;
            return new BsonDouble(doubleValue.doubleValue());
        }
        if (source instanceof Integer) {
            Integer integerValue = (Integer)source;
            return new BsonInt32(integerValue.intValue());
        }
        if (source instanceof Long) {
            Long longValue = (Long)source;
            return new BsonInt64(longValue.longValue());
        }
        if (source instanceof byte[]) {
            byte[] byteArray = (byte[])source;
            return new BsonBinary(byteArray);
        }
        if (source instanceof Boolean) {
            Boolean booleanValue = (Boolean)source;
            return new BsonBoolean(booleanValue.booleanValue());
        }
        if (source instanceof Float) {
            Float floatValue = (Float)source;
            return new BsonDouble((double)floatValue.floatValue());
        }
        if (source instanceof Binary) {
            Binary binary = (Binary)source;
            return new BsonBinary(binary.getType(), binary.getData());
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            new BsonDateTime(date.getTime());
        }
        try {
            Object value = source;
            if (ClassUtils.isPrimitiveArray(source.getClass())) {
                value = CollectionUtils.arrayToList((Object)source);
            }
            Codec codec = codecRegistry.get(value.getClass());
            BsonCapturingWriter writer = new BsonCapturingWriter(value.getClass());
            codec.encode((BsonWriter)writer, value, (EncoderContext)(ObjectUtils.isArray((Object)value) || value instanceof Collection ? EncoderContext.builder().build() : null));
            return writer.getCapturedValue();
        }
        catch (CodecConfigurationException e) {
            throw new IllegalArgumentException(String.format("Unable to convert %s to BsonValue.", source != null ? source.getClass().getName() : "null"));
        }
    }

    public static Document merge(Document ... documents) {
        if (ObjectUtils.isEmpty((Object[])documents)) {
            return new Document();
        }
        if (documents.length == 1) {
            return documents[0];
        }
        Document target = new Document();
        Arrays.asList(documents).forEach(arg_0 -> ((Document)target).putAll(arg_0));
        return target;
    }

    public static Document toDocumentOrElse(String source, Function<String, Document> orElse) {
        if (source.stripLeading().startsWith("{")) {
            return Document.parse((String)source);
        }
        return orElse.apply(source);
    }

    @Nullable
    public static String toJson(@Nullable Document source) {
        if (source == null) {
            return null;
        }
        try {
            return source.toJson();
        }
        catch (Exception e) {
            return BsonUtils.toJson((Object)source);
        }
    }

    public static boolean isJsonDocument(@Nullable String value) {
        if (!StringUtils.hasText((String)value)) {
            return false;
        }
        String potentialJson = value.trim();
        return potentialJson.startsWith("{") && potentialJson.endsWith("}");
    }

    public static boolean isJsonArray(@Nullable String value) {
        return StringUtils.hasText((String)value) && value.startsWith("[") && value.endsWith("]");
    }

    public static Document parse(String json, @Nullable CodecRegistryProvider codecRegistryProvider) {
        Assert.notNull((Object)json, (String)"Json must not be null");
        if (codecRegistryProvider == null) {
            return Document.parse((String)json);
        }
        return Document.parse((String)json, (Decoder)((Decoder)codecRegistryProvider.getCodecFor(Document.class).orElseGet(() -> new DocumentCodec(codecRegistryProvider.getCodecRegistry()))));
    }

    @Nullable
    public static Object resolveValue(Bson bson, String key) {
        return BsonUtils.resolveValue(BsonUtils.asMap(bson), key);
    }

    public static Object resolveValue(Bson bson, FieldName fieldName) {
        return BsonUtils.resolveValue(BsonUtils.asMap(bson), fieldName);
    }

    @Nullable
    public static Object resolveValue(Map<String, Object> source, FieldName fieldName) {
        if (fieldName.isKey()) {
            return source.get(fieldName.name());
        }
        String[] parts = fieldName.parts();
        for (int i = 1; i < parts.length; ++i) {
            Object result = source.get(parts[i - 1]);
            if (!(result instanceof Bson)) {
                return null;
            }
            Bson resultBson = (Bson)result;
            source = BsonUtils.asMap(resultBson);
        }
        return source.get(parts[parts.length - 1]);
    }

    @Nullable
    public static Object resolveValue(Map<String, Object> source, String key) {
        if (source.containsKey(key)) {
            return source.get(key);
        }
        return BsonUtils.resolveValue(source, FieldName.path(key));
    }

    public static boolean hasValue(Bson bson, FieldName fieldName) {
        Map<String, Object> source = BsonUtils.asMap(bson);
        if (fieldName.isKey()) {
            return source.containsKey(fieldName.name());
        }
        String[] parts = fieldName.parts();
        for (int i = 1; i < parts.length; ++i) {
            Object result = source.get(parts[i - 1]);
            if ((source = BsonUtils.getAsMap(result)) != null) continue;
            return false;
        }
        return source.containsKey(parts[parts.length - 1]);
    }

    public static boolean hasValue(Bson bson, String key) {
        return BsonUtils.hasValue(bson, FieldName.path(key));
    }

    @Nullable
    private static Map<String, Object> getAsMap(Object source) {
        if (source instanceof Document) {
            Document document = (Document)source;
            return document;
        }
        if (source instanceof BasicDBObject) {
            BasicDBObject basicDBObject = (BasicDBObject)source;
            return basicDBObject;
        }
        if (source instanceof DBObject) {
            DBObject dbObject = (DBObject)source;
            return dbObject.toMap();
        }
        if (source instanceof Map) {
            return (Map)source;
        }
        return null;
    }

    public static Bson asBson(Object source) {
        if (source instanceof Document) {
            Document document = (Document)source;
            return document;
        }
        if (source instanceof BasicDBObject) {
            BasicDBObject basicDBObject = (BasicDBObject)source;
            return basicDBObject;
        }
        if (source instanceof DBObject) {
            DBObject dbObject = (DBObject)source;
            return new Document(dbObject.toMap());
        }
        if (source instanceof Map) {
            return new Document((Map)source);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to Bson", source));
    }

    public static boolean supportsBson(Object source) {
        return source instanceof DBObject || source instanceof Map;
    }

    public static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            return collection;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    @Nullable
    private static String toJson(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        try {
            String string;
            if (value instanceof Document) {
                Document document = (Document)value;
                string = document.toJson((Encoder)MongoClientSettings.getDefaultCodecRegistry().get(Document.class));
            } else {
                string = BsonUtils.serializeValue(value);
            }
            return string;
        }
        catch (Exception e) {
            JsonParseException jsonParseException;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return BsonUtils.toString(collection);
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return BsonUtils.toString(map);
            }
            if (ObjectUtils.isArray((Object)value)) {
                return BsonUtils.toString(Arrays.asList(ObjectUtils.toObjectArray((Object)value)));
            }
            throw e instanceof JsonParseException ? (jsonParseException = (JsonParseException)((Object)e)) : new JsonParseException((Throwable)e);
        }
    }

    private static String serializeValue(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        String documentJson = new Document("toBeEncoded", value).toJson();
        return documentJson.substring(documentJson.indexOf(58) + 1, documentJson.length() - 1).trim();
    }

    private static String toString(Map<?, ?> source) {
        return BsonUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", entry -> "\"" + entry.getKey() + "\" : " + BsonUtils.toJson(entry.getValue()));
    }

    private static String toString(Collection<?> source) {
        return BsonUtils.iterableToDelimitedString(source, "[ ", " ]", BsonUtils::toJson);
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String suffix, Converter<? super T, String> transformer) {
        StringJoiner joiner = new StringJoiner(", ", prefix, suffix);
        StreamSupport.stream(source.spliterator(), false).map(arg_0 -> transformer.convert(arg_0)).forEach(joiner::add);
        return joiner.toString();
    }

    static class BsonCapturingWriter
    extends AbstractBsonWriter {
        private final List<BsonValue> values = new ArrayList<BsonValue>(0);

        public BsonCapturingWriter(Class<?> type) {
            super(new BsonWriterSettings());
            if (ClassUtils.isAssignable(Map.class, type)) {
                this.setContext(new AbstractBsonWriter.Context((AbstractBsonWriter)this, null, BsonContextType.DOCUMENT));
            } else if (ClassUtils.isAssignable(List.class, type) || type.isArray()) {
                this.setContext(new AbstractBsonWriter.Context((AbstractBsonWriter)this, null, BsonContextType.ARRAY));
            } else {
                this.setContext(new AbstractBsonWriter.Context((AbstractBsonWriter)this, null, BsonContextType.DOCUMENT));
            }
        }

        @Nullable
        BsonValue getCapturedValue() {
            if (this.values.isEmpty()) {
                return null;
            }
            if (!this.getContext().getContextType().equals((Object)BsonContextType.ARRAY)) {
                return this.values.get(0);
            }
            return new BsonArray(this.values);
        }

        protected void doWriteStartDocument() {
        }

        protected void doWriteEndDocument() {
        }

        public void writeStartArray() {
            this.setState(AbstractBsonWriter.State.VALUE);
        }

        public void writeEndArray() {
            this.setState(AbstractBsonWriter.State.NAME);
        }

        protected void doWriteStartArray() {
        }

        protected void doWriteEndArray() {
        }

        protected void doWriteBinaryData(BsonBinary value) {
            this.values.add((BsonValue)value);
        }

        protected void doWriteBoolean(boolean value) {
            this.values.add((BsonValue)BsonBoolean.valueOf((boolean)value));
        }

        protected void doWriteDateTime(long value) {
            this.values.add((BsonValue)new BsonDateTime(value));
        }

        protected void doWriteDBPointer(BsonDbPointer value) {
            this.values.add((BsonValue)value);
        }

        protected void doWriteDouble(double value) {
            this.values.add((BsonValue)new BsonDouble(value));
        }

        protected void doWriteInt32(int value) {
            this.values.add((BsonValue)new BsonInt32(value));
        }

        protected void doWriteInt64(long value) {
            this.values.add((BsonValue)new BsonInt64(value));
        }

        protected void doWriteDecimal128(Decimal128 value) {
            this.values.add((BsonValue)new BsonDecimal128(value));
        }

        protected void doWriteJavaScript(String value) {
            this.values.add((BsonValue)new BsonJavaScript(value));
        }

        protected void doWriteJavaScriptWithScope(String value) {
            throw new UnsupportedOperationException("Cannot capture JavaScriptWith");
        }

        protected void doWriteMaxKey() {
        }

        protected void doWriteMinKey() {
        }

        protected void doWriteNull() {
            this.values.add((BsonValue)new BsonNull());
        }

        protected void doWriteObjectId(ObjectId value) {
            this.values.add((BsonValue)new BsonObjectId(value));
        }

        protected void doWriteRegularExpression(BsonRegularExpression value) {
            this.values.add((BsonValue)value);
        }

        protected void doWriteString(String value) {
            this.values.add((BsonValue)new BsonString(value));
        }

        protected void doWriteSymbol(String value) {
            this.values.add((BsonValue)new BsonSymbol(value));
        }

        protected void doWriteTimestamp(BsonTimestamp value) {
            this.values.add((BsonValue)value);
        }

        protected void doWriteUndefined() {
            this.values.add((BsonValue)new BsonUndefined());
        }

        public void flush() {
            this.values.clear();
        }
    }
}

