/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.aspects.Car;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Personality;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

@NodeEntity
public class Person
implements NodeBacked {
    public static final String NAME_INDEX = "name-index";
    @GraphId
    private Long graphId;
    @Indexed(indexName="name-index")
    @Size(min=3, max=20)
    private String name;
    @Indexed
    private String nickname;
    @Max(value=100L)
    @Min(value=0L)
    @Indexed
    private int age;
    private Short height;
    private transient String thought;
    private Personality personality;
    private Date birthdate;
    private Person spouse;
    private Car car;
    private DynamicProperties personalProperties;
    @GraphProperty(defaultValue="EXTROVERT")
    private Personality defaultedPersonality;
    @GraphProperty(defaultValue="defaultValue")
    private String defaultedName;
    @RelatedTo
    private Person mother;
    @RelatedTo(type="boss", direction=Direction.INCOMING)
    private Person boss;
    @RelatedToVia(type="knows", elementClass=Friendship.class)
    private Iterable<Friendship> friendships;
    @RelatedToVia
    private Set<Friendship> friendshipsSet;
    @Query(value="start person=node({self}) match (person)<-[:boss]-(boss) return boss")
    private Person bossByQuery;
    @Query(value="start person=node({self}) match (person)<-[:boss]-(boss) return boss.name")
    private String bossName;
    @Query(value="start person=node({self}) match (person)<-[:persons]-(team)-[:persons]->(member) return member", elementClass=Person.class)
    private Iterable<Person> otherTeamMembers;
    @Query(value="start person=node({self}) match (person)<-[:persons]-(team)-[:persons]->(member) return member.name, member.age")
    private Iterable<Map<String, Object>> otherTeamMemberData;
    @Transient
    public transient EntityState<Node> entityState;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;

    public Person(Node n) {
        Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
        Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)n);
    }

    public String getBossName() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)person);
        return (String)Person.bossName_aroundBody1$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Iterable<Person> getOtherTeamMembers() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)person);
        return (Iterable)Person.otherTeamMembers_aroundBody3$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Iterable<Map<String, Object>> getOtherTeamMemberData() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)person);
        return (Iterable)Person.otherTeamMemberData_aroundBody5$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Person getBossByQuery() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)person);
        return (Person)Person.bossByQuery_aroundBody7$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Person() {
        Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
        if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
            Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
        }
    }

    public Person(String name, int age) {
        Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
        if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
            Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
        }
        String string = name;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)person, (Object)string);
        Person.name_aroundBody9$advice(this, person, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        int n = age;
        Person person2 = this;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)person2, (Object)Conversions.intObject((int)n));
        Person.age_aroundBody11$advice(this, person2, n, joinPoint2, Neo4jNodeBacking.aspectOf(), this, Conversions.intObject((int)n), null, joinPoint2);
    }

    public String getName() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)person);
        return (String)Person.name_aroundBody13$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setName(String name) {
        String string = name;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)person, (Object)string);
        Person.name_aroundBody15$advice(this, person, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
    }

    public int getAge() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)person);
        return Conversions.intValue((Object)Person.age_aroundBody17$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint));
    }

    public void setAge(int age) {
        int n = age;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)person, (Object)Conversions.intObject((int)n));
        Person.age_aroundBody19$advice(this, person, n, joinPoint, Neo4jNodeBacking.aspectOf(), this, Conversions.intObject((int)n), null, joinPoint);
    }

    public Short getHeight() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)person);
        return (Short)Person.height_aroundBody21$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setHeight(Short height) {
        Short s = height;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)person, (Object)s);
        Person.height_aroundBody23$advice(this, person, s, joinPoint, Neo4jNodeBacking.aspectOf(), this, s, null, joinPoint);
    }

    public Person getSpouse() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)person);
        return (Person)Person.spouse_aroundBody25$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setSpouse(Person spouse) {
        Person person = spouse;
        Person person2 = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)person2, (Object)person);
        Person.spouse_aroundBody27$advice(this, person2, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, person, null, joinPoint);
    }

    public Person getMother() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)person);
        return (Person)Person.mother_aroundBody29$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setMother(Person mother) {
        Person person = mother;
        Person person2 = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)person2, (Object)person);
        Person.mother_aroundBody31$advice(this, person2, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, person, null, joinPoint);
    }

    public Person getBoss() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)person);
        return (Person)Person.boss_aroundBody33$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setBoss(Person boss) {
        Person person = boss;
        Person person2 = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)person2, (Object)person);
        Person.boss_aroundBody35$advice(this, person2, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, person, null, joinPoint);
    }

    public String toString() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)person);
        return (String)Person.name_aroundBody37$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Iterable<Friendship> getFriendships() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)person);
        return (Iterable)Person.friendships_aroundBody39$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setFriendships(Iterable<Friendship> f) {
        Iterable<Friendship> iterable = f;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)person, iterable);
        Person.friendships_aroundBody41$advice(this, person, iterable, joinPoint, Neo4jNodeBacking.aspectOf(), this, iterable, null, joinPoint);
    }

    public Friendship knows(Person p) {
        return (Friendship)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)p, Friendship.class, (String)"knows");
    }

    public void setPersonality(Personality personality) {
        Personality personality2 = personality;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)person, (Object)((Object)personality2));
        Person.personality_aroundBody43$advice(this, person, personality2, joinPoint, Neo4jNodeBacking.aspectOf(), this, (Object)personality2, null, joinPoint);
    }

    public Personality getPersonality() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)person);
        return (Personality)((Object)Person.personality_aroundBody45$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint));
    }

    public void setThought(String thought) {
        String string = thought;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)person, (Object)string);
        Person.thought_aroundBody47$advice(this, person, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
    }

    public String getThought() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)person);
        return (String)Person.thought_aroundBody49$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Date getBirthdate() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)person);
        return (Date)Person.birthdate_aroundBody51$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setBirthdate(Date birthdate) {
        Date date = birthdate;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)person, (Object)date);
        Person.birthdate_aroundBody53$advice(this, person, date, joinPoint, Neo4jNodeBacking.aspectOf(), this, date, null, joinPoint);
    }

    public long getId() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)person);
        return (Long)Person.graphId_aroundBody55$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setCar(Car car) {
        Car car2 = car;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)person, (Object)car2);
        Person.car_aroundBody57$advice(this, person, car2, joinPoint, Neo4jNodeBacking.aspectOf(), this, car2, null, joinPoint);
    }

    public Car getCar() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)person);
        return (Car)Person.car_aroundBody59$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setProperty(String key, Object value) {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)person);
        ((DynamicProperties)Person.personalProperties_aroundBody61$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint)).setProperty(key, value);
    }

    public Object getProperty(String key) {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)person);
        return ((DynamicProperties)Person.personalProperties_aroundBody63$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint)).getProperty(key);
    }

    public DynamicProperties getPersonalProperties() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)person);
        return (DynamicProperties)Person.personalProperties_aroundBody65$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public void setPersonalProperties(DynamicProperties personalProperties) {
        DynamicProperties dynamicProperties = personalProperties;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)person, (Object)dynamicProperties);
        Person.personalProperties_aroundBody67$advice(this, person, dynamicProperties, joinPoint, Neo4jNodeBacking.aspectOf(), this, dynamicProperties, null, joinPoint);
    }

    public void setNickname(String nickname) {
        String string = nickname;
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)person, (Object)string);
        Person.nickname_aroundBody69$advice(this, person, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
    }

    public static Person persistedPerson(String name, int age) {
        return (Person)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Person(name, age));
    }

    public Set<Friendship> getFriendshipsSet() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)person);
        return (Set)Person.friendshipsSet_aroundBody71$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public Personality getDefaultedPersonality() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)person);
        return (Personality)((Object)Person.defaultedPersonality_aroundBody73$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint));
    }

    public String getDefaultedName() {
        Person person = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)person);
        return (String)Person.defaultedName_aroundBody75$advice(this, person, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
    }

    public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
        return this.entityState;
    }

    public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
        this.entityState = entityState;
    }

    static {
        Person.ajc$preClinit();
    }

    private static final /* synthetic */ Object bossName_aroundBody1$advice(Person ajc$this, Person target, JoinPoint bossName, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.bossName;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.bossName;
    }

    private static final /* synthetic */ Object otherTeamMembers_aroundBody3$advice(Person ajc$this, Person target, JoinPoint otherTeamMembers, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.otherTeamMembers;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.otherTeamMembers;
    }

    private static final /* synthetic */ Object otherTeamMemberData_aroundBody5$advice(Person ajc$this, Person target, JoinPoint otherTeamMemberData, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.otherTeamMemberData;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.otherTeamMemberData;
    }

    private static final /* synthetic */ Object bossByQuery_aroundBody7$advice(Person ajc$this, Person target, JoinPoint bossByQuery, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.bossByQuery;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.bossByQuery;
    }

    private static final /* synthetic */ Object name_aroundBody9$advice(Person ajc$this, Person target, String name, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.name = (String)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.name = (String)object;
        return null;
    }

    private static final /* synthetic */ Object age_aroundBody11$advice(Person ajc$this, Person target, int age, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.age = Conversions.intValue((Object)object);
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.age = Conversions.intValue((Object)object);
        return null;
    }

    private static final /* synthetic */ Object name_aroundBody13$advice(Person ajc$this, Person target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.name;
    }

    private static final /* synthetic */ Object name_aroundBody15$advice(Person ajc$this, Person target, String name, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.name = (String)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.name = (String)object;
        return null;
    }

    private static final /* synthetic */ Object age_aroundBody17$advice(Person ajc$this, Person target, JoinPoint age, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return Conversions.intObject((int)target.age);
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return Conversions.intObject((int)target.age);
    }

    private static final /* synthetic */ Object age_aroundBody19$advice(Person ajc$this, Person target, int age, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.age = Conversions.intValue((Object)object);
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.age = Conversions.intValue((Object)object);
        return null;
    }

    private static final /* synthetic */ Object height_aroundBody21$advice(Person ajc$this, Person target, JoinPoint height, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.height;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.height;
    }

    private static final /* synthetic */ Object height_aroundBody23$advice(Person ajc$this, Person target, Short height, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.height = (Short)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.height = (Short)object;
        return null;
    }

    private static final /* synthetic */ Object spouse_aroundBody25$advice(Person ajc$this, Person target, JoinPoint spouse, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.spouse;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.spouse;
    }

    private static final /* synthetic */ Object spouse_aroundBody27$advice(Person ajc$this, Person target, Person spouse, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.spouse = (Person)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.spouse = (Person)object;
        return null;
    }

    private static final /* synthetic */ Object mother_aroundBody29$advice(Person ajc$this, Person target, JoinPoint mother, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.mother;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.mother;
    }

    private static final /* synthetic */ Object mother_aroundBody31$advice(Person ajc$this, Person target, Person mother, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.mother = (Person)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.mother = (Person)object;
        return null;
    }

    private static final /* synthetic */ Object boss_aroundBody33$advice(Person ajc$this, Person target, JoinPoint boss, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.boss;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.boss;
    }

    private static final /* synthetic */ Object boss_aroundBody35$advice(Person ajc$this, Person target, Person boss, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.boss = (Person)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.boss = (Person)object;
        return null;
    }

    private static final /* synthetic */ Object name_aroundBody37$advice(Person ajc$this, Person target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.name;
    }

    private static final /* synthetic */ Object friendships_aroundBody39$advice(Person ajc$this, Person target, JoinPoint friendships, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.friendships;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.friendships;
    }

    private static final /* synthetic */ Object friendships_aroundBody41$advice(Person ajc$this, Person target, Iterable friendships, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.friendships = (Iterable)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.friendships = (Iterable)object;
        return null;
    }

    private static final /* synthetic */ Object personality_aroundBody43$advice(Person ajc$this, Person target, Personality personality, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.personality = (Personality)((Object)object);
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.personality = (Personality)((Object)object);
        return null;
    }

    private static final /* synthetic */ Object personality_aroundBody45$advice(Person ajc$this, Person target, JoinPoint personality, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.personality;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.personality;
    }

    private static final /* synthetic */ Object thought_aroundBody47$advice(Person ajc$this, Person target, String thought, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.thought = (String)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.thought = (String)object;
        return null;
    }

    private static final /* synthetic */ Object thought_aroundBody49$advice(Person ajc$this, Person target, JoinPoint thought, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.thought;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.thought;
    }

    private static final /* synthetic */ Object birthdate_aroundBody51$advice(Person ajc$this, Person target, JoinPoint birthdate, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.birthdate;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.birthdate;
    }

    private static final /* synthetic */ Object birthdate_aroundBody53$advice(Person ajc$this, Person target, Date birthdate, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.birthdate = (Date)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.birthdate = (Date)object;
        return null;
    }

    private static final /* synthetic */ Object graphId_aroundBody55$advice(Person ajc$this, Person target, JoinPoint graphId, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.graphId;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.graphId;
    }

    private static final /* synthetic */ Object car_aroundBody57$advice(Person ajc$this, Person target, Car car, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.car = (Car)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.car = (Car)object;
        return null;
    }

    private static final /* synthetic */ Object car_aroundBody59$advice(Person ajc$this, Person target, JoinPoint car, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.car;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.car;
    }

    private static final /* synthetic */ Object personalProperties_aroundBody61$advice(Person ajc$this, Person target, JoinPoint personalProperties, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.personalProperties;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.personalProperties;
    }

    private static final /* synthetic */ Object personalProperties_aroundBody63$advice(Person ajc$this, Person target, JoinPoint personalProperties, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.personalProperties;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.personalProperties;
    }

    private static final /* synthetic */ Object personalProperties_aroundBody65$advice(Person ajc$this, Person target, JoinPoint personalProperties, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.personalProperties;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.personalProperties;
    }

    private static final /* synthetic */ Object personalProperties_aroundBody67$advice(Person ajc$this, Person target, DynamicProperties personalProperties, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.personalProperties = (DynamicProperties)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.personalProperties = (DynamicProperties)object;
        return null;
    }

    private static final /* synthetic */ Object nickname_aroundBody69$advice(Person ajc$this, Person target, String nickname, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = newVal;
            NodeBacked nodeBacked = entity;
            target.nickname = (String)object;
            return null;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        Object object = result;
        NodeBacked nodeBacked = entity;
        target.nickname = (String)object;
        return null;
    }

    private static final /* synthetic */ Object friendshipsSet_aroundBody71$advice(Person ajc$this, Person target, JoinPoint friendshipsSet, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.friendshipsSet;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.friendshipsSet;
    }

    private static final /* synthetic */ Object defaultedPersonality_aroundBody73$advice(Person ajc$this, Person target, JoinPoint defaultedPersonality, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.defaultedPersonality;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.defaultedPersonality;
    }

    private static final /* synthetic */ Object defaultedName_aroundBody75$advice(Person ajc$this, Person target, JoinPoint defaultedName, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.defaultedName;
        }
        Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
        if (result instanceof DoReturn) {
            return DoReturn.unwrap((Object)result);
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        NodeBacked nodeBacked = entity;
        return target.defaultedName;
    }

    public boolean equals(Object object) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
    }

    public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
    }

    public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
    }

    public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
    }

    public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
    }

    public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
        return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
    }

    public EntityState<Node> getEntityState() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
    }

    public Long getNodeId() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
    }

    public Node getPersistentState() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
    }

    public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
        return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
    }

    public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
    }

    public Neo4jTemplate getTemplate() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
    }

    public boolean hasPersistentState() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
    }

    public int hashCode() {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
    }

    public <T extends NodeBacked> T persist() {
        return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
    }

    public <T extends NodeBacked> T projectTo(Class<T> clazz) {
        return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
    }

    public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
        return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
    }

    public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
        return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
    }

    public Relationship relateTo(NodeBacked nodeBacked, String string) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
    }

    public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
        return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
    }

    public void remove() {
        Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
    }

    public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
        Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
    }

    public void setPersistentState(Node node) {
        Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Person.java", Person.class);
        ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "bossName", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 100);
        ajc$tjp_1 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "otherTeamMembers", "org.springframework.data.neo4j.aspects.Person", "java.lang.Iterable"), 104);
        ajc$tjp_10 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "height", "org.springframework.data.neo4j.aspects.Person", "java.lang.Short"), 140);
        ajc$tjp_11 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "height", "org.springframework.data.neo4j.aspects.Person", "java.lang.Short"), 144);
        ajc$tjp_12 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "spouse", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 149);
        ajc$tjp_13 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "spouse", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 153);
        ajc$tjp_14 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "mother", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 157);
        ajc$tjp_15 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "mother", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 161);
        ajc$tjp_16 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "boss", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 165);
        ajc$tjp_17 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "boss", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 169);
        ajc$tjp_18 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "name", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 174);
        ajc$tjp_19 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "friendships", "org.springframework.data.neo4j.aspects.Person", "java.lang.Iterable"), 178);
        ajc$tjp_2 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "otherTeamMemberData", "org.springframework.data.neo4j.aspects.Person", "java.lang.Iterable"), 108);
        ajc$tjp_20 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "friendships", "org.springframework.data.neo4j.aspects.Person", "java.lang.Iterable"), 182);
        ajc$tjp_21 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "personality", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Personality"), 190);
        ajc$tjp_22 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "personality", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Personality"), 194);
        ajc$tjp_23 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("82", "thought", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 198);
        ajc$tjp_24 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("82", "thought", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 202);
        ajc$tjp_25 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "birthdate", "org.springframework.data.neo4j.aspects.Person", "java.util.Date"), 206);
        ajc$tjp_26 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "birthdate", "org.springframework.data.neo4j.aspects.Person", "java.util.Date"), 210);
        ajc$tjp_27 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "graphId", "org.springframework.data.neo4j.aspects.Person", "java.lang.Long"), 214);
        ajc$tjp_28 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "car", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Car"), 218);
        ajc$tjp_29 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "car", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Car"), 222);
        ajc$tjp_3 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "bossByQuery", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Person"), 112);
        ajc$tjp_30 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "personalProperties", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.fieldaccess.DynamicProperties"), 226);
        ajc$tjp_31 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "personalProperties", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.fieldaccess.DynamicProperties"), 230);
        ajc$tjp_32 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "personalProperties", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.fieldaccess.DynamicProperties"), 234);
        ajc$tjp_33 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "personalProperties", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.fieldaccess.DynamicProperties"), 238);
        ajc$tjp_34 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "nickname", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 242);
        ajc$tjp_35 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "friendshipsSet", "org.springframework.data.neo4j.aspects.Person", "java.util.Set"), 250);
        ajc$tjp_36 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "defaultedPersonality", "org.springframework.data.neo4j.aspects.Person", "org.springframework.data.neo4j.aspects.Personality"), 254);
        ajc$tjp_37 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "defaultedName", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 258);
        ajc$tjp_4 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "name", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 119);
        ajc$tjp_5 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "age", "org.springframework.data.neo4j.aspects.Person", "int"), 120);
        ajc$tjp_6 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "name", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 124);
        ajc$tjp_7 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "name", "org.springframework.data.neo4j.aspects.Person", "java.lang.String"), 128);
        ajc$tjp_8 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("2", "age", "org.springframework.data.neo4j.aspects.Person", "int"), 132);
        ajc$tjp_9 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("2", "age", "org.springframework.data.neo4j.aspects.Person", "int"), 136);
    }
}

