/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.PersonRepository;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class DynamicPropertiesTests
extends EntityTestBase {
    @Autowired
    private Neo4jTemplate template;
    @Autowired
    private PersonRepository personRepository;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Override
    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.template);
    }

    @Test
    public void testCreateOutsideTransaction() {
        Person p = new Person("James", 35);
        p.setProperty("s", "String");
        p.setProperty("x", 100);
        p.setProperty("pi", 3.1415);
        this.persist(p);
        Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)p.getPersonalProperties().getPropertyKeys()));
        DynamicPropertiesTests.assertProperties((PropertyContainer)this.nodeFor(p));
        p.setProperty("s", "String two");
        this.persist(p);
        Assert.assertEquals((Object)"String two", (Object)this.nodeFor(p).getProperty("personalProperties-s"));
    }

    @Test
    public void testSetNullValue() {
        Person james = Person.persistedPerson("James", 35);
        james.setPersonalProperties(null);
        Assert.assertEquals((String)"empty properties after setting to null", (Object)true, (Object)james.getPersonalProperties().asMap().isEmpty());
    }

    Person createTestPerson() {
        Person p = Person.persistedPerson("James", 36);
        p.setProperty("s", "String");
        p.setProperty("x", 100);
        p.setProperty("pi", 3.1415);
        return this.persist(p);
    }

    @Test
    @Transactional
    public void testProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = this.createTestPerson();
                Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)p.getPersonalProperties().getPropertyKeys()));
                DynamicPropertiesTests.assertProperties((PropertyContainer)this.nodeFor(p));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testReload() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person p = this.createTestPerson();
                Person p2 = (Person)this.personRepository.findOne(p.getId());
                Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)p2.getPersonalProperties().getPropertyKeys()));
                Assert.assertEquals((Object)"String", (Object)p2.getPersonalProperties().getProperty("s"));
                Assert.assertEquals((Object)100, (Object)p2.getPersonalProperties().getProperty("x"));
                Assert.assertEquals((double)3.1415, (double)((Double)p2.getPersonalProperties().getProperty("pi")), (double)1.0E-9);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRemoveProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person p = this.createTestPerson();
                DynamicProperties props = p.getPersonalProperties();
                props.removeProperty("s");
                this.persist(p);
                Node node = this.nodeFor(p);
                Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)p.getPersonalProperties().getPropertyKeys()));
                Assert.assertFalse((boolean)node.hasProperty("personalProperties-s"));
                Assert.assertEquals((Object)100, (Object)node.getProperty("personalProperties-x"));
                Assert.assertEquals((double)3.1415, (double)((Double)node.getProperty("personalProperties-pi")), (double)1.0E-9);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFromMap() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Person p = Person.persistedPerson("James", 36);
                HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                propertyMap.put("s", "String");
                propertyMap.put("x", 100);
                propertyMap.put("pi", 3.1415);
                p.setPersonalProperties(p.getPersonalProperties().createFrom(propertyMap));
                this.persist(p);
                Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)p.getPersonalProperties().getPropertyKeys()));
                DynamicPropertiesTests.assertProperties((PropertyContainer)this.nodeFor(p));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testAsMap() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person p = this.createTestPerson();
                Map propertyMap = p.getPersonalProperties().asMap();
                Assert.assertEquals((long)3L, (long)propertyMap.size());
                Assert.assertEquals((Object)100, propertyMap.get("x"));
                Assert.assertEquals((double)3.1415, (double)((Double)propertyMap.get("pi")), (double)1.0E-9);
                Assert.assertEquals((Object)"String", propertyMap.get("s"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Person james = Person.persistedPerson("James", 36);
                Person john = Person.persistedPerson("John", 36);
                Friendship f = john.knows(james);
                DynamicProperties props = f.getPersonalProperties();
                props.setProperty("s", (Object)"String");
                props.setProperty("x", (Object)100);
                props.setProperty("pi", (Object)3.1415);
                Relationship rel = this.getNodeState(john).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"knows"), Direction.OUTGOING);
                DynamicPropertiesTests.assertProperties((PropertyContainer)rel, "Friendship.");
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipRemoveProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Person james = Person.persistedPerson("James", 36);
                Person john = Person.persistedPerson("John", 36);
                Friendship f = john.knows(james);
                DynamicProperties props = f.getPersonalProperties();
                props.setProperty("s", (Object)"String");
                props.setProperty("x", (Object)100);
                props.setProperty("pi", (Object)3.1415);
                Relationship rel = this.getNodeState(john).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"knows"), Direction.OUTGOING);
                DynamicPropertiesTests.assertProperties((PropertyContainer)rel, "Friendship.");
                this.persist(john);
                props.removeProperty("s");
                rel = this.getNodeState(john).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"knows"), Direction.OUTGOING);
                Assert.assertEquals((Object)100, (Object)rel.getProperty("Friendship.personalProperties-x"));
                Assert.assertEquals((double)3.1415, (double)((Double)rel.getProperty("Friendship.personalProperties-pi")), (double)1.0E-9);
                Assert.assertFalse((boolean)rel.hasProperty("Friendship.personalProperties-s"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private static void assertProperties(PropertyContainer container) {
        DynamicPropertiesTests.assertProperties(container, "");
    }

    private static void assertProperties(PropertyContainer container, String prefix) {
        Assert.assertEquals((Object)100, (Object)container.getProperty(String.valueOf(prefix) + "personalProperties-x"));
        Assert.assertEquals((double)3.1415, (double)((Double)container.getProperty(String.valueOf(prefix) + "personalProperties-pi")), (double)1.0E-9);
        Assert.assertEquals((Object)"String", (Object)container.getProperty(String.valueOf(prefix) + "personalProperties-s"));
    }

    private Node nodeFor(Person person) {
        return this.getNodeState(person);
    }

    static {
        DynamicPropertiesTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DynamicPropertiesTests.java", DynamicPropertiesTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testProperties", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testReload", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRemoveProperty", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFromMap", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 124);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testAsMap", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipProperties", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipRemoveProperty", "org.springframework.data.neo4j.aspects.support.DynamicPropertiesTests", "", "", "", "void"), 167);
    }
}

