/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/repository-namespace-config-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class GraphRepositoryTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    @Before
    public void setUp() throws Exception {
        this.testTeam.createSDGTeam();
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Iterable<Person> teamMembers = this.personRepository.findAllTeamMembers(this.testTeam.sdg);
                Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotationAndGremlin() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Iterable<Person> teamMembers = this.personRepository.findAllTeamMembersGremlin(this.testTeam.sdg);
                Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPersonWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person boss = this.personRepository.findBoss(this.testTeam.michael);
                Assert.assertThat((Object)boss, (Matcher)CoreMatchers.is((Object)this.testTeam.emil));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindIterableMapsWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Iterable<Map<String, Object>> teamMembers = this.personRepository.findAllTeamMemberData(this.testTeam.sdg);
                Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Map[]{this.testTeam.simpleRowFor(this.testTeam.michael, "member"), this.testTeam.simpleRowFor(this.testTeam.david, "member"), this.testTeam.simpleRowFor(this.testTeam.emil, "member")}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                PageRequest page = new PageRequest(0, 1, Sort.Direction.ASC, new String[]{"member.name"});
                Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, (Pageable)page);
                Assert.assertThat(teamMemberPage1, (Matcher)Matchers.hasItem((Object)this.testTeam.david));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPagedDescending() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                PageRequest page = new PageRequest(0, 2, Sort.Direction.DESC, new String[]{"member.name"});
                Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, (Pageable)page);
                Assert.assertEquals(Arrays.asList(this.testTeam.michael, this.testTeam.emil), (Object)IteratorUtil.asCollection(teamMemberPage1));
                Assert.assertThat((Object)teamMemberPage1.isFirstPage(), (Matcher)CoreMatchers.is((Object)true));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPagedNull() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Page<Person> teamMemberPage1 = this.personRepository.findAllTeamMembersPaged(this.testTeam.sdg, null);
                Assert.assertEquals(new HashSet<Person>(Arrays.asList(this.testTeam.david, this.testTeam.emil, this.testTeam.michael)), (Object)IteratorUtil.addToCollection(teamMemberPage1, new HashSet()));
                Assert.assertThat((Object)teamMemberPage1.isFirstPage(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)teamMemberPage1.isLastPage(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindSortedDescending() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Sort sort = new Sort(Sort.Direction.DESC, new String[]{"member.name"});
                Iterable<Person> teamMembers = this.personRepository.findAllTeamMembersSorted(this.testTeam.sdg, sort);
                Assert.assertEquals(Arrays.asList(this.testTeam.michael, this.testTeam.emil, this.testTeam.david), (Object)IteratorUtil.asCollection(teamMembers));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindSortedNull() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Iterable<Person> teamMembers = this.personRepository.findAllTeamMembersSorted(this.testTeam.sdg, null);
                Assert.assertThat(teamMembers, (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.emil, this.testTeam.david}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindByNamedQuery() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Group team = this.personRepository.findTeam(this.testTeam.michael);
                Assert.assertThat((Object)team, (Matcher)CoreMatchers.is((Object)this.testTeam.sdg));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        GraphRepositoryTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GraphRepositoryTests.java", GraphRepositoryTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindIterableOfPersonWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindIterableOfPersonWithQueryAnnotationAndGremlin", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPersonWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 71);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindIterableMapsWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 78);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPaged", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 85);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPagedDescending", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 92);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPagedNull", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 101);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindSortedDescending", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 110);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindSortedNull", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 118);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindByNamedQuery", "org.springframework.data.neo4j.aspects.support.GraphRepositoryTests", "", "", "", "void"), 125);
    }
}

