/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.NumericRangeQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.ValueContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.Personality;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
@Transactional
public class QueryEngineTests
extends EntityTestBase {
    @Autowired
    protected ConversionService conversionService;
    @Autowired
    private Neo4jTemplate template;
    private QueryEngine<Map<String, Object>> queryEngine;
    private Person michael;
    private EntityResultConverter entityResultConverter;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    @Before
    public void setUp() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                GraphDatabase graphDatabase = this.createGraphDatabase();
                graphDatabase.setConversionService(this.conversionService);
                this.entityResultConverter = new EntityResultConverter(this.conversionService).with(this.template);
                this.testTeam.createSDGTeam();
                this.queryEngine = graphDatabase.queryEngineFor(QueryType.Cypher);
                this.michael = this.testTeam.michael;
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        DelegatingGraphDatabase graphDatabase = new DelegatingGraphDatabase(this.template.getGraphDatabaseService());
        return graphDatabase;
    }

    @Test
    public void testQueryList() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Collection result = IteratorUtil.asCollection((Iterable)this.queryEngine.query("start person=node({people}) return person.name, person.age", MapUtil.map((Object[])new Object[]{"people", Arrays.asList(this.getNodeId(this.michael), this.getNodeId(this.testTeam.david))})));
                Assert.assertEquals(Arrays.asList(this.testTeam.simpleRowFor(this.michael, "person"), this.testTeam.simpleRowFor(this.testTeam.david, "person")), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryListOfTypeNode() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Result queryResult = this.queryEngine.query("start person=node:`name-index`(name={name}) match (person) <-[:boss]- (boss) return boss", this.michaelsName());
                Collection result = IteratorUtil.asCollection((Iterable)queryResult.to(Node.class));
                Assert.assertEquals(Arrays.asList(this.getNodeState(this.testTeam.emil)), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryListOfTypePerson() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Collection result = IteratorUtil.asCollection((Iterable)this.queryEngine.query("start person=node:`name-index`(name={name}) match (person) <-[:boss]- (boss) return boss", this.michaelsName()).to(Person.class, (ResultConverter)new EntityResultConverter(this.conversionService, this.template)));
                Assert.assertEquals(Arrays.asList(this.testTeam.emil), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private Map<String, Object> michaelsName() {
        return MapUtil.map((Object[])new Object[]{"name", this.michael.getName()});
    }

    @Test
    public void testQuerySingleOfTypePerson() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person result = (Person)this.queryEngine.query("start person=node:`name-index`(name={name}) match (person) <-[:boss]- (boss) return boss", this.michaelsName()).to(Person.class, (ResultConverter)new EntityResultConverter(this.conversionService, this.template)).single();
                Assert.assertEquals((Object)this.testTeam.emil, (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryNumericallyIndexedPropertiesWithNumericRangeQuery() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                NumericRangeQuery rangeQuery = NumericRangeQuery.newIntRange((String)"age", (Integer)this.michael.getAge(), (Integer)this.michael.getAge(), (boolean)true, (boolean)true);
                System.out.println("rangeQuery = " + rangeQuery.toString());
                Map result = (Map)this.queryEngine.query("start person=node:Person({age}) return person.name", MapUtil.map((Object[])new Object[]{"age", rangeQuery})).singleOrNull();
                Assert.assertNotNull((String)"result is null", (Object)result);
                Assert.assertEquals((String)"found correct person", (Object)this.michael.getName(), result.get("person.name"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Ignore(value="fix numeric queries in cypher")
    public void testQueryNumericallyIndexedPropertiesWithNumericRangeQueryString() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                String rangeQuery = String.format("age:[%d TO %d]", this.michael.getAge() - 1, this.michael.getAge() + 1);
                System.out.println("rangeQuery = " + rangeQuery);
                Map result = (Map)this.queryEngine.query("start person=node:Person({age}) return person.name", MapUtil.map((Object[])new Object[]{"age", rangeQuery})).singleOrNull();
                Assert.assertNotNull((String)"result is null", (Object)result);
                Assert.assertEquals((String)"found correct person", (Object)this.michael.getName(), result.get("person.name"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Ignore(value="fix numeric queries in cypher")
    public void testQueryNumericallyIndexedPropertiesWithValueContext() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Map result = (Map)this.queryEngine.query("start person=node:Person(age={age}) return person.name", MapUtil.map((Object[])new Object[]{"age", ValueContext.numeric((Number)this.michael.getAge())})).singleOrNull();
                Assert.assertNotNull((String)"result is null", (Object)result);
                Assert.assertEquals((String)"found correct person", (Object)this.michael.getName(), result.get("person.name"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Ignore(value="fix numeric queries in cypher")
    public void testQueryNumericallyIndexedProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Map result = (Map)this.queryEngine.query("start person=node:Person(age={age}) return person.name", MapUtil.map((Object[])new Object[]{"age", this.michael.getAge()})).singleOrNull();
                Assert.assertNotNull((String)"result is null", (Object)result);
                Assert.assertEquals((String)"found correct person", (Object)this.michael.getName(), result.get("person.name"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryListWithCustomConverter() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Collection result = IteratorUtil.asCollection((Iterable)this.queryEngine.query("start person=node:`name-index`(name={name}) match (person) <-[:boss]- (boss) return boss", this.michaelsName()).to(String.class, (ResultConverter)new ResultConverter.ResultConverterAdapter<Map<String, Object>, String>(){

                    public String convert(Map<String, Object> row, Class<String> target) {
                        return (String)((Node)row.get("boss")).getProperty("name");
                    }
                }));
                Assert.assertEquals(Arrays.asList("Emil"), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryForObjectAsString() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                String result = (String)this.queryEngine.query("start person=node:`name-index`(name={name}) match (person) <-[:persons]- (team) return team.name", this.michaelsName()).to(String.class).single();
                Assert.assertEquals((Object)this.testTeam.sdg.getName(), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryForObjectAsEnum() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Personality result = (Personality)((Object)this.queryEngine.query("start person=node:`name-index`(name={name}) return person.personality", this.michaelsName()).to(Personality.class).single());
                Assert.assertEquals((Object)((Object)this.michael.getPersonality()), (Object)((Object)result));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testQueryWithSpaceInParameter() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_12);
                this.michael.setName("Michael Hunger");
                this.personRepository.save(this.michael);
                Person result = (Person)this.queryEngine.query("start person=node:`name-index`({name}) return person", MapUtil.map((Object[])new Object[]{"name", "name:\"Michael Hunger\""})).to(Person.class, (ResultConverter)this.entityResultConverter).singleOrNull();
                Assert.assertEquals((Object)this.michael, (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        QueryEngineTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueryEngineTests.java", QueryEngineTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUp", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryList", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 88);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryForObjectAsString", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 213);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryForObjectAsEnum", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 220);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryWithSpaceInParameter", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 228);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryListOfTypeNode", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryListOfTypePerson", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 105);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQuerySingleOfTypePerson", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 117);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryNumericallyIndexedPropertiesWithNumericRangeQuery", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "", "void"), 125);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryNumericallyIndexedPropertiesWithNumericRangeQueryString", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "", "void"), 135);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryNumericallyIndexedPropertiesWithValueContext", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "", "void"), 146);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryNumericallyIndexedProperties", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "", "void"), 154);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryListWithCustomConverter", "org.springframework.data.neo4j.aspects.support.query.QueryEngineTests", "", "", "java.lang.Exception", "void"), 200);
    }
}

