/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.typerepresentation;

import java.util.Collection;
import javax.persistence.Transient;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.data.neo4j.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategy;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml", "classpath:org/springframework/data/neo4j/aspects/support/IndexingTypeRepresentationStrategyOverride-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class IndexingRelationshipTypeRepresentationStrategyTests
extends EntityTestBase {
    @Autowired
    private IndexingRelationshipTypeRepresentationStrategy relationshipTypeRepresentationStrategy;
    @Autowired
    EntityStateHandler entityStateHandler;
    @Autowired
    Neo4jTemplate neo4jTemplate;
    private Link link;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Override
    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((GraphDatabaseService)this.graphDatabaseService);
    }

    @Before
    public void setUp() throws Exception {
        if (this.link == null) {
            this.createThingsAndLinks();
        }
    }

    @Test
    @Transactional
    public void testPostEntityCreationOfRelationshipBacked() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                RelationshipIndex typesIndex = this.graphDatabaseService.index().forRelationships("__rel_types__");
                Object alias = this.neo4jTemplate.getEntityType(Link.class).getAlias();
                IndexHits linkHits = typesIndex.get("className", alias);
                Relationship rel = (Relationship)linkHits.getSingle();
                Assert.assertEquals((Object)this.rel(this.link), (Object)rel);
                Assert.assertEquals((Object)alias, (Object)rel.getProperty("__type__"));
                linkHits.close();
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testPreEntityRemovalOfRelationshipBacked() throws Exception {
        this.manualCleanDb();
        this.createThingsAndLinks();
        RelationshipIndex typesIndex = this.graphDatabaseService.index().forRelationships("__types__");
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            this.relationshipTypeRepresentationStrategy.preEntityRemoval((PropertyContainer)this.rel(this.link));
            tx.success();
        }
        finally {
            tx.finish();
        }
        IndexHits linkHits = typesIndex.get("className", (Object)this.link.getClass().getName());
        Assert.assertNull((Object)linkHits.getSingle());
        linkHits.close();
    }

    @Test
    @Transactional
    public void testFindAllOfRelationshipBacked() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Collection links = IteratorUtil.asCollection((Iterable)this.relationshipTypeRepresentationStrategy.findAll(this.typeOf(Link.class)));
                Assert.assertEquals((long)1L, (long)links.size());
                Assert.assertEquals((String)"Did not find all links.", (Object)this.neo4jTemplate.getPersistentState((Object)this.link), (Object)IteratorUtil.first((Iterable)links));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCountOfRelationshipBacked() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Assert.assertEquals((long)1L, (long)this.relationshipTypeRepresentationStrategy.count(this.typeOf(Link.class)));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetJavaTypeOfRelationshipBacked() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Assert.assertEquals((Object)this.typeOf(Link.class).getAlias(), (Object)this.relationshipTypeRepresentationStrategy.readAliasFrom((PropertyContainer)this.rel(this.link)));
                Assert.assertEquals(Link.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.link));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndInferType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Link newLink = (Link)this.neo4jTemplate.createEntityFromStoredType((PropertyContainer)this.rel(this.link), this.neo4jTemplate.getMappingPolicy((Object)this.link));
                Assert.assertEquals((Object)this.link, (Object)newLink);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndSpecifyType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Link newLink = (Link)this.neo4jTemplate.createEntityFromState((PropertyContainer)this.rel(this.link), Link.class, this.neo4jTemplate.getMappingPolicy((Object)this.link));
                Assert.assertEquals((Object)this.link, (Object)newLink);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testProjectEntity() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                UnrelatedLink other = (UnrelatedLink)this.neo4jTemplate.projectTo((Object)this.rel(this.link), UnrelatedLink.class);
                Assert.assertEquals((Object)"link", (Object)other.getLabel());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private Relationship rel(Link link) {
        return this.getRelationshipState(link);
    }

    private void createThingsAndLinks() {
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            Node n1 = this.graphDatabaseService.createNode();
            Node n2 = this.graphDatabaseService.createNode();
            Relationship rel = n1.createRelationshipTo(n2, (RelationshipType)DynamicRelationshipType.withName((String)"link"));
            this.link = new Link();
            this.neo4jTemplate.setPersistentState((Object)this.link, (PropertyContainer)rel);
            this.relationshipTypeRepresentationStrategy.writeTypeTo((PropertyContainer)rel, this.neo4jTemplate.getEntityType(Link.class));
            this.link.setLabel("link");
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    static {
        IndexingRelationshipTypeRepresentationStrategyTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IndexingRelationshipTypeRepresentationStrategyTests.java", IndexingRelationshipTypeRepresentationStrategyTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testPostEntityCreationOfRelationshipBacked", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllOfRelationshipBacked", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 114);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCountOfRelationshipBacked", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 122);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetJavaTypeOfRelationshipBacked", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 128);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndInferType", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 135);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndSpecifyType", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 142);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testProjectEntity", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 149);
    }

    @RelationshipEntity
    public static class Link
    implements RelationshipBacked {
        String label;
        @Transient
        public transient EntityState<Relationship> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public Link() {
            Neo4jRelationshipBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)this);
            if (!Neo4jRelationshipBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jRelationshipBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$1$a152bd2f((RelationshipBacked)this);
            }
        }

        public String getLabel() {
            Link link = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)link);
            return (String)Link.label_aroundBody1$advice(this, link, joinPoint, Neo4jRelationshipBacking.aspectOf(), this, null, joinPoint);
        }

        public void setLabel(String label) {
            String string = label;
            Link link = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)link, (Object)string);
            Link.label_aroundBody3$advice(this, link, string, joinPoint, Neo4jRelationshipBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            Link.ajc$preClinit();
        }

        private static final /* synthetic */ Object label_aroundBody1$advice(Link ajc$this, Link target, JoinPoint label, Neo4jRelationshipBacking ajc$aspectInstance, RelationshipBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                RelationshipBacked relationshipBacked = entity;
                return target.label;
            }
            Object result = Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity).getValue(Neo4jRelationshipBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$field((Neo4jRelationshipBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            RelationshipBacked relationshipBacked = entity;
            return target.label;
        }

        private static final /* synthetic */ Object label_aroundBody3$advice(Link ajc$this, Link target, String label, JoinPoint thisJoinPoint, Neo4jRelationshipBacking ajc$aspectInstance, RelationshipBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                RelationshipBacked relationshipBacked = entity;
                target.label = (String)object;
                return null;
            }
            Object result = Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity).setValue(Neo4jRelationshipBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$field((Neo4jRelationshipBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            RelationshipBacked relationshipBacked = entity;
            target.label = (String)object;
            return null;
        }

        public final boolean equals(Object object) {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$equals((RelationshipBacked)this, (Object)object);
        }

        public EntityState<Relationship> getEntityState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getEntityState((RelationshipBacked)this);
        }

        public Relationship getPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getPersistentState((RelationshipBacked)this);
        }

        public Long getRelationshipId() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getRelationshipId((RelationshipBacked)this);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getTemplate((RelationshipBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hasPersistentState((RelationshipBacked)this);
        }

        public final int hashCode() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hashCode((RelationshipBacked)this);
        }

        public <T extends RelationshipBacked> T persist() {
            return (T)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$persist((RelationshipBacked)this);
        }

        public <R extends RelationshipBacked> R projectTo(Class<R> clazz) {
            return (R)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$projectTo((RelationshipBacked)this, clazz);
        }

        public void remove() {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$remove((RelationshipBacked)this);
        }

        public void setPersistentState(Relationship relationship) {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$setPersistentState((RelationshipBacked)this, (Relationship)relationship);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexingRelationshipTypeRepresentationStrategyTests.java", Link.class);
            ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "label", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests$Link", "java.lang.String"), 191);
            ajc$tjp_1 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "label", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests$Link", "java.lang.String"), 195);
        }
    }

    public static class SubLink
    extends Link {
        public SubLink() {
            if (!Neo4jRelationshipBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jRelationshipBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$1$a152bd2f((RelationshipBacked)this);
            }
        }
    }

    @RelationshipEntity
    public static class UnrelatedLink
    implements RelationshipBacked {
        String label;
        @Transient
        public transient EntityState<Relationship> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public UnrelatedLink() {
            Neo4jRelationshipBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)this);
            if (!Neo4jRelationshipBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jRelationshipBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$1$a152bd2f((RelationshipBacked)this);
            }
        }

        public String getLabel() {
            UnrelatedLink unrelatedLink = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)unrelatedLink);
            return (String)UnrelatedLink.label_aroundBody1$advice(this, unrelatedLink, joinPoint, Neo4jRelationshipBacking.aspectOf(), this, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            UnrelatedLink.ajc$preClinit();
        }

        private static final /* synthetic */ Object label_aroundBody1$advice(UnrelatedLink ajc$this, UnrelatedLink target, JoinPoint label, Neo4jRelationshipBacking ajc$aspectInstance, RelationshipBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                RelationshipBacked relationshipBacked = entity;
                return target.label;
            }
            Object result = Neo4jRelationshipBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)entity).getValue(Neo4jRelationshipBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$field((Neo4jRelationshipBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            RelationshipBacked relationshipBacked = entity;
            return target.label;
        }

        public final boolean equals(Object object) {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$equals((RelationshipBacked)this, (Object)object);
        }

        public EntityState<Relationship> getEntityState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getEntityState((RelationshipBacked)this);
        }

        public Relationship getPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getPersistentState((RelationshipBacked)this);
        }

        public Long getRelationshipId() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getRelationshipId((RelationshipBacked)this);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getTemplate((RelationshipBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hasPersistentState((RelationshipBacked)this);
        }

        public final int hashCode() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hashCode((RelationshipBacked)this);
        }

        public <T extends RelationshipBacked> T persist() {
            return (T)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$persist((RelationshipBacked)this);
        }

        public <R extends RelationshipBacked> R projectTo(Class<R> clazz) {
            return (R)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$projectTo((RelationshipBacked)this, clazz);
        }

        public void remove() {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$remove((RelationshipBacked)this);
        }

        public void setPersistentState(Relationship relationship) {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$setPersistentState((RelationshipBacked)this, (Relationship)relationship);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexingRelationshipTypeRepresentationStrategyTests.java", UnrelatedLink.class);
            ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "label", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategyTests$UnrelatedLink", "java.lang.String"), 179);
        }
    }
}

