/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.HasRelationshipMatcher;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class ModificationOutsideOfTransactionTests
extends EntityTestBase {
    @Before
    public void cleanUp() {
        this.manualCleanDb();
    }

    @Test
    public void testCreateOutsideTransaction() {
        Person p = new Person("Michael", 35);
        Assert.assertEquals((long)35L, (long)p.getAge());
        p.setAge(36);
        Assert.assertEquals((long)36L, (long)p.getAge());
        Assert.assertFalse((boolean)this.hasPersistentState(p));
        this.persist(p);
        Assert.assertEquals((Object)36, (Object)this.nodeFor(p).getProperty("age"));
    }

    @Test
    public void testCreateSubgraphOutsideOfTransactionPersistInDirectionOfRel() {
        Person michael = new Person("Michael", 35);
        Person emil = new Person("Emil", 31);
        michael.setBoss(emil);
        Assert.assertEquals((Object)emil, (Object)michael.getBoss());
        Assert.assertFalse((boolean)this.hasPersistentState(michael));
        Assert.assertFalse((boolean)this.hasPersistentState(emil));
        this.persist(michael);
        Assert.assertThat((Object)this.nodeFor(michael), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(emil)));
        Assert.assertThat((Object)this.nodeFor(emil), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(michael)));
    }

    @Test
    public void testCreateSubgraphOutsideOfTransactionPersistWithImmediateCycle() {
        Person michael = new Person("Michael", 35);
        Person emil = new Person("Emil", 31);
        michael.setBoss(emil);
        emil.setBoss(michael);
        Assert.assertEquals((Object)emil, (Object)michael.getBoss());
        Assert.assertEquals((Object)michael, (Object)emil.getBoss());
        Assert.assertFalse((boolean)this.hasPersistentState(michael));
        Assert.assertFalse((boolean)this.hasPersistentState(emil));
        this.persist(michael);
        Assert.assertThat((Object)this.nodeFor(michael), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(emil)));
        Assert.assertThat((Object)this.nodeFor(emil), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(michael)));
    }

    @Test
    public void testCreateSubgraphOutsideOfTransactionPersistWithCycle() {
        Person michael = new Person("Michael", 35);
        Person david = new Person("David", 27);
        Person emil = new Person("Emil", 31);
        michael.setBoss(emil);
        david.setBoss(michael);
        emil.setBoss(david);
        Assert.assertEquals((Object)emil, (Object)michael.getBoss());
        Assert.assertEquals((Object)michael, (Object)david.getBoss());
        Assert.assertEquals((Object)david, (Object)emil.getBoss());
        Assert.assertFalse((boolean)this.hasPersistentState(michael));
        Assert.assertFalse((boolean)this.hasPersistentState(david));
        Assert.assertFalse((boolean)this.hasPersistentState(emil));
        this.persist(michael);
        Assert.assertThat((Object)this.nodeFor(michael), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(emil)));
        Assert.assertThat((Object)this.nodeFor(michael), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(david)));
        Assert.assertThat((Object)this.nodeFor(david), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(michael)));
        Assert.assertThat((Object)this.nodeFor(david), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(emil)));
        Assert.assertThat((Object)this.nodeFor(emil), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(david)));
        Assert.assertThat((Object)this.nodeFor(emil), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(michael)));
    }

    @Ignore(value="ignored until subgraph persisting is added")
    @Test
    public void testCreateSubgraphOutsideOfTransactionPersistInReverseDirectionOfRel() {
        Person michael = new Person("Michael", 35);
        Person emil = new Person("Emil", 31);
        michael.setBoss(emil);
        Assert.assertEquals((Object)emil, (Object)michael.getBoss());
        Assert.assertFalse((boolean)this.hasPersistentState(michael));
        Assert.assertFalse((boolean)this.hasPersistentState(emil));
        this.persist(emil);
        Assert.assertThat((Object)this.nodeFor(michael), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(emil)));
        Assert.assertThat((Object)this.nodeFor(emil), (Matcher)HasRelationshipMatcher.hasRelationship("boss", this.nodeFor(michael)));
    }

    @Test(expected=NotInTransactionException.class)
    public void foo() {
        Person p = Person.persistedPerson("Michael", 35);
        Person p2 = Person.persistedPerson("David", 26);
        p.knows(p2);
    }

    @Test
    public void testSetPropertyOutsideTransaction() {
        Person p = Person.persistedPerson("Michael", 35);
        p.setAge(25);
        Assert.assertEquals((long)25L, (long)p.getAge());
        Assert.assertEquals((Object)35, (Object)this.nodeFor(p).getProperty("age"));
    }

    @Test
    public void shouldWorkWithUninitializedCollectionFieldWithoutUnderlyingState() {
        Group group = new Group();
        Collection<Person> people = group.getPersons();
        Assert.assertNotNull(people);
        Person p = new Person("David", 27);
        people.add(p);
        Assert.assertEquals(Collections.singleton(p), group.getPersons());
        this.persist(group);
        Assert.assertThat((Object)this.getNodeState(group), (Matcher)HasRelationshipMatcher.hasRelationship("persons", this.getNodeState(p)));
        Assert.assertThat((Object)this.getNodeState(p), (Matcher)HasRelationshipMatcher.hasRelationship("persons", this.getNodeState(group)));
    }

    @Test
    public void shouldWorkWithInitializedCollectionFieldWithoutUnderlyingState() {
        Group group = new Group();
        group.setPersons(new HashSet<Person>());
        Collection<Person> people = group.getPersons();
        Assert.assertNotNull(people);
        Person p = new Person("David", 27);
        people.add(p);
        Assert.assertEquals(Collections.singleton(p), group.getPersons());
        this.persist(group);
        Assert.assertThat((Object)this.getNodeState(group), (Matcher)HasRelationshipMatcher.hasRelationship("persons", this.getNodeState(p)));
        Assert.assertThat((Object)this.getNodeState(p), (Matcher)HasRelationshipMatcher.hasRelationship("persons", this.getNodeState(group)));
    }

    @Test
    public void shouldNotCreateGraphRelationshipOutsideTransaction() {
        Person p = Person.persistedPerson("Michael", 35);
        Person spouse = Person.persistedPerson("Tina", 36);
        p.setSpouse(spouse);
        Assert.assertEquals((Object)spouse, (Object)p.getSpouse());
        Assert.assertThat((Object)this.nodeFor(p), HasRelationshipMatcher.hasNoRelationship("spouse", this.getNodeState(spouse)));
        Person spouse2 = Person.persistedPerson("Rana", 5);
        p.setSpouse(spouse2);
        Assert.assertEquals((Object)spouse2, (Object)p.getSpouse());
    }

    @Test
    public void testCreateRelationshipOutsideTransactionAndPersist() {
        Person p = Person.persistedPerson("Michael", 35);
        Person spouse = Person.persistedPerson("Tina", 36);
        p.setSpouse(spouse);
        this.persist(p);
        Assert.assertEquals((Object)spouse, (Object)p.getSpouse());
        Assert.assertThat((Object)this.nodeFor(p), (Matcher)HasRelationshipMatcher.hasRelationship("spouse"));
        Person spouse2 = Person.persistedPerson("Rana", 5);
        p.setSpouse(spouse2);
        Assert.assertEquals((Object)spouse2, (Object)p.getSpouse());
    }

    private Node nodeFor(Person person) {
        return this.getNodeState(person);
    }

    @Test
    public void testGetPropertyOutsideTransaction() {
        Person p = Person.persistedPerson("Michael", 35);
        Assert.assertEquals((String)"Wrong age.", (long)35L, (long)p.getAge());
    }

    @Test
    public void testFindOutsideTransaction() {
        GraphRepository finder = this.neo4jTemplate.repositoryFor(Person.class);
        Assert.assertEquals((Object)false, (Object)finder.findAll().iterator().hasNext());
    }
}

