/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class RelationshipEntityTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    @Test
    @Transactional
    public void testRelationshipCreate() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                Relationship rel = this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"knows"), Direction.OUTGOING);
                Assert.assertEquals((Object)this.getRelationshipState(f), (Object)rel);
                Assert.assertEquals((Object)this.getNodeState(p2), (Object)rel.getEndNode());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void shouldNotCreateSameRelationshipTwice() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                Friendship f2 = p.knows(p2);
                Assert.assertEquals((Object)f, (Object)f2);
                Assert.assertEquals((long)1L, (long)IteratorUtil.count(p.getFriendships()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void shouldSupportSetOfRelationshipEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship friendship = p.knows(p2);
                Set<Friendship> result = p.getFriendshipsSet();
                Assert.assertEquals((long)1L, (long)IteratorUtil.count(result));
                Assert.assertEquals((Object)friendship, (Object)IteratorUtil.first(result));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void shouldSupportManagedSetAddOfRelationshipEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Set<Friendship> friends = p.getFriendshipsSet();
                Assert.assertEquals((long)0L, (long)IteratorUtil.count(friends));
                Friendship friendship = new Friendship(p, p2, 10);
                friends.add(friendship);
                Assert.assertEquals((long)1L, (long)IteratorUtil.count(friends));
                Assert.assertEquals((Object)friendship, (Object)IteratorUtil.first(friends));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void shouldSupportManagedSetRemoveOfRelationshipEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship friendship = p.knows(p2);
                Set<Friendship> friends = p.getFriendshipsSet();
                Assert.assertEquals((long)1L, (long)friends.size());
                Assert.assertEquals((Object)friendship, (Object)IteratorUtil.first(friends));
                friends.remove(friendship);
                Assert.assertEquals((long)0L, (long)IteratorUtil.count(friends));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipSetProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                f.setYears(1);
                Assert.assertEquals((Object)1, (Object)this.getRelationshipState(f).getProperty("Friendship.years"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipGetProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                this.getRelationshipState(f).setProperty("Friendship.years", (Object)1);
                Assert.assertEquals((long)1L, (long)f.getYears());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipGetStartNodeAndEndNode() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                Assert.assertEquals((Object)p, (Object)f.getPerson1());
                Assert.assertEquals((Object)p2, (Object)f.getPerson2());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetRelationshipToReturnsRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                Assert.assertEquals((Object)f, (Object)this.neo4jTemplate.getRelationshipBetween((Object)p, (Object)p2, Friendship.class, "knows"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetRelationshipTo() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                p.knows(p2);
                Assert.assertNotNull((Object)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)p, (NodeBacked)p2, (String)"knows"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testRemoveRelationshipEntity() {
        Friendship f;
        this.cleanDb();
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            Person p = Person.persistedPerson("Michael", 35);
            Person p2 = Person.persistedPerson("David", 25);
            f = p.knows(p2);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction tx2 = this.graphDatabaseService.beginTx();
        try {
            this.neo4jTemplate.delete((Object)f);
            tx2.success();
        }
        finally {
            tx2.finish();
        }
        Assert.assertFalse((String)"Unexpected relationship entity found.", (boolean)this.friendshipRepository.findAll().iterator().hasNext());
    }

    @Test
    public void testRemoveRelationshipEntityIfNodeEntityIsRemoved() {
        Person p;
        this.cleanDb();
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            p = Person.persistedPerson("Michael", 35);
            Person p2 = Person.persistedPerson("David", 25);
            p.knows(p2);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction tx2 = this.graphDatabaseService.beginTx();
        try {
            this.neo4jTemplate.delete((Object)p);
            tx2.success();
        }
        finally {
            tx2.finish();
        }
        Assert.assertFalse((String)"Unexpected relationship entity found.", (boolean)this.friendshipRepository.findAll().iterator().hasNext());
    }

    static {
        RelationshipEntityTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RelationshipEntityTests.java", RelationshipEntityTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipCreate", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldNotCreateSameRelationshipTwice", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldSupportSetOfRelationshipEntities", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 64);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldSupportManagedSetAddOfRelationshipEntities", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 75);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldSupportManagedSetRemoveOfRelationshipEntities", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 88);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipSetProperty", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 101);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipGetProperty", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 111);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipGetStartNodeAndEndNode", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 121);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetRelationshipToReturnsRelationship", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 131);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetRelationshipTo", "org.springframework.data.neo4j.aspects.support.RelationshipEntityTests", "", "", "", "void"), 141);
    }
}

