/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Collections;
import java.util.HashSet;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class TraversalTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Test
    @Transactional
    public void testTraverseFromGroupToPeople() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.setName("dev");
                group.addPerson(p);
                TraversalDescription traversalDescription = Traversal.description().relationships((RelationshipType)DynamicRelationshipType.withName((String)"persons")).evaluator(Evaluators.excludeStartPosition());
                Iterable people = this.neo4jTemplate.traverse((Object)group, Person.class, traversalDescription);
                HashSet<Person> found = new HashSet<Person>();
                for (Person person : people) {
                    found.add(person);
                }
                Assert.assertEquals(Collections.singleton(p), found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testTraverseFromGroupToPeoplePaths() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.setName("dev");
                group.addPerson(p);
                TraversalDescription traversalDescription = Traversal.description().relationships((RelationshipType)DynamicRelationshipType.withName((String)"persons"), Direction.OUTGOING).evaluator(Evaluators.excludeStartPosition());
                Iterable paths = this.neo4jTemplate.traverse((Object)group, EntityPath.class, traversalDescription);
                for (EntityPath path : paths) {
                    Assert.assertEquals((Object)group, (Object)path.startEntity(new Class[0]));
                    Assert.assertEquals((Object)p, (Object)path.endEntity(new Class[0]));
                    Assert.assertEquals((long)1L, (long)path.length());
                }
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testTraverseFieldFromGroupToPeople() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.addPerson(p);
                Assert.assertEquals(Collections.singletonList(p), (Object)IteratorUtil.asCollection(group.getPeople()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testTraverseFieldFromGroupToPeopleNodes() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.addPerson(p);
                Assert.assertEquals(Collections.singletonList(this.getNodeState(p)), (Object)IteratorUtil.asCollection(group.getPeopleNodes()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testTraverseFieldFromGroupToPeopleRelationships() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.addPerson(p);
                Relationship personRelationship = this.getNodeState(group).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"persons"), Direction.OUTGOING);
                Assert.assertEquals(Collections.singletonList(personRelationship), (Object)IteratorUtil.asCollection(group.getPeopleRelationships()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testTraverseFromGroupToPeopleWithFinder() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                GraphRepository finder = this.neo4jTemplate.repositoryFor(Person.class);
                Person p = Person.persistedPerson("Michael", 35);
                Group group = this.persist(new Group());
                group.setName("dev");
                group.addPerson(p);
                TraversalDescription traversalDescription = new TraversalDescriptionImpl().relationships((RelationshipType)DynamicRelationshipType.withName((String)"persons")).evaluator(Evaluators.excludeStartPosition());
                Iterable people = finder.findAllByTraversal((Object)group, traversalDescription);
                HashSet<Person> found = new HashSet<Person>();
                for (Person person : people) {
                    found.add(person);
                }
                Assert.assertEquals(Collections.singleton(p), found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        TraversalTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TraversalTests.java", TraversalTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFromGroupToPeople", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFromGroupToPeoplePaths", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFieldFromGroupToPeople", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFieldFromGroupToPeopleNodes", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFieldFromGroupToPeopleRelationships", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 99);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testTraverseFromGroupToPeopleWithFinder", "org.springframework.data.neo4j.aspects.support.TraversalTests", "", "", "", "void"), 109);
    }
}

