/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.typerepresentation;

import java.util.Collection;
import java.util.Map;
import javax.persistence.Transient;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.aspects.Car;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.Toyota;
import org.springframework.data.neo4j.aspects.Volvo;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategy;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml", "classpath:org/springframework/data/neo4j/aspects/support/SubReferenceTypeRepresentationStrategyOverride-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class SubReferenceNodeTypeRepresentationStrategyTests
extends EntityTestBase {
    @Autowired
    private SubReferenceNodeTypeRepresentationStrategy nodeTypeRepresentationStrategy;
    @Autowired
    EntityStateHandler entityStateHandler;
    private Node thingNode;
    private Thing thing;
    private SubThing subThing;
    private Node subThingNode;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    @Before
    public void setUp() {
        this.createThing();
    }

    @Test
    @Transactional
    public void testPostEntityCreation() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Node typeNode = this.getInstanceofRelationship(this.thingNode).getOtherNode(this.thingNode);
                Assert.assertNotNull((String)"type node for thing exists", (Object)typeNode);
                Assert.assertEquals((String)"type node has property of type Thing.class", (Object)this.typeOf(Thing.class).getAlias(), (Object)typeNode.getProperty("class"));
                Assert.assertEquals((String)"one thing has been created", (Object)2, (Object)typeNode.getProperty("count"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void gettingTypeFromNonTypeNodeShouldThrowAnDescriptiveException() throws Exception {
        Node referenceNode = this.neo4jTemplate.getReferenceNode();
        this.nodeTypeRepresentationStrategy.readAliasFrom(referenceNode);
    }

    @Test(expected=IllegalArgumentException.class)
    public void gettingTypeFromNullShouldFail() throws Exception {
        this.nodeTypeRepresentationStrategy.readAliasFrom(null);
    }

    private void createThing() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        try {
            this.thingNode = this.neo4jTemplate.createNode();
            this.thing = (Thing)this.neo4jTemplate.setPersistentState((Object)new Thing(), (PropertyContainer)this.thingNode);
            this.nodeTypeRepresentationStrategy.writeTypeTo(this.thingNode, this.typeOf(Thing.class));
            this.thing.setName("thing");
            this.subThingNode = this.neo4jTemplate.createNode();
            this.subThing = (SubThing)this.neo4jTemplate.setPersistentState((Object)new SubThing(), (PropertyContainer)this.subThingNode);
            this.nodeTypeRepresentationStrategy.writeTypeTo(this.subThingNode, this.typeOf(SubThing.class));
            this.subThing.setName("subThing");
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Node node(Thing thing) {
        return this.getNodeState(thing);
    }

    @Test
    @Transactional
    public void testPreEntityRemoval() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Node typeNode = this.getInstanceofRelationship(this.thingNode).getOtherNode(this.thingNode);
                this.nodeTypeRepresentationStrategy.preEntityRemoval(this.node(this.thing));
                Assert.assertNull((String)"instanceof relationship was removed", (Object)this.getInstanceofRelationship(this.thingNode));
                Assert.assertNotNull((String)"instanceof relationship was removed", (Object)this.getInstanceofRelationship(this.subThingNode));
                Assert.assertEquals((String)"no things left after removal", (Object)1, (Object)typeNode.getProperty("count"));
                this.nodeTypeRepresentationStrategy.preEntityRemoval(this.node(this.subThing));
                Assert.assertNull((String)"instanceof relationship was removed", (Object)this.getInstanceofRelationship(this.subThingNode));
                Assert.assertEquals((String)"no things left after removal", (Object)0, (Object)typeNode.getProperty("count"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Transactional
    private Relationship getInstanceofRelationship(Node node) {
        Relationship relationship;
        try {
            Relationship relationship2;
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                relationship2 = node.getSingleRelationship(SubReferenceNodeTypeRepresentationStrategy.INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
            relationship = relationship2;
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
        return relationship;
    }

    @Test
    @Transactional
    public void testCount() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Assert.assertEquals((String)"one thing created", (long)2L, (long)this.nodeTypeRepresentationStrategy.count(this.typeOf(Thing.class)));
                Assert.assertEquals((String)"one thing created", (long)1L, (long)this.nodeTypeRepresentationStrategy.count(this.typeOf(SubThing.class)));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetJavaType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Assert.assertEquals((String)"class in graph is thing", (Object)this.typeOf(Thing.class).getAlias(), (Object)this.nodeTypeRepresentationStrategy.readAliasFrom(this.thingNode));
                Assert.assertEquals((String)"class in graph is thing", Thing.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.thingNode));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllThings() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Collection things = IteratorUtil.asCollection((Iterable)this.nodeTypeRepresentationStrategy.findAll(this.typeOf(Thing.class)));
                Assert.assertEquals((String)"one thing created and found", (long)2L, (long)things.size());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllSubThings() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Collection things = IteratorUtil.asCollection((Iterable)this.nodeTypeRepresentationStrategy.findAll(this.typeOf(SubThing.class)));
                Assert.assertEquals((String)"one thing created and found", (long)1L, (long)things.size());
                Assert.assertEquals((String)"one thing created and found", (Object)this.entityStateHandler.getPersistentState((Object)this.subThing), (Object)IteratorUtil.first((Iterable)things));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testInstantiateConcreteClass() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                this.log.debug("testInstantiateConcreteClass");
                Person p = Person.persistedPerson("Michael", 35);
                Car c = this.persist(new Volvo());
                p.setCar(c);
                Assert.assertEquals((String)"Wrong concrete class.", Volvo.class, p.getCar().getClass());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testInstantiateConcreteClassWithFinder() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                this.log.debug("testInstantiateConcreteClassWithFinder");
                this.persist(new Volvo());
                GraphRepository finder = this.neo4jTemplate.repositoryFor(Car.class);
                Assert.assertEquals((String)"Wrong concrete class.", Volvo.class, ((Car)finder.findAll().iterator().next()).getClass());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCountSubclasses() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                this.log.warn("testCountSubclasses");
                this.persist(new Volvo());
                this.log.warn("Created volvo");
                this.persist(new Toyota());
                this.log.warn("Created volvo");
                Assert.assertEquals((String)"Wrong count for Volvo.", (long)1L, (long)this.neo4jTemplate.repositoryFor(Volvo.class).count());
                Assert.assertEquals((String)"Wrong count for Toyota.", (long)1L, (long)this.neo4jTemplate.repositoryFor(Toyota.class).count());
                Assert.assertEquals((String)"Wrong count for Car.", (long)2L, (long)this.neo4jTemplate.repositoryFor(Car.class).count());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCountClasses() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                Person.persistedPerson("Michael", 36);
                Person.persistedPerson("David", 25);
                Assert.assertEquals((String)"Wrong Person instance count.", (long)2L, (long)this.neo4jTemplate.repositoryFor(Person.class).count());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndInferType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Thing newThing = (Thing)this.neo4jTemplate.createEntityFromStoredType((PropertyContainer)this.node(this.thing), this.neo4jTemplate.getMappingPolicy((Object)this.thing));
                Assert.assertEquals((Object)this.thing, (Object)newThing);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndSpecifyType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_12);
                Thing newThing = (Thing)this.neo4jTemplate.createEntityFromState((PropertyContainer)this.node(this.subThing), Thing.class, this.neo4jTemplate.getMappingPolicy((Object)this.subThing));
                Assert.assertEquals((Object)this.subThing, (Object)newThing);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testSaveTwice() throws Exception {
        Thing thing = new Thing();
        thing.setName("Foo");
        thing = (Thing)this.neo4jTemplate.save((Object)thing);
        thing.setName("Bar");
        thing = (Thing)this.neo4jTemplate.save((Object)thing);
        this.neo4jTemplate.findOne(Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)thing).longValue(), Thing.class);
    }

    @Test
    @Transactional
    public void testProjectEntity() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_13);
                Unrelated other = (Unrelated)this.neo4jTemplate.projectTo((Object)this.thing, Unrelated.class);
                Assert.assertEquals((Object)"thing", (Object)other.getName());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        SubReferenceNodeTypeRepresentationStrategyTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SubReferenceNodeTypeRepresentationStrategyTests.java", SubReferenceNodeTypeRepresentationStrategyTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testPostEntityCreation", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testPreEntityRemoval", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 119);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCountClasses", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "", "void"), 199);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndInferType", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 208);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndSpecifyType", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 215);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testProjectEntity", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 232);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInstanceofRelationship", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "org.neo4j.graphdb.Node", "node", "", "org.neo4j.graphdb.Relationship"), 132);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCount", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 138);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetJavaType", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 145);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllThings", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 153);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllSubThings", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "", "void"), 160);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testInstantiateConcreteClass", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "", "void"), 168);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testInstantiateConcreteClassWithFinder", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "", "void"), 178);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCountSubclasses", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests", "", "", "", "void"), 187);
    }

    public static class SubThing
    extends Thing {
        public SubThing() {
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }
    }

    @NodeEntity
    public static class Thing
    implements NodeBacked {
        String name;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public Thing() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public String getName() {
            Thing thing = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)thing);
            return (String)Thing.name_aroundBody1$advice(this, thing, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
        }

        public void setName(String name) {
            String string = name;
            Thing thing = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)thing, (Object)string);
            Thing.name_aroundBody3$advice(this, thing, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            Thing.ajc$preClinit();
        }

        private static final /* synthetic */ Object name_aroundBody1$advice(Thing ajc$this, Thing target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                NodeBacked nodeBacked = entity;
                return target.name;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }

        private static final /* synthetic */ Object name_aroundBody3$advice(Thing ajc$this, Thing target, String name, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.name = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.name = (String)object;
            return null;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SubReferenceNodeTypeRepresentationStrategyTests.java", Thing.class);
            ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests$Thing", "java.lang.String"), 251);
            ajc$tjp_1 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests$Thing", "java.lang.String"), 255);
        }
    }

    @NodeEntity
    public static class Unrelated
    implements NodeBacked {
        String name;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public Unrelated() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public String getName() {
            Unrelated unrelated = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)unrelated);
            return (String)Unrelated.name_aroundBody1$advice(this, unrelated, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            Unrelated.ajc$preClinit();
        }

        private static final /* synthetic */ Object name_aroundBody1$advice(Unrelated ajc$this, Unrelated target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                NodeBacked nodeBacked = entity;
                return target.name;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SubReferenceNodeTypeRepresentationStrategyTests.java", Unrelated.class);
            ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategyTests$Unrelated", "java.lang.String"), 242);
        }
    }
}

